package org.pdb.beans;

/**
 *  Data items in the PHASING_SET_REFLN category record the values
 *  of the measured structure factors used in a phasing experiment.
 *  This list may contain information from a number of different
 *  data sets;  attribute set_id in category phasing_set_refln indicates the data set
 *  to which a given record corresponds.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for the 15,15,32
 *  reflection of an Hg/Pt derivative of protein NS1.
 *  <PDBx:phasing_set_reflnCategory>
 *  <PDBx:phasing_set_refln set_id="NS1-96" index_h="15" index_k="15" index_l="32">
 *  <PDBx:F_meas_au>181.79</PDBx:F_meas_au>
 *  <PDBx:F_meas_sigma_au>3.72</PDBx:F_meas_sigma_au>
 *  </PDBx:phasing_set_refln>
 *  </PDBx:phasing_set_reflnCategory>
 * </pre>
 */
public class Phasing_set_refln 
{
		protected java.lang.Float F_meas;


	/**
	 *  The measured value of the structure factor for this reflection
	 *  in this data set in electrons.
	 */
	public java.lang.Float getF_meas() 
	{
		return F_meas;
	}
 
	public void setF_meas(java.lang.Float F_meas)
	{
		this.F_meas = F_meas;
	}

 	protected java.lang.Float F_meas_au;


	/**
	 *  The measured value of the structure factor for this reflection
	 *  in this data set in arbitrary units.
	 */
	public java.lang.Float getF_meas_au() 
	{
		return F_meas_au;
	}
 
	public void setF_meas_au(java.lang.Float F_meas_au)
	{
		this.F_meas_au = F_meas_au;
	}

 	protected java.lang.Float F_meas_sigma;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute F_meas in category phasing_set_refln in electrons.
	 */
	public java.lang.Float getF_meas_sigma() 
	{
		return F_meas_sigma;
	}
 
	public void setF_meas_sigma(java.lang.Float F_meas_sigma)
	{
		this.F_meas_sigma = F_meas_sigma;
	}

 	protected java.lang.Float F_meas_sigma_au;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute F_meas_au in category phasing_set_refln in arbitrary units.
	 */
	public java.lang.Float getF_meas_sigma_au() 
	{
		return F_meas_sigma_au;
	}
 
	public void setF_meas_sigma_au(java.lang.Float F_meas_sigma_au)
	{
		this.F_meas_sigma_au = F_meas_sigma_au;
	}

 	protected java.lang.Integer index_h;


	/**
	 *  Miller index h of this reflection in this data set.
	 */
	public java.lang.Integer getIndex_h() 
	{
		return index_h;
	}
 
	public void setIndex_h(java.lang.Integer index_h)
	{
		this.index_h = index_h;
	}

 	protected java.lang.Integer index_k;


	/**
	 *  Miller index k of this reflection in this data set.
	 */
	public java.lang.Integer getIndex_k() 
	{
		return index_k;
	}
 
	public void setIndex_k(java.lang.Integer index_k)
	{
		this.index_k = index_k;
	}

 	protected java.lang.Integer index_l;


	/**
	 *  Miller index l of this reflection in this data set.
	 */
	public java.lang.Integer getIndex_l() 
	{
		return index_l;
	}
 
	public void setIndex_l(java.lang.Integer index_l)
	{
		this.index_l = index_l;
	}

 	protected java.lang.String set_id;


	/**
	 *  This data item is a pointer to  attribute id in category phasing_set in the
	 *  PHASING_SET category.
	 */
	public java.lang.String getSet_id() 
	{
		return set_id;
	}
 
	public void setSet_id(java.lang.String set_id)
	{
		this.set_id = set_id;
	}

 }
