package org.pdb.beans;

/**
 *  Data items in the PUBL_MANUSCRIPT_INCL category allow
 *  the authors of a manuscript submitted for publication to list
 *  data names that should be added to the standard request list
 *  used by the journal printing software.
 *  
 * <pre>
 *  Example 1 - hypothetical example.
 *  <PDBx:publ_manuscript_inclCategory>
 *  <PDBx:publ_manuscript_incl entry_id="EXAMHYPO">
 *  <PDBx:extra_item>_atom_site.symmetry_multiplicity</PDBx:extra_item>
 *  <PDBx:extra_info>to emphasise special sites</PDBx:extra_info>
 *  <PDBx:extra_defn>yes</PDBx:extra_defn>
 *  </PDBx:publ_manuscript_incl>
 *  <PDBx:publ_manuscript_incl entry_id="EXAMHYPO">
 *  <PDBx:extra_item>_chemical.compound_source</PDBx:extra_item>
 *  <PDBx:extra_info>rare material, unusual source</PDBx:extra_info>
 *  <PDBx:extra_defn>yes</PDBx:extra_defn>
 *  </PDBx:publ_manuscript_incl>
 *  <PDBx:publ_manuscript_incl entry_id="EXAMHYPO">
 *  <PDBx:extra_item>_reflns.d_resolution_high</PDBx:extra_item>
 *  <PDBx:extra_info>limited data is a problem here</PDBx:extra_info>
 *  <PDBx:extra_defn>yes</PDBx:extra_defn>
 *  </PDBx:publ_manuscript_incl>
 *  <PDBx:publ_manuscript_incl entry_id="EXAMHYPO">
 *  <PDBx:extra_item>_crystal.magnetic_permeability</PDBx:extra_item>
 *  <PDBx:extra_info>unusual value for this material</PDBx:extra_info>
 *  <PDBx:extra_defn>no</PDBx:extra_defn>
 *  </PDBx:publ_manuscript_incl>
 *  </PDBx:publ_manuscript_inclCategory>
 * </pre>
 */
public class Publ_manuscript_incl 
{
		protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String extra_defn;


	/**
	 *  Flags whether the corresponding data item marked for inclusion
	 *  in a journal request list is a standard CIF definition or not.
	 */
	public java.lang.String getExtra_defn() 
	{
		return extra_defn;
	}
 
	public void setExtra_defn(java.lang.String extra_defn)
	{
		this.extra_defn = extra_defn;
	}

 	protected java.lang.String extra_info;


	/**
	 *  A short note indicating the reason why the author wishes the
	 *  corresponding data item marked for inclusion in the journal
	 *  request list to be published.
	 *  to emphasise very special sites
	 *  rare material from unusual source
	 *  the limited data is a problem here
	 *  a new data quantity needed here
	 */
	public java.lang.String getExtra_info() 
	{
		return extra_info;
	}
 
	public void setExtra_info(java.lang.String extra_info)
	{
		this.extra_info = extra_info;
	}

 	protected java.lang.String extra_item;


	/**
	 *  Specifies the inclusion of specific data into a manuscript
	 *  which are not normally requested by the journal. The values
	 *  of this item are the extra data names (which MUST be enclosed
	 *  in single quotes) that will be added to the journal request list.
	 *  _atom_site.symmetry_multiplicity
	 *  _chemical.compound_source
	 *  _reflns.d_resolution_high
	 *  _crystal.magnetic_permeability
	 */
	public java.lang.String getExtra_item() 
	{
		return extra_item;
	}
 
	public void setExtra_item(java.lang.String extra_item)
	{
		this.extra_item = extra_item;
	}

 }
