package org.pdb.beans;

/**
 *  Data items in the REFINE_B_ISO category record details about
 *  the treatment of isotropic B factors (displacement parameters)
 *  during refinement.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:refine_B_isoCategory>
 *  <PDBx:refine_B_iso class="protein">
 *  <PDBx:treatment>isotropic</PDBx:treatment>
 *  </PDBx:refine_B_iso>
 *  <PDBx:refine_B_iso class="solvent">
 *  <PDBx:treatment>isotropic</PDBx:treatment>
 *  </PDBx:refine_B_iso>
 *  <PDBx:refine_B_iso class="inhibitor">
 *  <PDBx:treatment>isotropic</PDBx:treatment>
 *  </PDBx:refine_B_iso>
 *  </PDBx:refine_B_isoCategory>
 * </pre>
 */
public class Refine_B_iso 
{
		protected java.lang.String class_;


	/**
	 *  A class of atoms treated similarly for isotropic B-factor
	 *  (displacement-parameter) refinement.
	 *  all
	 *  protein
	 *  solvent
	 *  sugar-phosphate backbone
	 */
	public java.lang.String getClass_() 
	{
		return class_;
	}
 
	public void setClass_(java.lang.String class_)
	{
		this.class_ = class_;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of the isotropic B-factor
	 *  (displacement-parameter) refinement for the class of atoms
	 *  described in  attribute class in category refine_B_iso.
	 *  The temperature factors of atoms in the side
	 *  chain of Arg 92 were held fixed due to
	 *  unstable behavior in refinement.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String treatment;


	/**
	 *  The treatment of isotropic B-factor (displacement-parameter)
	 *  refinement for a class of atoms defined in  attribute class in category refine_B_iso.
	 */
	public java.lang.String getTreatment() 
	{
		return treatment;
	}
 
	public void setTreatment(java.lang.String treatment)
	{
		this.treatment = treatment;
	}

 	protected java.lang.Float value;


	/**
	 *  The value of the isotropic B factor (displacement parameter)
	 *  assigned to a class of atoms defined in  attribute class.
	 *  in category refine_B_iso Meaningful only for atoms with fixed isotropic B factors.
	 */
	public java.lang.Float getValue() 
	{
		return value;
	}
 
	public void setValue(java.lang.Float value)
	{
		this.value = value;
	}

 }
