package org.pdb.beans;

/**
 *  Data items in the REFINE_FUNCT_MINIMIZED category record
 *  details about the individual terms of the function minimized
 *  during refinement.
 *  
 * <pre>
 *  Example 1 - based on RESTRAIN refinement for the CCP4 test data set
 *  toxd.
 *  <PDBx:refine_funct_minimizedCategory>
 *  <PDBx:refine_funct_minimized type="sum(W*Delta(Amplitude)^2">
 *  <PDBx:number_terms>3009</PDBx:number_terms>
 *  <PDBx:residual>1621.3</PDBx:residual>
 *  </PDBx:refine_funct_minimized>
 *  <PDBx:refine_funct_minimized type="sum(W*Delta(Plane+Rigid)^2">
 *  <PDBx:number_terms>85</PDBx:number_terms>
 *  <PDBx:residual>56.68</PDBx:residual>
 *  </PDBx:refine_funct_minimized>
 *  <PDBx:refine_funct_minimized type="sum(W*Delta(Distance)^2">
 *  <PDBx:number_terms>1219</PDBx:number_terms>
 *  <PDBx:residual>163.59</PDBx:residual>
 *  </PDBx:refine_funct_minimized>
 *  <PDBx:refine_funct_minimized type="sum(W*Delta(U-tempfactors)^2">
 *  <PDBx:number_terms>1192</PDBx:number_terms>
 *  <PDBx:residual>69.338</PDBx:residual>
 *  </PDBx:refine_funct_minimized>
 *  </PDBx:refine_funct_minimizedCategory>
 * </pre>
 */
public class Refine_funct_minimized 
{
		protected java.lang.Integer number_terms;


	/**
	 *  The number of observations in this term.  For example, if the
	 *  term is a residual of the X-ray intensities, this item would
	 *  contain the number of reflections used in the refinement.
	 */
	public java.lang.Integer getNumber_terms() 
	{
		return number_terms;
	}
 
	public void setNumber_terms(java.lang.Integer number_terms)
	{
		this.number_terms = number_terms;
	}

 	protected java.lang.Float residual;


	/**
	 *  The residual for this term of the function that was minimized
	 *  during the refinement.
	 */
	public java.lang.Float getResidual() 
	{
		return residual;
	}
 
	public void setResidual(java.lang.Float residual)
	{
		this.residual = residual;
	}

 	protected java.lang.String type;


	/**
	 *  The type of the function being minimized.
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 	protected java.lang.Float weight;


	/**
	 *  The weight applied to this term of the function that was
	 *  minimized during the refinement.
	 */
	public java.lang.Float getWeight() 
	{
		return weight;
	}
 
	public void setWeight(java.lang.Float weight)
	{
		this.weight = weight;
	}

 }
