package org.pdb.beans;

/**
 *  Data items in the REFINE_LS_CLASS category record details
 *  about the reflections used for the structure refinement
 *  for each reflection class separately.
 *  
 * <pre>
 *  Example 1 - data for a modulated structure from van Smaalen
 *  [J. Phys. Condens. Matter (1991),  3, 1247-1263].
 *  <PDBx:refine_ls_classCategory>
 *  <PDBx:refine_ls_class code="Main">
 *  <PDBx:R_factor_gt>0.057</PDBx:R_factor_gt>
 *  </PDBx:refine_ls_class>
 *  <PDBx:refine_ls_class code="Com">
 *  <PDBx:R_factor_gt>0.074</PDBx:R_factor_gt>
 *  </PDBx:refine_ls_class>
 *  <PDBx:refine_ls_class code="NbRefls">
 *  <PDBx:R_factor_gt>0.064</PDBx:R_factor_gt>
 *  </PDBx:refine_ls_class>
 *  <PDBx:refine_ls_class code="LaRefls">
 *  <PDBx:R_factor_gt>0.046</PDBx:R_factor_gt>
 *  </PDBx:refine_ls_class>
 *  <PDBx:refine_ls_class code="Sat1">
 *  <PDBx:R_factor_gt>0.112</PDBx:R_factor_gt>
 *  </PDBx:refine_ls_class>
 *  <PDBx:refine_ls_class code="Sat2">
 *  <PDBx:R_factor_gt>0.177</PDBx:R_factor_gt>
 *  </PDBx:refine_ls_class>
 *  </PDBx:refine_ls_classCategory>
 * </pre>
 */
public class Refine_ls_class 
{
		protected java.lang.Float R_Fsqd_factor;


	/**
	 *  For each reflection class, the residual factor R(F^2^) calculated
	 *  on the squared amplitudes of the observed and calculated
	 *  structure factors, for the reflections judged significantly
	 *  intense (i.e. satisfying the threshold specified by
	 *  attribute threshold_expression) in category reflns and included in the refinement.
	 *  
	 *  The reflections also satisfy the resolution limits established
	 *  by _refine_ls_class.d_res_high and _refine_ls_class.d_res_low.
	 *  
	 *  sum | F(obs)^2^ - F(calc)^2^ |
	 *  R(Fsqd) = -------------------------------
	 *  sum F(obs)^2^
	 *  
	 *  F(obs)^2^  = squares of the observed structure-factor amplitudes
	 *  F(calc)^2^ = squares of the calculated structure-factor
	 *  amplitudes
	 *  
	 *  and the sum is taken over the reflections of this class.
	 */
	public java.lang.Float getR_Fsqd_factor() 
	{
		return R_Fsqd_factor;
	}
 
	public void setR_Fsqd_factor(java.lang.Float R_Fsqd_factor)
	{
		this.R_Fsqd_factor = R_Fsqd_factor;
	}

 	protected java.lang.Float R_I_factor;


	/**
	 *  For each reflection class, the residual factor R(I) for the
	 *  reflections judged significantly intense (i.e. satisfying the
	 *  threshold specified by  attribute threshold_expression) in category reflns and
	 *  included in the refinement.
	 *  
	 *  This is most often calculated in Rietveld refinements
	 *  against powder data, where it is referred to as R~B~ or R~Bragg~
	 *  
	 *  sum | I(obs) - I(calc) |
	 *  R(I) =  ------------------------
	 *  sum | I(obs) |
	 *  
	 *  I(obs)  = the net observed intensities
	 *  I(calc) = the net calculated intensities
	 *  
	 *  and the sum is taken over the reflections of this class.
	 */
	public java.lang.Float getR_I_factor() 
	{
		return R_I_factor;
	}
 
	public void setR_I_factor(java.lang.Float R_I_factor)
	{
		this.R_I_factor = R_I_factor;
	}

 	protected java.lang.Float R_factor_all;


	/**
	 *  For each reflection class, the residual factor for all
	 *  reflections satisfying the resolution limits established by
	 *  _refine_ls_class.d_res_high and _refine_ls_class.d_res_low.
	 *  This is the conventional R factor. See also the
	 *  definition of  attribute wR_factor_all.
	 *  in category refine_ls_class
	 *  sum | F(obs) - F(calc) |
	 *  R = ------------------------
	 *  sum | F(obs) |
	 *  
	 *  F(obs)  = the observed structure-factor amplitudes
	 *  F(calc) = the calculated structure-factor amplitudes
	 *  
	 *  and the sum is taken over the reflections of this class.
	 */
	public java.lang.Float getR_factor_all() 
	{
		return R_factor_all;
	}
 
	public void setR_factor_all(java.lang.Float R_factor_all)
	{
		this.R_factor_all = R_factor_all;
	}

 	protected java.lang.Float R_factor_gt;


	/**
	 *  For each reflection class, the residual factor for significantly
	 *  intense reflections (see  attribute threshold_expression) in category reflns included
	 *  in the refinement.
	 *  The reflections also satisfy the resolution limits established by
	 *  _refine_ls_class.d_res_high and _refine_ls_class.d_res_low.
	 *  This is the conventional R factor. See also the definition of
	 *  attribute wR_factor_all.
	 *  in category refine_ls_class
	 *  sum | F(obs) - F(calc) |
	 *  R = ------------------------
	 *  sum | F(obs) |
	 *  
	 *  F(obs)  = the observed structure-factor amplitudes
	 *  F(calc) = the calculated structure-factor amplitudes
	 *  
	 *  and the sum is taken over the reflections of this class.
	 */
	public java.lang.Float getR_factor_gt() 
	{
		return R_factor_gt;
	}
 
	public void setR_factor_gt(java.lang.Float R_factor_gt)
	{
		this.R_factor_gt = R_factor_gt;
	}

 	protected java.lang.String code;


	/**
	 *  The code identifying a certain reflection class. This code must
	 *  match a  attribute code in category reflns_class.
	 *  1
	 *  m1
	 *  s2
	 */
	public java.lang.String getCode() 
	{
		return code;
	}
 
	public void setCode(java.lang.String code)
	{
		this.code = code;
	}

 	protected java.lang.Float d_res_high;


	/**
	 *  For each reflection class, the lowest value in angstroms
	 *  for the interplanar spacings for the reflections used in the
	 *  refinement. This is called the highest resolution.
	 */
	public java.lang.Float getD_res_high() 
	{
		return d_res_high;
	}
 
	public void setD_res_high(java.lang.Float d_res_high)
	{
		this.d_res_high = d_res_high;
	}

 	protected java.lang.Float d_res_low;


	/**
	 *  For each reflection class, the highest value in angstroms
	 *  for the interplanar spacings for the reflections used in the
	 *  refinement. This is called the lowest resolution.
	 */
	public java.lang.Float getD_res_low() 
	{
		return d_res_low;
	}
 
	public void setD_res_low(java.lang.Float d_res_low)
	{
		this.d_res_low = d_res_low;
	}

 	protected java.lang.Float wR_factor_all;


	/**
	 *  For each reflection class, the weighted residual factor for all
	 *  reflections included in the refinement. The reflections also
	 *  satisfy the resolution limits established by
	 *  _refine_ls_class.d_res_high and _refine_ls_class.d_res_low.
	 *  See also the  attribute R_factor_ in category refine_ls_class definitions.
	 *  
	 *  ( sum w [ Y(obs) - Y(calc) ]^2^  )^1/2^
	 *  wR = ( ------------------------------ )
	 *  (         sum w Y(obs)^2^       )
	 *  
	 *  Y(obs)  = the observed amplitude specified by
	 *  attribute ls_structure_factor_coef
	 *  in category refine Y(calc) = the calculated amplitude specified by
	 *  attribute ls_structure_factor_coef
	 *  in category refine w       = the least-squares weight
	 *  
	 *  and the sum is taken over the reflections of this class.
	 */
	public java.lang.Float getWR_factor_all() 
	{
		return wR_factor_all;
	}
 
	public void setWR_factor_all(java.lang.Float wR_factor_all)
	{
		this.wR_factor_all = wR_factor_all;
	}

 }
