package org.pdb.beans;

/**
 *  Data items in the REFINE_LS_RESTR_NCS category record details
 *  about the restraints applied to atom positions in domains
 *  related by noncrystallographic symmetry during least-squares
 *  refinement, and also about the deviation of the restrained
 *  atomic parameters at the end of the refinement.  It is
 *  expected that these values will only be reported once for each
 *  set of restrained domains.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for the collagen-like
 *  peptide, HYP-.
 *  <PDBx:refine_ls_restr_ncsCategory>
 *  <PDBx:refine_ls_restr_ncs dom_id="d2" pdbx_asym_id="A" pdbx_type="medium positional">
 *  <PDBx:weight_position>300.0</PDBx:weight_position>
 *  <PDBx:weight_B_iso>2.0</PDBx:weight_B_iso>
 *  <PDBx:rms_dev_position>0.09</PDBx:rms_dev_position>
 *  <PDBx:rms_dev_B_iso>0.16</PDBx:rms_dev_B_iso>
 *  <PDBx:ncs_model_details>
 *  NCS restraint for pseudo-twofold symmetry between domains
 *  d1 and d2.  Position weight coefficient given in
 *  Kcal/(mol \&#37;A^2^) and isotropic B weight coefficient given
 *  in \&#37;A^2^.</PDBx:ncs_model_details>
 *  </PDBx:refine_ls_restr_ncs>
 *  </PDBx:refine_ls_restr_ncsCategory>
 * </pre>
 */
public class Refine_ls_restr_ncs 
{
		protected java.lang.String dom_id;


	/**
	 *  This data item is a pointer to  attribute id in category struct_ncs_dom in the
	 *  STRUCT_NCS_DOM category.
	 */
	public java.lang.String getDom_id() 
	{
		return dom_id;
	}
 
	public void setDom_id(java.lang.String dom_id)
	{
		this.dom_id = dom_id;
	}

 	protected java.lang.String ncs_model_details;


	/**
	 *  Special aspects of the manner in which noncrystallographic
	 *  restraints were applied to atomic parameters in the domain
	 *  specified by  attribute dom_id in category refine_ls_restr_ncs and equivalent
	 *  atomic parameters in the domains against which it was restrained.
	 */
	public java.lang.String getNcs_model_details() 
	{
		return ncs_model_details;
	}
 
	public void setNcs_model_details(java.lang.String ncs_model_details)
	{
		this.ncs_model_details = ncs_model_details;
	}

 	protected java.lang.String pdbx_asym_id;


	/**
	 *  record the chain ID.
	 */
	public java.lang.String getPdbx_asym_id() 
	{
		return pdbx_asym_id;
	}
 
	public void setPdbx_asym_id(java.lang.String pdbx_asym_id)
	{
		this.pdbx_asym_id = pdbx_asym_id;
	}

 	protected java.lang.Integer pdbx_number;


	/**
	 *  record the residue number .
	 */
	public java.lang.Integer getPdbx_number() 
	{
		return pdbx_number;
	}
 
	public void setPdbx_number(java.lang.Integer pdbx_number)
	{
		this.pdbx_number = pdbx_number;
	}

 	protected java.lang.Float pdbx_rms;


	/**
	 *  record the standard divation between one segment to another
	 */
	public java.lang.Float getPdbx_rms() 
	{
		return pdbx_rms;
	}
 
	public void setPdbx_rms(java.lang.Float pdbx_rms)
	{
		this.pdbx_rms = pdbx_rms;
	}

 	protected java.lang.String pdbx_type;


	/**
	 *  record the type of NCS restraint. (for example: tight positional)
	 */
	public java.lang.String getPdbx_type() 
	{
		return pdbx_type;
	}
 
	public void setPdbx_type(java.lang.String pdbx_type)
	{
		this.pdbx_type = pdbx_type;
	}

 	protected java.lang.Float pdbx_weight;


	/**
	 *  record the weight used for NCS restraint.
	 */
	public java.lang.Float getPdbx_weight() 
	{
		return pdbx_weight;
	}
 
	public void setPdbx_weight(java.lang.Float pdbx_weight)
	{
		this.pdbx_weight = pdbx_weight;
	}

 	protected java.lang.Float rms_dev_B_iso;


	/**
	 *  The root-mean-square deviation in equivalent isotropic
	 *  displacement parameters in the domain specified by
	 *  attribute dom_id
	 *  in category refine_ls_restr_ncs and in the domains against which it was restrained.
	 */
	public java.lang.Float getRms_dev_B_iso() 
	{
		return rms_dev_B_iso;
	}
 
	public void setRms_dev_B_iso(java.lang.Float rms_dev_B_iso)
	{
		this.rms_dev_B_iso = rms_dev_B_iso;
	}

 	protected java.lang.Float rms_dev_position;


	/**
	 *  The root-mean-square deviation in equivalent atom positions in
	 *  the domain specified by  attribute dom_id in category refine_ls_restr_ncs and in the
	 *  domains against which it was restrained.
	 */
	public java.lang.Float getRms_dev_position() 
	{
		return rms_dev_position;
	}
 
	public void setRms_dev_position(java.lang.Float rms_dev_position)
	{
		this.rms_dev_position = rms_dev_position;
	}

 	protected java.lang.Float weight_B_iso;


	/**
	 *  The value of the weighting coefficient used in
	 *  noncrystallographic symmetry restraint of isotropic displacement
	 *  parameters in  the domain specified by
	 *  attribute dom_id in category refine_ls_restr_ncs to equivalent isotropic
	 *  displacement parameters in the domains against
	 *  which it was restrained.
	 */
	public java.lang.Float getWeight_B_iso() 
	{
		return weight_B_iso;
	}
 
	public void setWeight_B_iso(java.lang.Float weight_B_iso)
	{
		this.weight_B_iso = weight_B_iso;
	}

 	protected java.lang.Float weight_position;


	/**
	 *  The value of the weighting coefficient used in
	 *  noncrystallographic symmetry restraint of atom positions in the
	 *  domain specified by  attribute dom_id in category refine_ls_restr_ncs to equivalent
	 *  atom positions in the domains against which it was restrained.
	 */
	public java.lang.Float getWeight_position() 
	{
		return weight_position;
	}
 
	public void setWeight_position(java.lang.Float weight_position)
	{
		this.weight_position = weight_position;
	}

 }
