package org.pdb.beans;

/**
 *  Data items in the REFLNS category record details about the
 *  reflection data used to determine the ATOM_SITE data items.
 *  
 *  The REFLN data items refer to individual reflections and must
 *  be included in looped lists.
 *  
 *  The REFLNS data items specify the parameters that apply to all
 *  reflections. The REFLNS data items are not looped.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:reflnsCategory>
 *  <PDBx:reflns entry_id="5HVP">
 *  <PDBx:data_reduction_method> Xengen program scalei. Anomalous pairs were merged. Scaling
 *  proceeded in several passes, beginning with 1-parameter
 *  fit and ending with 3-parameter fit.</PDBx:data_reduction_method>
 *  <PDBx:data_reduction_details> Merging and scaling based on only those reflections
 *  with I &gt; \s(I).</PDBx:data_reduction_details>
 *  <PDBx:d_resolution_high>2.00</PDBx:d_resolution_high>
 *  <PDBx:d_resolution_low>8.00</PDBx:d_resolution_low>
 *  <PDBx:limit_h_max>22</PDBx:limit_h_max>
 *  <PDBx:limit_h_min>0</PDBx:limit_h_min>
 *  <PDBx:limit_k_max>46</PDBx:limit_k_max>
 *  <PDBx:limit_k_min>0</PDBx:limit_k_min>
 *  <PDBx:limit_l_max>57</PDBx:limit_l_max>
 *  <PDBx:limit_l_min>0</PDBx:limit_l_min>
 *  <PDBx:number_obs>7228</PDBx:number_obs>
 *  <PDBx:observed_criterion>&gt; 1 \s(I)</PDBx:observed_criterion>
 *  <PDBx:details>none</PDBx:details>
 *  </PDBx:reflns>
 *  </PDBx:reflnsCategory>
 *  
 *  
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:reflnsCategory>
 *  <PDBx:reflns>
 *  <PDBx:limit_h_min>0</PDBx:limit_h_min>
 *  <PDBx:limit_h_max>6</PDBx:limit_h_max>
 *  <PDBx:limit_k_min>0</PDBx:limit_k_min>
 *  <PDBx:limit_k_max>17</PDBx:limit_k_max>
 *  <PDBx:limit_l_min>0</PDBx:limit_l_min>
 *  <PDBx:limit_l_max>22</PDBx:limit_l_max>
 *  <PDBx:number_all>1592</PDBx:number_all>
 *  <PDBx:number_obs>1408</PDBx:number_obs>
 *  <PDBx:observed_criterion>F_&gt;_6.0_\s(F)</PDBx:observed_criterion>
 *  <PDBx:d_resolution_high>0.8733</PDBx:d_resolution_high>
 *  <PDBx:d_resolution_low>11.9202</PDBx:d_resolution_low>
 *  </PDBx:reflns>
 *  </PDBx:reflnsCategory>
 * </pre>
 */
public class Reflns 
{
		protected java.lang.Float B_iso_Wilson_estimate;


	/**
	 *  The value of the overall isotropic displacement parameter
	 *  estimated from the slope of the Wilson plot.
	 */
	public java.lang.Float getB_iso_Wilson_estimate() 
	{
		return B_iso_Wilson_estimate;
	}
 
	public void setB_iso_Wilson_estimate(java.lang.Float B_iso_Wilson_estimate)
	{
		this.B_iso_Wilson_estimate = B_iso_Wilson_estimate;
	}

 	protected java.lang.Float Friedel_coverage;


	/**
	 *  The proportion of Friedel-related reflections present in
	 *  the number of  'independent' reflections specified by
	 *  the item  attribute number_all.
	 *  in category reflns
	 *  This proportion is calculated as the ratio:
	 *  
	 *  [N(Crystal class) - N(Laue symmetry)] / N(Laue symmetry)
	 *  
	 *  where, working from the DIFFRN_REFLN list,
	 *  
	 *  N(Crystal class) is the number of reflections obtained on
	 *  averaging under the symmetry of the crystal class
	 *  N(Laue symmetry) is the number of reflections obtained on
	 *  averaging under the Laue symmetry.
	 *  
	 * <pre>
	 *  Examples:
	 *  (a) For centrosymmetric structures, the value of
	 *  attribute Friedel_coverage in category reflns is
	 *  necessarily equal to 0.0, as the crystal class
	 *  is identical to the Laue symmetry.
	 *  (b) For whole-sphere data for a crystal in the space
	 *  group P1,  attribute Friedel_coverage in category reflns is equal to 1.0,
	 *  as no reflection h k l is equivalent to -h -k -l
	 *  in the crystal class and all Friedel pairs
	 *  {h k l; -h -k -l} have been measured.
	 *  (c) For whole-sphere data in space group Pmm2,
	 *  attribute Friedel_coverage
	 *  in category reflns will be < 1.0 because although reflections h k l and
	 *  -h -k -l are not equivalent when h k l indices are
	 *  nonzero, they are when l=0.
	 *  (d) For a crystal in space group Pmm2, measurements of the
	 *  two inequivalent octants h >= 0, k >=0, l lead to the
	 *  same value as in (c), whereas measurements of the
	 *  two equivalent octants h >= 0, k, l >= 0 will lead to
	 *  a zero value for  attribute Friedel_coverage in category reflns.
	 * </pre>
	 */
	public java.lang.Float getFriedel_coverage() 
	{
		return Friedel_coverage;
	}
 
	public void setFriedel_coverage(java.lang.Float Friedel_coverage)
	{
		this.Friedel_coverage = Friedel_coverage;
	}

 	protected java.lang.String R_free_details;


	/**
	 *  A description of the method by which a subset of reflections was
	 *  selected for exclusion from refinement so as to be used in the
	 *  calculation of a 'free' R factor.
	 *  The data set was sorted with l varying most
	 *  rapidly and h varying least rapidly. Every
	 *  10th reflection in this sorted list was
	 *  excluded from refinement and included in the
	 *  calculation of a 'free' R factor.
	 */
	public java.lang.String getR_free_details() 
	{
		return R_free_details;
	}
 
	public void setR_free_details(java.lang.String R_free_details)
	{
		this.R_free_details = R_free_details;
	}

 	protected java.lang.Float Rmerge_F_all;


	/**
	 *  Residual factor Rmerge for all reflections that satisfy the
	 *  resolution limits established by  attribute d_resolution_high
	 *  in category reflns and  attribute d_resolution_low.
	 *  in category reflns
	 *  sum~i~(sum~j~|F~j~ - <F>|)
	 *  Rmerge(F) = --------------------------
	 *  sum~i~(sum~j~<F>)
	 *  
	 *  F~j~ = the amplitude of the jth observation of reflection i
	 *  <F>  = the mean of the amplitudes of all observations of
	 *  reflection i
	 *  
	 *  sum~i~ is taken over all reflections
	 *  sum~j~ is taken over all observations of each reflection
	 */
	public java.lang.Float getRmerge_F_all() 
	{
		return Rmerge_F_all;
	}
 
	public void setRmerge_F_all(java.lang.Float Rmerge_F_all)
	{
		this.Rmerge_F_all = Rmerge_F_all;
	}

 	protected java.lang.Float Rmerge_F_obs;


	/**
	 *  Residual factor Rmerge for reflections that satisfy the
	 *  resolution limits established by  attribute d_resolution_high
	 *  in category reflns and  attribute d_resolution_low in category reflns and the observation limit
	 *  established by  attribute observed_criterion.
	 *  in category reflns
	 *  sum~i~(sum~j~|F~j~ - <F>|)
	 *  Rmerge(F) = --------------------------
	 *  sum~i~(sum~j~<F>)
	 *  
	 *  F~j~ = the amplitude of the jth observation of reflection i
	 *  <F>  = the mean of the amplitudes of all observations of
	 *  reflection i
	 *  
	 *  sum~i~ is taken over all reflections
	 *  sum~j~ is taken over all observations of each reflection
	 */
	public java.lang.Float getRmerge_F_obs() 
	{
		return Rmerge_F_obs;
	}
 
	public void setRmerge_F_obs(java.lang.Float Rmerge_F_obs)
	{
		this.Rmerge_F_obs = Rmerge_F_obs;
	}

 	protected java.lang.Float d_resolution_high;


	/**
	 *  The smallest value for the interplanar spacings for
	 *  the reflection data. This is called the highest resolution.
	 */
	public java.lang.Float getD_resolution_high() 
	{
		return d_resolution_high;
	}
 
	public void setD_resolution_high(java.lang.Float d_resolution_high)
	{
		this.d_resolution_high = d_resolution_high;
	}

 	protected java.lang.Float d_resolution_low;


	/**
	 *  The largest value for the interplanar spacings for the
	 *  reflection data. This is called the lowest resolution.
	 */
	public java.lang.Float getD_resolution_low() 
	{
		return d_resolution_low;
	}
 
	public void setD_resolution_low(java.lang.Float d_resolution_low)
	{
		this.d_resolution_low = d_resolution_low;
	}

 	protected java.lang.String data_reduction_details;


	/**
	 *  A description of special aspects of the data-reduction
	 *  procedures.
	 *  Merging and scaling based on only those
	 *  reflections with I > sig(I).
	 */
	public java.lang.String getData_reduction_details() 
	{
		return data_reduction_details;
	}
 
	public void setData_reduction_details(java.lang.String data_reduction_details)
	{
		this.data_reduction_details = data_reduction_details;
	}

 	protected java.lang.String data_reduction_method;


	/**
	 *  The method used for data reduction.
	 *  
	 *  Note that this is not the computer program used, which is
	 *  described in the SOFTWARE category, but the method
	 *  itself.
	 *  
	 *  This data item should be used to describe significant
	 *  methodological options used within the data-reduction programs.
	 *  Profile fitting by method of Kabsch (1987).
	 *  Scaling used spherical harmonic coefficients.
	 */
	public java.lang.String getData_reduction_method() 
	{
		return data_reduction_method;
	}
 
	public void setData_reduction_method(java.lang.String data_reduction_method)
	{
		this.data_reduction_method = data_reduction_method;
	}

 	protected java.lang.String details;


	/**
	 *  A description of reflection data not covered by other data
	 *  names. This should include details of the Friedel pairs.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.Integer limit_h_max;


	/**
	 *  Maximum value of the Miller index h for the reflection data. This
	 *  need not have the same value as  attribute limit_h_max in category diffrn_reflns.
	 */
	public java.lang.Integer getLimit_h_max() 
	{
		return limit_h_max;
	}
 
	public void setLimit_h_max(java.lang.Integer limit_h_max)
	{
		this.limit_h_max = limit_h_max;
	}

 	protected java.lang.Integer limit_h_min;


	/**
	 *  Minimum value of the Miller index h for the reflection data. This
	 *  need not have the same value as  attribute limit_h_min in category diffrn_reflns.
	 */
	public java.lang.Integer getLimit_h_min() 
	{
		return limit_h_min;
	}
 
	public void setLimit_h_min(java.lang.Integer limit_h_min)
	{
		this.limit_h_min = limit_h_min;
	}

 	protected java.lang.Integer limit_k_max;


	/**
	 *  Maximum value of the Miller index k for the reflection data. This
	 *  need not have the same value as  attribute limit_k_max in category diffrn_reflns.
	 */
	public java.lang.Integer getLimit_k_max() 
	{
		return limit_k_max;
	}
 
	public void setLimit_k_max(java.lang.Integer limit_k_max)
	{
		this.limit_k_max = limit_k_max;
	}

 	protected java.lang.Integer limit_k_min;


	/**
	 *  Minimum value of the Miller index k for the reflection data. This
	 *  need not have the same value as  attribute limit_k_min in category diffrn_reflns.
	 */
	public java.lang.Integer getLimit_k_min() 
	{
		return limit_k_min;
	}
 
	public void setLimit_k_min(java.lang.Integer limit_k_min)
	{
		this.limit_k_min = limit_k_min;
	}

 	protected java.lang.Integer limit_l_max;


	/**
	 *  Maximum value of the Miller index l for the reflection data. This
	 *  need not have the same value as  attribute limit_l_max in category diffrn_reflns.
	 */
	public java.lang.Integer getLimit_l_max() 
	{
		return limit_l_max;
	}
 
	public void setLimit_l_max(java.lang.Integer limit_l_max)
	{
		this.limit_l_max = limit_l_max;
	}

 	protected java.lang.Integer limit_l_min;


	/**
	 *  Minimum value of the Miller index l for the reflection data. This
	 *  need not have the same value as  attribute limit_l_min in category diffrn_reflns.
	 */
	public java.lang.Integer getLimit_l_min() 
	{
		return limit_l_min;
	}
 
	public void setLimit_l_min(java.lang.Integer limit_l_min)
	{
		this.limit_l_min = limit_l_min;
	}

 	protected java.lang.Integer number_all;


	/**
	 *  The total number of reflections in the REFLN list (not the
	 *  DIFFRN_REFLN list). This number may contain Friedel-equivalent
	 *  reflections according to the nature of the structure and the
	 *  procedures used. The item  attribute details in category reflns describes the
	 *  reflection data.
	 */
	public java.lang.Integer getNumber_all() 
	{
		return number_all;
	}
 
	public void setNumber_all(java.lang.Integer number_all)
	{
		this.number_all = number_all;
	}

 	protected java.lang.Integer number_gt;


	/**
	 *  The number of reflections in the REFLN list (not the
	 *  DIFFRN_REFLN list) that are significantly intense, satisfying
	 *  the criterion specified by  attribute threshold_expression in category reflns.  This may
	 *  include Friedel-equivalent reflections (i.e. those which are
	 *  symmetry-equivalent under the Laue symmetry but inequivalent
	 *  under the crystal class) according to the nature of the
	 *  structure and the procedures used. Any special characteristics
	 *  of the reflections included in the REFLN list should be
	 *  described using the item  attribute details in category reflns.
	 */
	public java.lang.Integer getNumber_gt() 
	{
		return number_gt;
	}
 
	public void setNumber_gt(java.lang.Integer number_gt)
	{
		this.number_gt = number_gt;
	}

 	protected java.lang.Integer number_obs;


	/**
	 *  The number of reflections in the REFLN list (not the DIFFRN_REFLN
	 *  list) classified as observed (see  attribute observed_criterion).
	 *  in category reflns This number may contain Friedel-equivalent reflections according
	 *  to the nature of the structure and the procedures used.
	 */
	public java.lang.Integer getNumber_obs() 
	{
		return number_obs;
	}
 
	public void setNumber_obs(java.lang.Integer number_obs)
	{
		this.number_obs = number_obs;
	}

 	protected java.lang.String observed_criterion;


	/**
	 *  The criterion used to classify a reflection as 'observed'. This
	 *  criterion is usually expressed in terms of a sigma(I) or
	 *  sigma(F) threshold.
	 *  >2sigma(I)
	 */
	public java.lang.String getObserved_criterion() 
	{
		return observed_criterion;
	}
 
	public void setObserved_criterion(java.lang.String observed_criterion)
	{
		this.observed_criterion = observed_criterion;
	}

 	protected java.lang.Float observed_criterion_F_max;


	/**
	 *  The criterion used to classify a reflection as 'observed'
	 *  expressed as an upper limit for the value of F.
	 */
	public java.lang.Float getObserved_criterion_F_max() 
	{
		return observed_criterion_F_max;
	}
 
	public void setObserved_criterion_F_max(java.lang.Float observed_criterion_F_max)
	{
		this.observed_criterion_F_max = observed_criterion_F_max;
	}

 	protected java.lang.Float observed_criterion_F_min;


	/**
	 *  The criterion used to classify a reflection as 'observed'
	 *  expressed as a lower limit for the value of F.
	 */
	public java.lang.Float getObserved_criterion_F_min() 
	{
		return observed_criterion_F_min;
	}
 
	public void setObserved_criterion_F_min(java.lang.Float observed_criterion_F_min)
	{
		this.observed_criterion_F_min = observed_criterion_F_min;
	}

 	protected java.lang.Float observed_criterion_I_max;


	/**
	 *  The criterion used to classify a reflection as 'observed'
	 *  expressed as an upper limit for the value of I.
	 */
	public java.lang.Float getObserved_criterion_I_max() 
	{
		return observed_criterion_I_max;
	}
 
	public void setObserved_criterion_I_max(java.lang.Float observed_criterion_I_max)
	{
		this.observed_criterion_I_max = observed_criterion_I_max;
	}

 	protected java.lang.Float observed_criterion_I_min;


	/**
	 *  The criterion used to classify a reflection as 'observed'
	 *  expressed as a lower limit for the value of I.
	 */
	public java.lang.Float getObserved_criterion_I_min() 
	{
		return observed_criterion_I_min;
	}
 
	public void setObserved_criterion_I_min(java.lang.Float observed_criterion_I_min)
	{
		this.observed_criterion_I_min = observed_criterion_I_min;
	}

 	protected java.lang.Float observed_criterion_sigma_F;


	/**
	 *  The criterion used to classify a reflection as 'observed'
	 *  expressed as a multiple of the value of sigma(F).
	 */
	public java.lang.Float getObserved_criterion_sigma_F() 
	{
		return observed_criterion_sigma_F;
	}
 
	public void setObserved_criterion_sigma_F(java.lang.Float observed_criterion_sigma_F)
	{
		this.observed_criterion_sigma_F = observed_criterion_sigma_F;
	}

 	protected java.lang.Float observed_criterion_sigma_I;


	/**
	 *  The criterion used to classify a reflection as 'observed'
	 *  expressed as a multiple of the value of sigma(I).
	 */
	public java.lang.Float getObserved_criterion_sigma_I() 
	{
		return observed_criterion_sigma_I;
	}
 
	public void setObserved_criterion_sigma_I(java.lang.Float observed_criterion_sigma_I)
	{
		this.observed_criterion_sigma_I = observed_criterion_sigma_I;
	}

 	protected java.lang.Float pdbx_Rmerge_I_all;


	/**
	 *  The R value for merging all intensities in this data set.
	 */
	public java.lang.Float getPdbx_Rmerge_I_all() 
	{
		return pdbx_Rmerge_I_all;
	}
 
	public void setPdbx_Rmerge_I_all(java.lang.Float pdbx_Rmerge_I_all)
	{
		this.pdbx_Rmerge_I_all = pdbx_Rmerge_I_all;
	}

 	protected java.lang.Float pdbx_Rmerge_I_obs;


	/**
	 *  The R value for merging intensities satisfying the observed
	 *  criteria in this data set.
	 */
	public java.lang.Float getPdbx_Rmerge_I_obs() 
	{
		return pdbx_Rmerge_I_obs;
	}
 
	public void setPdbx_Rmerge_I_obs(java.lang.Float pdbx_Rmerge_I_obs)
	{
		this.pdbx_Rmerge_I_obs = pdbx_Rmerge_I_obs;
	}

 	protected java.lang.Float pdbx_Rsym_value;


	/**
	 *  R Sym value in percent.
	 *  2.0
	 */
	public java.lang.Float getPdbx_Rsym_value() 
	{
		return pdbx_Rsym_value;
	}
 
	public void setPdbx_Rsym_value(java.lang.Float pdbx_Rsym_value)
	{
		this.pdbx_Rsym_value = pdbx_Rsym_value;
	}

 	protected java.lang.Float pdbx_chi_squared;


	/**
	 *  Overall  Chi-squared statistic.
	 */
	public java.lang.Float getPdbx_chi_squared() 
	{
		return pdbx_chi_squared;
	}
 
	public void setPdbx_chi_squared(java.lang.Float pdbx_chi_squared)
	{
		this.pdbx_chi_squared = pdbx_chi_squared;
	}

 	protected java.lang.Float pdbx_d_res_high_opt;


	/**
	 *  The highest optical resolution for this reflection data set
	 *  as determined by computational method  attribute pdbx_d_res_opt_method in category reflns.
	 *  1.2
	 */
	public java.lang.Float getPdbx_d_res_high_opt() 
	{
		return pdbx_d_res_high_opt;
	}
 
	public void setPdbx_d_res_high_opt(java.lang.Float pdbx_d_res_high_opt)
	{
		this.pdbx_d_res_high_opt = pdbx_d_res_high_opt;
	}

 	protected java.lang.Float pdbx_d_res_low_opt;


	/**
	 *  The lowest optical resolution for this reflection data set
	 *  as determined by computational method  attribute pdbx_d_res_opt_method in category reflns.
	 *  20.5
	 */
	public java.lang.Float getPdbx_d_res_low_opt() 
	{
		return pdbx_d_res_low_opt;
	}
 
	public void setPdbx_d_res_low_opt(java.lang.Float pdbx_d_res_low_opt)
	{
		this.pdbx_d_res_low_opt = pdbx_d_res_low_opt;
	}

 	protected java.lang.String pdbx_d_res_opt_method;


	/**
	 *  The computational method used to determine the optical
	 *  resolution limits  attribute pdbx_d_res_high_opt in category reflns and
	 *  attribute pdbx_d_res_low_opt in category reflns.
	 *  SFCHECK
	 */
	public java.lang.String getPdbx_d_res_opt_method() 
	{
		return pdbx_d_res_opt_method;
	}
 
	public void setPdbx_d_res_opt_method(java.lang.String pdbx_d_res_opt_method)
	{
		this.pdbx_d_res_opt_method = pdbx_d_res_opt_method;
	}

 	protected java.lang.Float pdbx_netI_over_av_sigmaI;


	/**
	 *  Overall  <I>/<sigma(I)>
	 */
	public java.lang.Float getPdbx_netI_over_av_sigmaI() 
	{
		return pdbx_netI_over_av_sigmaI;
	}
 
	public void setPdbx_netI_over_av_sigmaI(java.lang.Float pdbx_netI_over_av_sigmaI)
	{
		this.pdbx_netI_over_av_sigmaI = pdbx_netI_over_av_sigmaI;
	}

 	protected java.lang.Float pdbx_netI_over_sigmaI;


	/**
	 *  Overall  <I/sigma(I)>
	 */
	public java.lang.Float getPdbx_netI_over_sigmaI() 
	{
		return pdbx_netI_over_sigmaI;
	}
 
	public void setPdbx_netI_over_sigmaI(java.lang.Float pdbx_netI_over_sigmaI)
	{
		this.pdbx_netI_over_sigmaI = pdbx_netI_over_sigmaI;
	}

 	protected java.lang.Float pdbx_redundancy;


	/**
	 *  Overall redundancy for this data set (%).
	 */
	public java.lang.Float getPdbx_redundancy() 
	{
		return pdbx_redundancy;
	}
 
	public void setPdbx_redundancy(java.lang.Float pdbx_redundancy)
	{
		this.pdbx_redundancy = pdbx_redundancy;
	}

 	protected java.lang.Float pdbx_res_netI_over_av_sigmaI_2;


	/**
	 *  Resolution (angstrom) for reflections with  <I>/<sigma(I)> = 2.
	 */
	public java.lang.Float getPdbx_res_netI_over_av_sigmaI_2() 
	{
		return pdbx_res_netI_over_av_sigmaI_2;
	}
 
	public void setPdbx_res_netI_over_av_sigmaI_2(java.lang.Float pdbx_res_netI_over_av_sigmaI_2)
	{
		this.pdbx_res_netI_over_av_sigmaI_2 = pdbx_res_netI_over_av_sigmaI_2;
	}

 	protected java.lang.Float pdbx_res_netI_over_sigmaI_2;


	/**
	 *  Resolution (angstroms) for reflections with  <I/sigma(I)> = 2.
	 */
	public java.lang.Float getPdbx_res_netI_over_sigmaI_2() 
	{
		return pdbx_res_netI_over_sigmaI_2;
	}
 
	public void setPdbx_res_netI_over_sigmaI_2(java.lang.Float pdbx_res_netI_over_sigmaI_2)
	{
		this.pdbx_res_netI_over_sigmaI_2 = pdbx_res_netI_over_sigmaI_2;
	}

 	protected java.lang.Integer pdbx_scaling_rejects;


	/**
	 *  Number of reflections rejected in scaling operations.
	 */
	public java.lang.Integer getPdbx_scaling_rejects() 
	{
		return pdbx_scaling_rejects;
	}
 
	public void setPdbx_scaling_rejects(java.lang.Integer pdbx_scaling_rejects)
	{
		this.pdbx_scaling_rejects = pdbx_scaling_rejects;
	}

 	protected java.lang.Float percent_possible_obs;


	/**
	 *  The percentage of geometrically possible reflections represented
	 *  by reflections that satisfy the resolution limits established
	 *  by _reflns.d_resolution_high and _reflns.d_resolution_low and
	 *  the observation limit established by
	 *  attribute observed_criterion in category reflns.
	 */
	public java.lang.Float getPercent_possible_obs() 
	{
		return percent_possible_obs;
	}
 
	public void setPercent_possible_obs(java.lang.Float percent_possible_obs)
	{
		this.percent_possible_obs = percent_possible_obs;
	}

 	protected java.lang.String threshold_expression;


	/**
	 *  The threshold, usually based on multiples of u(I), u(F^2^)
	 *  or u(F), that serves to identify significantly intense
	 *  reflections, the number of which is given by  attribute number_gt.
	 *  in category reflns These reflections are used in the calculation of
	 *  attribute ls_R_factor_gt in category refine.
	 *  I>2u(I)
	 */
	public java.lang.String getThreshold_expression() 
	{
		return threshold_expression;
	}
 
	public void setThreshold_expression(java.lang.String threshold_expression)
	{
		this.threshold_expression = threshold_expression;
	}

 }
