package org.pdb.beans;

/**
 *  Data items in the REFLNS_CLASS category record details
 *  of the reflections used to determine the structural
 *  parameters for each reflection class.
 *  
 * <pre>
 *  Example 1 - example corresponding to the one-dimensional incommensurately
 *  modulated structure of K~2~SeO~4~.
 *  <PDBx:reflns_classCategory>
 *  <PDBx:reflns_class code="Main">
 *  <PDBx:number_gt>584</PDBx:number_gt>
 *  </PDBx:reflns_class>
 *  <PDBx:reflns_class code="Sat1">
 *  <PDBx:number_gt>226</PDBx:number_gt>
 *  </PDBx:reflns_class>
 *  <PDBx:reflns_class code="Sat2">
 *  <PDBx:number_gt>50</PDBx:number_gt>
 *  </PDBx:reflns_class>
 *  </PDBx:reflns_classCategory>
 * </pre>
 */
public class Reflns_class 
{
		protected java.lang.Float R_Fsqd_factor;


	/**
	 *  For each reflection class, the residual factor R(F^2^) calculated
	 *  on the squared amplitudes of the observed and calculated
	 *  structure factors for the reflections judged significantly
	 *  intense (i.e. satisfying the threshold specified by
	 *  attribute threshold_expression) in category reflns and included in the refinement.
	 *  
	 *  The reflections also satisfy the resolution limits established
	 *  by _reflns_class.d_res_high and _reflns_class.d_res_low.
	 *  
	 *  sum | F(obs)^2^ - F(calc)^2^ |
	 *  R(Fsqd) = -------------------------------
	 *  sum F(obs)^2^
	 *  
	 *  F(obs)^2^  = squares of the observed structure-factor amplitudes
	 *  F(calc)^2^ = squares of the calculated structure-factor
	 *  amplitudes
	 *  
	 *  and the sum is taken over the reflections of this class.
	 */
	public java.lang.Float getR_Fsqd_factor() 
	{
		return R_Fsqd_factor;
	}
 
	public void setR_Fsqd_factor(java.lang.Float R_Fsqd_factor)
	{
		this.R_Fsqd_factor = R_Fsqd_factor;
	}

 	protected java.lang.Float R_I_factor;


	/**
	 *  For each reflection class, the residual factor R(I) for the
	 *  reflections judged significantly intense (i.e. satisfying the
	 *  threshold specified by  attribute threshold_expression) in category reflns and
	 *  included in the refinement.
	 *  
	 *  This is most often calculated in Rietveld refinements
	 *  against powder data, where it is referred to as R~B~ or R~Bragg~.
	 *  
	 *  sum | I(obs) - I(calc) |
	 *  R(I) =  ------------------------
	 *  sum | I(obs) |
	 *  
	 *  I(obs)  = the net observed intensities
	 *  I(calc) = the net calculated intensities
	 *  
	 *  and the sum is taken over the reflections of this class.
	 */
	public java.lang.Float getR_I_factor() 
	{
		return R_I_factor;
	}
 
	public void setR_I_factor(java.lang.Float R_I_factor)
	{
		this.R_I_factor = R_I_factor;
	}

 	protected java.lang.Float R_factor_all;


	/**
	 *  For each reflection class, the residual factor for all
	 *  reflections included in the refinement.
	 *  The reflections also satisfy the resolution limits established by
	 *  _reflns_class.d_res_high and _reflns_class.d_res_low.
	 *  This is the conventional R factor. See also the
	 *  definition of  attribute wR_factor_all.
	 *  in category reflns_class
	 *  sum | F(obs) - F(calc) |
	 *  R = ------------------------
	 *  sum | F(obs) |
	 *  
	 *  F(obs)  = the observed structure-factor amplitudes
	 *  F(calc) = the calculated structure-factor amplitudes
	 *  
	 *  and the sum is taken over the reflections of this class.
	 */
	public java.lang.Float getR_factor_all() 
	{
		return R_factor_all;
	}
 
	public void setR_factor_all(java.lang.Float R_factor_all)
	{
		this.R_factor_all = R_factor_all;
	}

 	protected java.lang.Float R_factor_gt;


	/**
	 *  For each reflection class, the residual factor for significantly
	 *  intense reflections (see  attribute threshold_expression) in category reflns included
	 *  in the refinement.
	 *  The reflections also satisfy the resolution limits established by
	 *  _reflns_class.d_res_high and _reflns_class.d_res_low.
	 *  This is the conventional R factor. See also the
	 *  definition of  attribute wR_factor_all.
	 *  in category reflns_class
	 *  sum | F(obs) - F(calc) |
	 *  R = ------------------------
	 *  sum | F(obs) |
	 *  
	 *  F(obs)  = the observed structure-factor amplitudes
	 *  F(calc) = the calculated structure-factor amplitudes
	 *  
	 *  and the sum is taken over the reflections of this class.
	 */
	public java.lang.Float getR_factor_gt() 
	{
		return R_factor_gt;
	}
 
	public void setR_factor_gt(java.lang.Float R_factor_gt)
	{
		this.R_factor_gt = R_factor_gt;
	}

 	protected java.lang.String code;


	/**
	 *  The code identifying a certain reflection class.
	 *  1
	 *  m1
	 *  s2
	 */
	public java.lang.String getCode() 
	{
		return code;
	}
 
	public void setCode(java.lang.String code)
	{
		this.code = code;
	}

 	protected java.lang.Float d_res_high;


	/**
	 *  For each reflection class, the smallest value in angstroms
	 *  for the interplanar spacings for the reflections used in the
	 *  refinement. This is called the highest resolution.
	 */
	public java.lang.Float getD_res_high() 
	{
		return d_res_high;
	}
 
	public void setD_res_high(java.lang.Float d_res_high)
	{
		this.d_res_high = d_res_high;
	}

 	protected java.lang.Float d_res_low;


	/**
	 *  For each reflection class, the largest value in angstroms
	 *  for the interplanar spacings for the reflections used in the
	 *  refinement. This is called the lowest resolution.
	 */
	public java.lang.Float getD_res_low() 
	{
		return d_res_low;
	}
 
	public void setD_res_low(java.lang.Float d_res_low)
	{
		this.d_res_low = d_res_low;
	}

 	protected java.lang.String description;


	/**
	 *  Description of each reflection class.
	 *  m=1 first order satellites
	 *  H0L0 common projection reflections
	 */
	public java.lang.String getDescription() 
	{
		return description;
	}
 
	public void setDescription(java.lang.String description)
	{
		this.description = description;
	}

 	protected java.lang.Integer number_gt;


	/**
	 *  For each reflection class, the number of significantly intense
	 *  reflections (see  attribute threshold_expression) in category reflns in the REFLN
	 *  list (not the DIFFRN_REFLN list). This may include Friedel-
	 *  equivalent reflections (i.e. those which are symmetry-equivalent
	 *  under the Laue symmetry but inequivalent under the crystal
	 *  class)  according to the nature of the structure and the
	 *  procedures used. Any special characteristics of the reflections
	 *  included in the REFLN list should be described using the item
	 *  attribute details in category reflns.
	 */
	public java.lang.Integer getNumber_gt() 
	{
		return number_gt;
	}
 
	public void setNumber_gt(java.lang.Integer number_gt)
	{
		this.number_gt = number_gt;
	}

 	protected java.lang.Integer number_total;


	/**
	 *  For each reflection class, the total number of reflections
	 *  in the REFLN list (not the DIFFRN_REFLN list). This may
	 *  include Friedel-equivalent reflections (i.e. those which are
	 *  symmetry-equivalent under the Laue symmetry but inequivalent
	 *  under the crystal class) according to the nature of the
	 *  structure and the procedures used.  Any special characteristics
	 *  of the reflections included in the REFLN list should be
	 *  described using the item  attribute details in category reflns.
	 */
	public java.lang.Integer getNumber_total() 
	{
		return number_total;
	}
 
	public void setNumber_total(java.lang.Integer number_total)
	{
		this.number_total = number_total;
	}

 	protected java.lang.Float wR_factor_all;


	/**
	 *  For each reflection class, the weighted residual factors for all
	 *  reflections included in the refinement. The reflections also
	 *  satisfy the resolution limits established by
	 *  _reflns_class.d_res_high and _reflns_class.d_res_low.
	 *  See also  attribute R_factor_ in category reflns_class definitions.
	 *  
	 *  ( sum w [ Y(obs) - Y(calc) ]^2^  )^1/2^
	 *  wR = ( ------------------------------ )
	 *  (         sum w Y(obs)^2^       )
	 *  
	 *  Y(obs)  = the observed amplitude specified by
	 *  attribute ls_structure_factor_coef
	 *  in category refine Y(calc) = the calculated amplitude specified by
	 *  attribute ls_structure_factor_coef
	 *  in category refine w       = the least-squares weight
	 *  
	 *  and the sum is taken over the reflections of this class.
	 */
	public java.lang.Float getWR_factor_all() 
	{
		return wR_factor_all;
	}
 
	public void setWR_factor_all(java.lang.Float wR_factor_all)
	{
		this.wR_factor_all = wR_factor_all;
	}

 }
