package org.pdb.beans;

/**
 *  Data items in the REFLNS_SHELL category record details about
 *  the reflection data used to determine the ATOM_SITE data items
 *  broken down into shells of resolution.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:reflns_shellCategory>
 *  <PDBx:reflns_shell d_res_high="31.38" d_res_low="3.82">
 *  <PDBx:meanI_over_sigI_obs>69.8</PDBx:meanI_over_sigI_obs>
 *  <PDBx:number_measured_obs>9024</PDBx:number_measured_obs>
 *  <PDBx:number_unique_obs>2540</PDBx:number_unique_obs>
 *  <PDBx:percent_possible_obs>96.8</PDBx:percent_possible_obs>
 *  <PDBx:Rmerge_F_obs>1.98</PDBx:Rmerge_F_obs>
 *  </PDBx:reflns_shell>
 *  <PDBx:reflns_shell d_res_high="3.82" d_res_low="3.03">
 *  <PDBx:meanI_over_sigI_obs>26.1</PDBx:meanI_over_sigI_obs>
 *  <PDBx:number_measured_obs>7413</PDBx:number_measured_obs>
 *  <PDBx:number_unique_obs>2364</PDBx:number_unique_obs>
 *  <PDBx:percent_possible_obs>95.1</PDBx:percent_possible_obs>
 *  <PDBx:Rmerge_F_obs>3.85</PDBx:Rmerge_F_obs>
 *  </PDBx:reflns_shell>
 *  <PDBx:reflns_shell d_res_high="3.03" d_res_low="2.65">
 *  <PDBx:meanI_over_sigI_obs>10.5</PDBx:meanI_over_sigI_obs>
 *  <PDBx:number_measured_obs>5640</PDBx:number_measured_obs>
 *  <PDBx:number_unique_obs>2123</PDBx:number_unique_obs>
 *  <PDBx:percent_possible_obs>86.2</PDBx:percent_possible_obs>
 *  <PDBx:Rmerge_F_obs>6.37</PDBx:Rmerge_F_obs>
 *  </PDBx:reflns_shell>
 *  <PDBx:reflns_shell d_res_high="2.65" d_res_low="2.41">
 *  <PDBx:meanI_over_sigI_obs>6.4</PDBx:meanI_over_sigI_obs>
 *  <PDBx:number_measured_obs>4322</PDBx:number_measured_obs>
 *  <PDBx:number_unique_obs>1882</PDBx:number_unique_obs>
 *  <PDBx:percent_possible_obs>76.8</PDBx:percent_possible_obs>
 *  <PDBx:Rmerge_F_obs>8.01</PDBx:Rmerge_F_obs>
 *  </PDBx:reflns_shell>
 *  <PDBx:reflns_shell d_res_high="2.41" d_res_low="2.23">
 *  <PDBx:meanI_over_sigI_obs>4.3</PDBx:meanI_over_sigI_obs>
 *  <PDBx:number_measured_obs>3247</PDBx:number_measured_obs>
 *  <PDBx:number_unique_obs>1714</PDBx:number_unique_obs>
 *  <PDBx:percent_possible_obs>70.4</PDBx:percent_possible_obs>
 *  <PDBx:Rmerge_F_obs>9.86</PDBx:Rmerge_F_obs>
 *  </PDBx:reflns_shell>
 *  <PDBx:reflns_shell d_res_high="2.23" d_res_low="2.10">
 *  <PDBx:meanI_over_sigI_obs>3.1</PDBx:meanI_over_sigI_obs>
 *  <PDBx:number_measured_obs>1140</PDBx:number_measured_obs>
 *  <PDBx:number_unique_obs>812</PDBx:number_unique_obs>
 *  <PDBx:percent_possible_obs>33.3</PDBx:percent_possible_obs>
 *  <PDBx:Rmerge_F_obs>13.99</PDBx:Rmerge_F_obs>
 *  </PDBx:reflns_shell>
 *  </PDBx:reflns_shellCategory>
 * </pre>
 */
public class Reflns_shell 
{
		protected java.lang.Float Rmerge_F_all;


	/**
	 *  Residual factor Rmerge for all reflections that satisfy the
	 *  resolution limits established by  attribute d_res_high in category reflns_shell and
	 *  attribute d_res_low.
	 *  in category reflns_shell
	 *  sum~i~(sum~j~|F~j~ - <F>|)
	 *  Rmerge(F) = --------------------------
	 *  sum~i~(sum~j~<F>)
	 *  
	 *  F~j~ = the amplitude of the jth observation of reflection i
	 *  <F>  = the mean of the amplitudes of all observations of
	 *  reflection i
	 *  
	 *  sum~i~ is taken over all reflections
	 *  sum~j~ is taken over all observations of each reflection
	 */
	public java.lang.Float getRmerge_F_all() 
	{
		return Rmerge_F_all;
	}
 
	public void setRmerge_F_all(java.lang.Float Rmerge_F_all)
	{
		this.Rmerge_F_all = Rmerge_F_all;
	}

 	protected java.lang.Float Rmerge_F_gt;


	/**
	 *  The value of Rmerge(F) for significantly intense reflections
	 *  (see  attribute threshold_expression) in category reflns in a given shell.
	 *  
	 *  sum~i~ ( sum~j~ | F~j~ - <F> | )
	 *  Rmerge(F) = --------------------------------
	 *  sum~i~ ( sum~j~ <F> )
	 *  
	 *  F~j~  = the amplitude of the jth observation of reflection i
	 *  <F> = the mean of the amplitudes of all observations of
	 *  reflection i
	 *  
	 *  sum~i~ is taken over all reflections
	 *  sum~j~ is taken over all observations of each reflection.
	 */
	public java.lang.Float getRmerge_F_gt() 
	{
		return Rmerge_F_gt;
	}
 
	public void setRmerge_F_gt(java.lang.Float Rmerge_F_gt)
	{
		this.Rmerge_F_gt = Rmerge_F_gt;
	}

 	protected java.lang.Float Rmerge_F_obs;


	/**
	 *  Residual factor Rmerge for reflections that satisfy the
	 *  resolution limits established by  attribute d_res_high in category reflns_shell and
	 *  attribute d_res_low in category reflns_shell and the observation criterion
	 *  established by  attribute observed_criterion.
	 *  in category reflns
	 *  sum~i~(sum~j~|F~j~ - <F>|)
	 *  Rmerge(F) = --------------------------
	 *  sum~i~(sum~j~<F>)
	 *  
	 *  F~j~ = the amplitude of the jth observation of reflection i
	 *  <F>  = the mean of the amplitudes of all observations of
	 *  reflection i
	 *  
	 *  sum~i~ is taken over all reflections
	 *  sum~j~ is taken over all observations of each reflection
	 */
	public java.lang.Float getRmerge_F_obs() 
	{
		return Rmerge_F_obs;
	}
 
	public void setRmerge_F_obs(java.lang.Float Rmerge_F_obs)
	{
		this.Rmerge_F_obs = Rmerge_F_obs;
	}

 	protected java.lang.Float Rmerge_I_all;


	/**
	 *  The value of Rmerge(I) for all reflections in a given shell.
	 *  
	 *  sum~i~(sum~j~|I~j~ - <I>|)
	 *  Rmerge(I) = --------------------------
	 *  sum~i~(sum~j~<I>)
	 *  
	 *  I~j~ = the intensity of the jth observation of reflection i
	 *  <I>  = the mean of the intensities of all observations of
	 *  reflection i
	 *  
	 *  sum~i~ is taken over all reflections
	 *  sum~j~ is taken over all observations of each reflection
	 */
	public java.lang.Float getRmerge_I_all() 
	{
		return Rmerge_I_all;
	}
 
	public void setRmerge_I_all(java.lang.Float Rmerge_I_all)
	{
		this.Rmerge_I_all = Rmerge_I_all;
	}

 	protected java.lang.Float Rmerge_I_gt;


	/**
	 *  The value of Rmerge(I) for significantly intense reflections
	 *  (see  attribute threshold_expression) in category reflns in a given shell.
	 *  
	 *  sum~i~ ( sum~j~ | I~j~ - <I> | )
	 *  Rmerge(I) = --------------------------------
	 *  sum~i~ ( sum~j~ <I> )
	 *  
	 *  I~j~  = the intensity of the jth observation of reflection i
	 *  <I> = the mean of the intensities of all observations of
	 *  reflection i
	 *  
	 *  sum~i~ is taken over all reflections
	 *  sum~j~ is taken over all observations of each reflection.
	 */
	public java.lang.Float getRmerge_I_gt() 
	{
		return Rmerge_I_gt;
	}
 
	public void setRmerge_I_gt(java.lang.Float Rmerge_I_gt)
	{
		this.Rmerge_I_gt = Rmerge_I_gt;
	}

 	protected java.lang.Float Rmerge_I_obs;


	/**
	 *  The value of Rmerge(I) for reflections classified as 'observed'
	 *  (see  attribute observed_criterion) in category reflns in a given shell.
	 *  
	 *  sum~i~(sum~j~|I~j~ - <I>|)
	 *  Rmerge(I) = --------------------------
	 *  sum~i~(sum~j~<I>)
	 *  
	 *  I~j~ = the intensity of the jth observation of reflection i
	 *  <I>  = the mean of the intensities of all observations of
	 *  reflection i
	 *  
	 *  sum~i~ is taken over all reflections
	 *  sum~j~ is taken over all observations of each reflection
	 */
	public java.lang.Float getRmerge_I_obs() 
	{
		return Rmerge_I_obs;
	}
 
	public void setRmerge_I_obs(java.lang.Float Rmerge_I_obs)
	{
		this.Rmerge_I_obs = Rmerge_I_obs;
	}

 	protected java.lang.Float d_res_high;


	/**
	 *  The smallest value in angstroms for the interplanar spacings
	 *  for the reflections in this shell. This is called the highest
	 *  resolution.
	 */
	public java.lang.Float getD_res_high() 
	{
		return d_res_high;
	}
 
	public void setD_res_high(java.lang.Float d_res_high)
	{
		this.d_res_high = d_res_high;
	}

 	protected java.lang.Float d_res_low;


	/**
	 *  The highest value in angstroms for the interplanar spacings
	 *  for the reflections in this shell. This is called the lowest
	 *  resolution.
	 */
	public java.lang.Float getD_res_low() 
	{
		return d_res_low;
	}
 
	public void setD_res_low(java.lang.Float d_res_low)
	{
		this.d_res_low = d_res_low;
	}

 	protected java.lang.Float meanI_over_sigI_all;


	/**
	 *  The ratio of the mean of the intensities of all reflections
	 *  in this shell to the mean of the standard uncertainties of the
	 *  intensities of all reflections in this shell.
	 */
	public java.lang.Float getMeanI_over_sigI_all() 
	{
		return meanI_over_sigI_all;
	}
 
	public void setMeanI_over_sigI_all(java.lang.Float meanI_over_sigI_all)
	{
		this.meanI_over_sigI_all = meanI_over_sigI_all;
	}

 	protected java.lang.Float meanI_over_sigI_gt;


	/**
	 *  The ratio of the mean of the intensities of the significantly
	 *  intense reflections (see  attribute threshold_expression) in category reflns in
	 *  this shell to the mean of the standard uncertainties of the
	 *  intensities of the significantly intense reflections in this
	 *  shell.
	 */
	public java.lang.Float getMeanI_over_sigI_gt() 
	{
		return meanI_over_sigI_gt;
	}
 
	public void setMeanI_over_sigI_gt(java.lang.Float meanI_over_sigI_gt)
	{
		this.meanI_over_sigI_gt = meanI_over_sigI_gt;
	}

 	protected java.lang.Float meanI_over_sigI_obs;


	/**
	 *  The ratio of the mean of the intensities of the reflections
	 *  classified as 'observed' (see  attribute observed_criterion) in category reflns in
	 *  this shell to the mean of the standard uncertainties of the
	 *  intensities of the 'observed' reflections in this
	 *  shell.
	 */
	public java.lang.Float getMeanI_over_sigI_obs() 
	{
		return meanI_over_sigI_obs;
	}
 
	public void setMeanI_over_sigI_obs(java.lang.Float meanI_over_sigI_obs)
	{
		this.meanI_over_sigI_obs = meanI_over_sigI_obs;
	}

 	protected java.lang.Float meanI_over_uI_all;


	/**
	 *  The ratio of the mean of the intensities of all reflections
	 *  in this shell to the mean of the standard uncertainties of the
	 *  intensities of all reflections in this shell.
	 */
	public java.lang.Float getMeanI_over_uI_all() 
	{
		return meanI_over_uI_all;
	}
 
	public void setMeanI_over_uI_all(java.lang.Float meanI_over_uI_all)
	{
		this.meanI_over_uI_all = meanI_over_uI_all;
	}

 	protected java.lang.Float meanI_over_uI_gt;


	/**
	 *  The ratio of the mean of the intensities of the significantly
	 *  intense reflections (see  attribute threshold_expression) in category reflns in
	 *  this shell to the mean of the standard uncertainties of the
	 *  intensities of the significantly intense reflections in this
	 *  shell.
	 */
	public java.lang.Float getMeanI_over_uI_gt() 
	{
		return meanI_over_uI_gt;
	}
 
	public void setMeanI_over_uI_gt(java.lang.Float meanI_over_uI_gt)
	{
		this.meanI_over_uI_gt = meanI_over_uI_gt;
	}

 	protected java.lang.Integer number_measured_all;


	/**
	 *  The total number of reflections measured for this
	 *  shell.
	 */
	public java.lang.Integer getNumber_measured_all() 
	{
		return number_measured_all;
	}
 
	public void setNumber_measured_all(java.lang.Integer number_measured_all)
	{
		this.number_measured_all = number_measured_all;
	}

 	protected java.lang.Integer number_measured_gt;


	/**
	 *  The number of significantly intense reflections
	 *  (see  attribute threshold_expression) in category reflns measured for this
	 *  shell.
	 */
	public java.lang.Integer getNumber_measured_gt() 
	{
		return number_measured_gt;
	}
 
	public void setNumber_measured_gt(java.lang.Integer number_measured_gt)
	{
		this.number_measured_gt = number_measured_gt;
	}

 	protected java.lang.Integer number_measured_obs;


	/**
	 *  The number of reflections classified as 'observed'
	 *  (see  attribute observed_criterion) in category reflns for this
	 *  shell.
	 */
	public java.lang.Integer getNumber_measured_obs() 
	{
		return number_measured_obs;
	}
 
	public void setNumber_measured_obs(java.lang.Integer number_measured_obs)
	{
		this.number_measured_obs = number_measured_obs;
	}

 	protected java.lang.Integer number_possible;


	/**
	 *  The number of unique reflections it is possible to measure in
	 *  this shell.
	 */
	public java.lang.Integer getNumber_possible() 
	{
		return number_possible;
	}
 
	public void setNumber_possible(java.lang.Integer number_possible)
	{
		this.number_possible = number_possible;
	}

 	protected java.lang.Integer number_unique_all;


	/**
	 *  The total number of measured reflections which are symmetry-
	 *  unique after merging for this shell.
	 */
	public java.lang.Integer getNumber_unique_all() 
	{
		return number_unique_all;
	}
 
	public void setNumber_unique_all(java.lang.Integer number_unique_all)
	{
		this.number_unique_all = number_unique_all;
	}

 	protected java.lang.Integer number_unique_gt;


	/**
	 *  The total number of significantly intense reflections
	 *  (see  attribute threshold_expression) in category reflns resulting from merging
	 *  measured symmetry-equivalent reflections for this resolution
	 *  shell.
	 */
	public java.lang.Integer getNumber_unique_gt() 
	{
		return number_unique_gt;
	}
 
	public void setNumber_unique_gt(java.lang.Integer number_unique_gt)
	{
		this.number_unique_gt = number_unique_gt;
	}

 	protected java.lang.Integer number_unique_obs;


	/**
	 *  The total number of measured reflections classified as 'observed'
	 *  (see  attribute observed_criterion) in category reflns which are symmetry-unique
	 *  after merging for this shell.
	 */
	public java.lang.Integer getNumber_unique_obs() 
	{
		return number_unique_obs;
	}
 
	public void setNumber_unique_obs(java.lang.Integer number_unique_obs)
	{
		this.number_unique_obs = number_unique_obs;
	}

 	protected java.lang.Float pdbx_Rsym_value;


	/**
	 *  R sym value in percent.
	 */
	public java.lang.Float getPdbx_Rsym_value() 
	{
		return pdbx_Rsym_value;
	}
 
	public void setPdbx_Rsym_value(java.lang.Float pdbx_Rsym_value)
	{
		this.pdbx_Rsym_value = pdbx_Rsym_value;
	}

 	protected java.lang.Float pdbx_chi_squared;


	/**
	 *  Chi-squared statistic for this resolution shell.
	 */
	public java.lang.Float getPdbx_chi_squared() 
	{
		return pdbx_chi_squared;
	}
 
	public void setPdbx_chi_squared(java.lang.Float pdbx_chi_squared)
	{
		this.pdbx_chi_squared = pdbx_chi_squared;
	}

 	protected java.lang.Float pdbx_netI_over_sigmaI_all;


	/**
	 *  The mean of the ratio of the intensities to their
	 *  standard uncertainties of all reflections in the
	 *  resolution shell.
	 *  
	 *  attribute pdbx_meanI_over_sigmaI_all in category reflns_shell = <I/sigma(I)>
	 */
	public java.lang.Float getPdbx_netI_over_sigmaI_all() 
	{
		return pdbx_netI_over_sigmaI_all;
	}
 
	public void setPdbx_netI_over_sigmaI_all(java.lang.Float pdbx_netI_over_sigmaI_all)
	{
		this.pdbx_netI_over_sigmaI_all = pdbx_netI_over_sigmaI_all;
	}

 	protected java.lang.Float pdbx_netI_over_sigmaI_obs;


	/**
	 *  The mean of the ratio of the intensities to their
	 *  standard uncertainties of observed reflections
	 *  (see  attribute observed_criterion) in category reflns in the resolution shell.
	 *  
	 *  attribute pdbx_meanI_over_sigmaI_obs in category reflns_shell = <I/sigma(I)>
	 */
	public java.lang.Float getPdbx_netI_over_sigmaI_obs() 
	{
		return pdbx_netI_over_sigmaI_obs;
	}
 
	public void setPdbx_netI_over_sigmaI_obs(java.lang.Float pdbx_netI_over_sigmaI_obs)
	{
		this.pdbx_netI_over_sigmaI_obs = pdbx_netI_over_sigmaI_obs;
	}

 	protected java.lang.Float pdbx_redundancy;


	/**
	 *  Redundancy for the current shell.
	 */
	public java.lang.Float getPdbx_redundancy() 
	{
		return pdbx_redundancy;
	}
 
	public void setPdbx_redundancy(java.lang.Float pdbx_redundancy)
	{
		this.pdbx_redundancy = pdbx_redundancy;
	}

 	protected java.lang.Float percent_possible_all;


	/**
	 *  The percentage of geometrically possible reflections represented
	 *  by all reflections measured for this shell.
	 */
	public java.lang.Float getPercent_possible_all() 
	{
		return percent_possible_all;
	}
 
	public void setPercent_possible_all(java.lang.Float percent_possible_all)
	{
		this.percent_possible_all = percent_possible_all;
	}

 	protected java.lang.Float percent_possible_gt;


	/**
	 *  The percentage of geometrically possible reflections
	 *  represented by significantly intense reflections
	 *  (see  attribute threshold_expression) in category reflns measured for this
	 *  shell.
	 */
	public java.lang.Float getPercent_possible_gt() 
	{
		return percent_possible_gt;
	}
 
	public void setPercent_possible_gt(java.lang.Float percent_possible_gt)
	{
		this.percent_possible_gt = percent_possible_gt;
	}

 	protected java.lang.Float percent_possible_obs;


	/**
	 *  The percentage of geometrically possible reflections represented
	 *  by reflections classified as 'observed' (see
	 *  attribute observed_criterion) in category reflns for this shell.
	 */
	public java.lang.Float getPercent_possible_obs() 
	{
		return percent_possible_obs;
	}
 
	public void setPercent_possible_obs(java.lang.Float percent_possible_obs)
	{
		this.percent_possible_obs = percent_possible_obs;
	}

 }
