package org.pdb.beans;

/**
 *  Data items in the SOFTWARE category record details about
 *  the software used in the structure analysis, which implies
 *  any software used in the generation of any data items
 *  associated with the structure determination and
 *  structure representation.
 *  
 *  These data items allow computer programs to be referenced
 *  in more detail than data items in the COMPUTING category do.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:softwareCategory>
 *  <PDBx:software name="Prolsq" version="unknown" classification="refinement">
 *  <PDBx:type>program</PDBx:type>
 *  <PDBx:contact_author>Wayne A. Hendrickson</PDBx:contact_author>
 *  <PDBx:location>ftp://rosebud.sdsc.edu/pub/sdsc/xtal/CCP4/ccp4/</PDBx:location>
 *  <PDBx:citation_id>ref5</PDBx:citation_id>
 *  <PDBx:language>Fortran</PDBx:language>
 *  <PDBx:compiler_name>Convex Fortran</PDBx:compiler_name>
 *  <PDBx:compiler_version>v8.0</PDBx:compiler_version>
 *  <PDBx:hardware>Convex C220</PDBx:hardware>
 *  <PDBx:os>ConvexOS</PDBx:os>
 *  <PDBx:os_version>v10.1</PDBx:os_version>
 *  <PDBx:dependencies>Requires that Protin be run first</PDBx:dependencies>
 *  <PDBx:mods>optimized</PDBx:mods>
 *  <PDBx:description>restrained least-squares refinement</PDBx:description>
 *  </PDBx:software>
 *  </PDBx:softwareCategory>
 * </pre>
 */
public class Software 
{
		protected java.lang.String citation_id;


	/**
	 *  This data item is a pointer to  attribute id in category citation in the CITATION
	 *  category.
	 */
	public java.lang.String getCitation_id() 
	{
		return citation_id;
	}
 
	public void setCitation_id(java.lang.String citation_id)
	{
		this.citation_id = citation_id;
	}

 	protected java.lang.String classification;


	/**
	 *  The classification of the program according to its
	 *  major function.
	 *  data collection
	 *  data reduction
	 *  phasing
	 *  model building
	 *  refinement
	 *  validation
	 *  other
	 */
	public java.lang.String getClassification() 
	{
		return classification;
	}
 
	public void setClassification(java.lang.String classification)
	{
		this.classification = classification;
	}

 	protected java.lang.String compiler_name;


	/**
	 *  The compiler used to compile the software.
	 *  Convex Fortran
	 *  gcc
	 *  DEC C
	 */
	public java.lang.String getCompiler_name() 
	{
		return compiler_name;
	}
 
	public void setCompiler_name(java.lang.String compiler_name)
	{
		this.compiler_name = compiler_name;
	}

 	protected java.lang.String compiler_version;


	/**
	 *  The version of the compiler used to compile the software.
	 *  3.1
	 *  2.1 alpha
	 */
	public java.lang.String getCompiler_version() 
	{
		return compiler_version;
	}
 
	public void setCompiler_version(java.lang.String compiler_version)
	{
		this.compiler_version = compiler_version;
	}

 	protected java.lang.String contact_author;


	/**
	 *  The recognized contact author of the software. This could be
	 *  the original author, someone who has modified the code or
	 *  someone who maintains the code.  It should be the person
	 *  most commonly associated with the code.
	 *  T. Alwyn Jones
	 *  Axel Brunger
	 */
	public java.lang.String getContact_author() 
	{
		return contact_author;
	}
 
	public void setContact_author(java.lang.String contact_author)
	{
		this.contact_author = contact_author;
	}

 	protected java.lang.String contact_author_email;


	/**
	 *  The e-mail address of the person specified in
	 *  attribute contact_author in category software.
	 *  bourne@sdsc.edu
	 */
	public java.lang.String getContact_author_email() 
	{
		return contact_author_email;
	}
 
	public void setContact_author_email(java.lang.String contact_author_email)
	{
		this.contact_author_email = contact_author_email;
	}

 	protected java.lang.String date;


	/**
	 *  The date the software was released.
	 *  1991-10-01
	 *  1990-04-30
	 */
	public java.lang.String getDate() 
	{
		return date;
	}
 
	public void setDate(java.lang.String date)
	{
		this.date = date;
	}

 	protected java.lang.String dependencies;


	/**
	 *  Any prerequisite software required to run  attribute name in category software.
	 *  PDBlib class library
	 */
	public java.lang.String getDependencies() 
	{
		return dependencies;
	}
 
	public void setDependencies(java.lang.String dependencies)
	{
		this.dependencies = dependencies;
	}

 	protected java.lang.String description;


	/**
	 *  Description of the software.
	 *  Uses method of restrained least squares
	 */
	public java.lang.String getDescription() 
	{
		return description;
	}
 
	public void setDescription(java.lang.String description)
	{
		this.description = description;
	}

 	protected java.lang.String hardware;


	/**
	 *  The hardware upon which the software was run.
	 *  Sun Sparc 10 model 41
	 *  Dec Alpha 3000 model 500S
	 *  Silicon Graphics Elan
	 *  Compaq PC 486/66
	 */
	public java.lang.String getHardware() 
	{
		return hardware;
	}
 
	public void setHardware(java.lang.String hardware)
	{
		this.hardware = hardware;
	}

 	protected java.lang.String language;


	/**
	 *  The major computing language in which the software is
	 *  coded.
	 */
	public java.lang.String getLanguage() 
	{
		return language;
	}
 
	public void setLanguage(java.lang.String language)
	{
		this.language = language;
	}

 	protected java.lang.String location;


	/**
	 *  The URL for an Internet address at which
	 *  details of the software can be found.
	 *  http://rosebud.sdsc.edu/projects/pb/IUCr/software.html
	 *  ftp://ftp.sdsc.edu/pub/sdsc/biology/
	 */
	public java.lang.String getLocation() 
	{
		return location;
	}
 
	public void setLocation(java.lang.String location)
	{
		this.location = location;
	}

 	protected java.lang.String mods;


	/**
	 *  Any noteworthy modifications to the base software, if applicable.
	 *  Added support for space group F432
	 */
	public java.lang.String getMods() 
	{
		return mods;
	}
 
	public void setMods(java.lang.String mods)
	{
		this.mods = mods;
	}

 	protected java.lang.String name;


	/**
	 *  The name of the software.
	 *  Merlot
	 *  O
	 *  Xengen
	 *  X-plor
	 */
	public java.lang.String getName() 
	{
		return name;
	}
 
	public void setName(java.lang.String name)
	{
		this.name = name;
	}

 	protected java.lang.String os;


	/**
	 *  The name of the operating system under which the software
	 *  runs.
	 *  Ultrix
	 *  OpenVMS
	 *  DOS
	 *  Windows 95
	 *  Windows NT
	 *  Irix
	 *  HPUX
	 *  DEC Unix
	 */
	public java.lang.String getOs() 
	{
		return os;
	}
 
	public void setOs(java.lang.String os)
	{
		this.os = os;
	}

 	protected java.lang.String os_version;


	/**
	 *  The version of the operating system under which the software
	 *  runs.
	 *  3.1
	 *  4.2.1
	 */
	public java.lang.String getOs_version() 
	{
		return os_version;
	}
 
	public void setOs_version(java.lang.String os_version)
	{
		this.os_version = os_version;
	}

 	protected java.lang.String type;


	/**
	 *  The classification of the software according to the most
	 *  common types.
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 	protected java.lang.String version;


	/**
	 *  The version of the software.
	 *  v1.0
	 *  beta
	 *  3.1-2
	 *  unknown
	 */
	public java.lang.String getVersion() 
	{
		return version;
	}
 
	public void setVersion(java.lang.String version)
	{
		this.version = version;
	}

 }
