package org.pdb.beans;

/**
 *  Contains all the data items that refer to the space group as a
 *  whole, such as its name or crystal system. They may be looped,
 *  for example, in a list of space groups and their properties.
 *  
 *  Only a subset of the SPACE_GROUP category items appear in
 *  this dictionary.  The remainder are found in the symmetry CIF
 *  dictionary.
 *  
 *  Space-group types are identified by their number as given in
 *  International Tables for Crystallography Vol. A. Specific
 *  settings of the space groups can be identified either by their
 *  Hall symbol or by specifying their symmetry operations.
 *  
 *  The commonly used Hermann-Mauguin symbol determines the
 *  space-group type uniquely but several different Hermann-Mauguin
 *  symbols may refer to the same space-group type. A Hermann-Mauguin
 *  symbol contains information on the choice of the basis, but not
 *  on the choice of origin.  Different formats for the
 *  Hermann-Mauguin symbol are found in the symmetry CIF dictionary.
 *  
 * <pre>
 *  Example 1 - the monoclinic space group No. 15 with unique axis b.
 *  <PDBx:space_groupCategory>
 *  <PDBx:space_group id="1">
 *  <PDBx:name_H-M_alt>C 2/c</PDBx:name_H-M_alt>
 *  <PDBx:IT_number>15</PDBx:IT_number>
 *  <PDBx:name_Hall>-C 2yc</PDBx:name_Hall>
 *  <PDBx:crystal_system>monoclinic</PDBx:crystal_system>
 *  </PDBx:space_group>
 *  </PDBx:space_groupCategory>
 * </pre>
 */
public class Space_group 
{
		protected java.lang.Integer IT_number;


	/**
	 *  The number as assigned in International Tables for
	 *  Crystallography Vol. A, specifying the proper affine class (i.e.
	 *  the orientation-preserving affine class) of space groups
	 *  (crystallographic space-group type) to which the space group
	 *  belongs.  This number defines the space-group type but not
	 *  the coordinate system in which it is expressed.
	 */
	public java.lang.Integer getIT_number() 
	{
		return IT_number;
	}
 
	public void setIT_number(java.lang.Integer IT_number)
	{
		this.IT_number = IT_number;
	}

 	protected java.lang.String crystal_system;


	/**
	 *  The name of the system of geometric crystal classes of space
	 *  groups (crystal system) to which the space group belongs.
	 *  Note that rhombohedral space groups belong to the
	 *  trigonal system.
	 */
	public java.lang.String getCrystal_system() 
	{
		return crystal_system;
	}
 
	public void setCrystal_system(java.lang.String crystal_system)
	{
		this.crystal_system = crystal_system;
	}

 	protected java.lang.String id_;


	/**
	 *  This is the unique identifier for the SPACE_GROUP category.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String name_H_M_alt;


	/**
	 *  attribute name_H-M_alt in category space_group allows any Hermann-Mauguin symbol
	 *  to be given. The way in which this item is used is determined
	 *  by the user and in general is not intended to be interpreted by
	 *  computer. It may, for example, be used to give one of the
	 *  extended Hermann-Mauguin symbols given in Table 4.3.2.1 of
	 *  International Tables for Crystallography Vol. A (2002) or
	 *  a Hermann-Mauguin symbol for a conventional or unconventional
	 *  setting.
	 *  
	 *  Each component of the space-group name is separated by a
	 *  space or an underscore. The use of a space is strongly
	 *  recommended.  The underscore is only retained because it
	 *  was used in old CIFs. It should not be
	 *  used in new CIFs. Subscripts should appear without special
	 *  symbols. Bars should be given as negative signs before the
	 *  numbers to which they apply.
	 *  
	 *  The commonly used Hermann-Mauguin symbol determines the space-
	 *  group type uniquely but a given space-group type may be
	 *  described by more than one Hermann-Mauguin symbol. The space-
	 *  group type is best described using  attribute IT_number.
	 *  in category space_group
	 *  The Hermann-Mauguin symbol may contain information on the
	 *  choice of basis, but not on the choice of origin. To
	 *  define the setting uniquely, use  attribute name_Hall in category space_group or
	 *  list the symmetry operations.
	 *  three examples for space group No. 63
	 *  loop_
	 *  _space_group.name_H-M_alt
	 *  'C m c m'
	 *  'C 2/c 2/m 21/m'
	 *  'A m a m'
	 */
	public java.lang.String getName_H_M_alt() 
	{
		return name_H_M_alt;
	}
 
	public void setName_H_M_alt(java.lang.String name_H_M_alt)
	{
		this.name_H_M_alt = name_H_M_alt;
	}

 	protected java.lang.String name_Hall;


	/**
	 *  Space-group symbol defined by Hall.
	 *  
	 *  Each component of the space-group name is separated by a
	 *  space or an underscore.  The use of a space is strongly
	 *  recommended.  The underscore is only retained because it
	 *  was used in old CIFs.  It should not be
	 *  used in new CIFs.
	 *  
	 *  attribute name_Hall in category space_group uniquely defines the space group and
	 *  its reference to a particular coordinate system.
	 *  
	 *  Ref: Hall, S. R. (1981). Acta Cryst. A37, 517-525; erratum
	 *  (1981), A37, 921.
	 *  [See also International Tables for Crystallography
	 *  Vol. B (2001), Chapter 1.4, Appendix 1.4.2.]
	 *  equivalent to Pca21
	 *  P 2c -2ac
	 *  equivalent to Ia3d
	 *  -I 4bd 2ab 3
	 */
	public java.lang.String getName_Hall() 
	{
		return name_Hall;
	}
 
	public void setName_Hall(java.lang.String name_Hall)
	{
		this.name_Hall = name_Hall;
	}

 }
