package org.pdb.beans;

/**
 *  Contains information about the symmetry operations of the
 *  space group.
 *  
 * <pre>
 *  Example 1 - The symmetry operations for the space group P21/c.
 *  <PDBx:space_group_symopCategory>
 *  <PDBx:space_group_symop id="1">
 *  <PDBx:operation_xyz>x,y,z</PDBx:operation_xyz>
 *  </PDBx:space_group_symop>
 *  <PDBx:space_group_symop id="2">
 *  <PDBx:operation_xyz>-x,-y,-z</PDBx:operation_xyz>
 *  </PDBx:space_group_symop>
 *  <PDBx:space_group_symop id="3">
 *  <PDBx:operation_xyz>-x,1/2+y,1/2-z</PDBx:operation_xyz>
 *  </PDBx:space_group_symop>
 *  <PDBx:space_group_symop id="4">
 *  <PDBx:operation_xyz>x,1/2-y,1/2+z</PDBx:operation_xyz>
 *  </PDBx:space_group_symop>
 *  </PDBx:space_group_symopCategory>
 * </pre>
 */
public class Space_group_symop 
{
		protected java.lang.String id_;


	/**
	 *  An arbitrary identifier that uniquely labels each symmetry
	 *  operation in the list.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String operation_xyz;


	/**
	 *  A parsable string giving one of the symmetry operations of the
	 *  space group in algebraic form.  If W is a matrix representation
	 *  of the rotational part of the symmetry operation defined by the
	 *  positions and signs of x, y and z, and w is a column of
	 *  translations defined by the fractions, an equivalent position
	 *  X' is generated from a given position X by the equation
	 *  
	 *  X' = WX + w
	 *  
	 *  (Note: X is used to represent bold_italics_x in International
	 *  Tables for Crystallography Vol. A, Part 5)
	 *  
	 *  When a list of symmetry operations is given, it must contain
	 *  a complete set of coordinate representatives which generates
	 *  all the operations of the space group by the addition of
	 *  all primitive translations of the space group. Such
	 *  representatives are to be found as the coordinates of
	 *  the general-equivalent position in International Tables for
	 *  Crystallography Vol. A (2002), to which it is necessary to
	 *  add any centring translations shown above the
	 *  general-equivalent position.
	 *  
	 *  That is to say, it is necessary to list explicity all the
	 *  symmetry operations required to generate all the atoms in
	 *  the unit cell defined by the setting used.
	 *  glide reflection through the plane (x,1/4,z),
	 *  with glide vector 1/2 c
	 *  x,1/2-y,1/2+z
	 */
	public java.lang.String getOperation_xyz() 
	{
		return operation_xyz;
	}
 
	public void setOperation_xyz(java.lang.String operation_xyz)
	{
		this.operation_xyz = operation_xyz;
	}

 	protected java.lang.String sg_id;


	/**
	 *  This must match a particular value of  attribute id in category space_group allowing
	 *  the symmetry operation to be identified with a particular space
	 *  group.
	 */
	public java.lang.String getSg_id() 
	{
		return sg_id;
	}
 
	public void setSg_id(java.lang.String sg_id)
	{
		this.sg_id = sg_id;
	}

 }
