package org.pdb.beans;

/**
 *  Data items in the STRUCT_BIOL category record details about
 *  the structural elements that form each structure of biological
 *  significance.
 *  
 *  A given crystal structure may contain many different biological
 *  structures. A given structural component in the asymmetric
 *  unit may be part of more than one biological unit. A given
 *  biological structure may involve crystallographic symmetry.
 *  
 *  For instance, in a structure of a lysozyme-FAB structure, the
 *  light- and heavy-chain components of the FAB could be one
 *  biological unit, while the two chains of the FAB and the lysozyme
 *  could constitute a second biological unit.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_biolCategory>
 *  <PDBx:struct_biol id="1">
 *  <PDBx:details> significant deviations from twofold symmetry exist in this
 *  dimeric enzyme</PDBx:details>
 *  </PDBx:struct_biol>
 *  <PDBx:struct_biol id="2">
 *  <PDBx:details> The drug binds to this enzyme in two roughly twofold
 *  symmetric modes. Hence this biological unit (2) is roughly
 *  twofold symmetric to biological unit (3). Disorder in the
 *  protein chain indicated with alternative ID 1 should be
 *  used with this biological unit.</PDBx:details>
 *  </PDBx:struct_biol>
 *  <PDBx:struct_biol id="3">
 *  <PDBx:details> The drug binds to this enzyme in two roughly twofold
 *  symmetric modes. Hence this biological unit (3) is roughly
 *  twofold symmetric to biological unit (2). Disorder in the
 *  protein chain indicated with alternative ID 2 should be
 *  used with this biological unit.</PDBx:details>
 *  </PDBx:struct_biol>
 *  </PDBx:struct_biolCategory>
 * </pre>
 */
public class Struct_biol 
{
		protected java.lang.String details;


	/**
	 *  A description of special aspects of the biological unit.
	 *  The drug binds to this enzyme in two roughly
	 *  twofold symmetric modes. Hence this
	 *  biological unit (3) is roughly twofold
	 *  symmetric to biological unit (2). Disorder in
	 *  the protein chain indicated with alternative
	 *  ID 2 should be used with this biological unit.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category struct_biol must uniquely identify a record in
	 *  the STRUCT_BIOL list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String pdbx_aggregation_state;


	/**
	 *  A description of the structural aggregation in this assembly.
	 */
	public java.lang.String getPdbx_aggregation_state() 
	{
		return pdbx_aggregation_state;
	}
 
	public void setPdbx_aggregation_state(java.lang.String pdbx_aggregation_state)
	{
		this.pdbx_aggregation_state = pdbx_aggregation_state;
	}

 	protected java.lang.String pdbx_assembly_method;


	/**
	 *  The method or experiment used to determine this assembly.
	 *  AUTHOR PROVIDED', 'LCMS', 'PISA', 'PQS
	 */
	public java.lang.String getPdbx_assembly_method() 
	{
		return pdbx_assembly_method;
	}
 
	public void setPdbx_assembly_method(java.lang.String pdbx_assembly_method)
	{
		this.pdbx_assembly_method = pdbx_assembly_method;
	}

 	protected java.lang.Float pdbx_formula_weight;


	/**
	 *  Estimated formula mass in daltons of the
	 *  biological assembly.
	 */
	public java.lang.Float getPdbx_formula_weight() 
	{
		return pdbx_formula_weight;
	}
 
	public void setPdbx_formula_weight(java.lang.Float pdbx_formula_weight)
	{
		this.pdbx_formula_weight = pdbx_formula_weight;
	}

 	protected java.lang.String pdbx_formula_weight_method;


	/**
	 *  Method used to determine  attribute pdbx_formula_weight in category struct_biol.
	 *  MASS SPEC
	 *  CALCULATION
	 */
	public java.lang.String getPdbx_formula_weight_method() 
	{
		return pdbx_formula_weight_method;
	}
 
	public void setPdbx_formula_weight_method(java.lang.String pdbx_formula_weight_method)
	{
		this.pdbx_formula_weight_method = pdbx_formula_weight_method;
	}

 	protected java.lang.String pdbx_parent_biol_id;


	/**
	 *  An identifier for the parent biological assembly
	 *  if this biological unit is part of a complex assembly.
	 *  1
	 *  2
	 *  3
	 */
	public java.lang.String getPdbx_parent_biol_id() 
	{
		return pdbx_parent_biol_id;
	}
 
	public void setPdbx_parent_biol_id(java.lang.String pdbx_parent_biol_id)
	{
		this.pdbx_parent_biol_id = pdbx_parent_biol_id;
	}

 }
