package org.pdb.beans;

/**
 *  Data items in the STRUCT_CONN_TYPE category record details
 *  about the criteria used to identify interactions between
 *  portions of the structure.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_conn_typeCategory>
 *  <PDBx:struct_conn_type id="saltbr">
 *  <PDBx:criteria>negative to positive distance &gt; 2.5 \&#37;A, &lt; 3.2 \&#37;A</PDBx:criteria>
 *  </PDBx:struct_conn_type>
 *  <PDBx:struct_conn_type id="hydrog">
 *  <PDBx:criteria>NO distance &gt; 2.5\&#37;A, &lt; 3.5\&#37;A, NOC angle &lt; 120 degrees</PDBx:criteria>
 *  </PDBx:struct_conn_type>
 *  </PDBx:struct_conn_typeCategory>
 * </pre>
 */
public class Struct_conn_type 
{
		protected java.lang.String criteria;


	/**
	 *  The criteria used to define the interaction.
	 *  O to N distance > 2.5 \%A, < 3.2 \%A
	 *  authors judgement
	 */
	public java.lang.String getCriteria() 
	{
		return criteria;
	}
 
	public void setCriteria(java.lang.String criteria)
	{
		this.criteria = criteria;
	}

 	protected java.lang.String id_;


	/**
	 *  The chemical or structural type of the interaction.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String reference;


	/**
	 *  A reference that specifies the criteria used to define the
	 *  interaction.
	 */
	public java.lang.String getReference() 
	{
		return reference;
	}
 
	public void setReference(java.lang.String reference)
	{
		this.reference = reference;
	}

 }
