package org.pdb.beans;

/**
 *  Data items in the STRUCT_MON_DETAILS category record details
 *  about specifics of calculations summarized in data items in the
 *  STRUCT_MON_PROT and STRUCT_MON_NUCL categories. These can
 *  include the coefficients used in map calculations,
 *  the radii used for including points in a calculation and so on.
 */
public class Struct_mon_details 
{
		protected java.lang.String RSCC;


	/**
	 *  This data item describes the specifics of the calculations that
	 *  generated the values given in  attribute RSCC_all,
	 *  in category struct_mon_prot _struct_mon_prot.RSCC_main and _struct_mon_prot.RSCC_side. The
	 *  coefficients used to calculate the p(o) and p(c) maps should be
	 *  given as well as the criterion for the inclusion of map grid
	 *  points in the calculation.
	 *  The map p(o) was calculated with coefficients
	 *  2F(o) - F(c) and with phase alpha(c). F(o)
	 *  are the observed structure-factor amplitudes,
	 *  F(c) are the amplitudes calculated from the
	 *  current model and alpha(c) are the phases
	 *  calculated from the current model.
	 *  The map p(c) was calculated in program O using
	 *  a Gaussian distribution function around the
	 *  atoms in the current model.
	 *  Map grid points within 1.5 A of the
	 *  designated atoms were included in the
	 *  calculation.
	 *  The map p(o) was calculated with coefficients
	 *  F(o) and with phase alpha(c). F(o) are the
	 *  observed structure-factor amplitudes, and
	 *  alpha(c) are the phases calculated from the
	 *  current model.
	 *  The map p(c) was calculated with coefficients
	 *  F(c) and with phases alpha(c). F(c) and
	 *  alpha(c) are the structure-factor amplitudes
	 *  and phases, respectively, calculated from the
	 *  current model.
	 *  Map grid points within a van der Waals radius
	 *  of the designated atoms were included in the
	 *  calculation.
	 */
	public java.lang.String getRSCC() 
	{
		return RSCC;
	}
 
	public void setRSCC(java.lang.String RSCC)
	{
		this.RSCC = RSCC;
	}

 	protected java.lang.String RSR;


	/**
	 *  This data item describes the specifics of the calculations that
	 *  generated the values given in  attribute RSR_all,
	 *  in category struct_mon_prot _struct_mon_prot.RSR_main and _struct_mon_prot.RSR_side. The
	 *  coefficients used to calculate the p(o) and p(c) maps should be
	 *  given as well as the criterion for the inclusion of map grid
	 *  points in the calculation.
	 *  The map p(o) was calculated with coefficients
	 *  2F(o) - F(c) and with phase alpha(c). F(o)
	 *  are the observed structure-factor amplitudes,
	 *  F(c) are the amplitudes calculated from the
	 *  current model and alpha(c) are the phases
	 *  calculated from the current model.
	 *  The map p(c) was calculated in program O using
	 *  a Gaussian distribution function around the
	 *  atoms in the current model.
	 *  Map grid points within 1.5 A of the
	 *  designated atoms were included in the
	 *  calculation.
	 *  The map p(o) was calculated with coefficients
	 *  F(o) and with phase alpha(c). F(o) are the
	 *  observed structure-factor amplitudes, and
	 *  alpha(c) are the phases calculated from the
	 *  current model.
	 *  The map p(c) was calculated with coefficients
	 *  F(c) and with phases alpha(c). F(c) and
	 *  alpha(c) are the structure-factor amplitudes
	 *  and phases, respectively, calculated from the
	 *  current model.
	 *  Map grid points within a van der Waals radius
	 *  of the designated atoms were included in the
	 *  calculation.
	 */
	public java.lang.String getRSR() 
	{
		return RSR;
	}
 
	public void setRSR(java.lang.String RSR)
	{
		this.RSR = RSR;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.Float prot_cis;


	/**
	 *  An ideal cis peptide bond would have an omega torsion angle of
	 *  zero. This data item gives the value in degrees by which the
	 *  observed torsion angle can differ from 0.0 and still be
	 *  considered cis.
	 *  30.0
	 */
	public java.lang.Float getProt_cis() 
	{
		return prot_cis;
	}
 
	public void setProt_cis(java.lang.Float prot_cis)
	{
		this.prot_cis = prot_cis;
	}

 }
