package org.pdb.beans;

/**
 *  Data items in the STRUCT_MON_NUCL category record details about
 *  structural properties of a nucleic acid when analyzed at the
 *  monomer level. Analogous data items for proteins are given in
 *  the STRUCT_MON_PROT category. For items where the value of the
 *  property depends on the method employed to calculate it,
 *  details of the method of calculation are given using data items
 *  in the STRUCT_MON_DETAILS category.
 *  
 * <pre>
 *  Example 1 - based on NDB structure BDL028.
 *  <PDBx:struct_mon_nuclCategory>
 *  <PDBx:struct_mon_nucl label_comp_id="C" label_seq_id="1" label_asym_id="A" label_alt_id="">
 *  <PDBx:gamma>29.9</PDBx:gamma>
 *  <PDBx:delta>131.9</PDBx:delta>
 *  <PDBx:epsilon>222.1</PDBx:epsilon>
 *  <PDBx:zeta>174.2</PDBx:zeta>
 *  </PDBx:struct_mon_nucl>
 *  <PDBx:struct_mon_nucl label_comp_id="G" label_seq_id="2" label_asym_id="A" label_alt_id="">
 *  <PDBx:alpha>334.0</PDBx:alpha>
 *  <PDBx:beta>130.6</PDBx:beta>
 *  <PDBx:gamma>33.1</PDBx:gamma>
 *  <PDBx:delta>125.6</PDBx:delta>
 *  <PDBx:epsilon>167.6</PDBx:epsilon>
 *  <PDBx:zeta>270.9</PDBx:zeta>
 *  </PDBx:struct_mon_nucl>
 *  <PDBx:struct_mon_nucl label_comp_id="T" label_seq_id="3" label_asym_id="A" label_alt_id="">
 *  <PDBx:alpha>258.2</PDBx:alpha>
 *  <PDBx:beta>178.7</PDBx:beta>
 *  <PDBx:gamma>101.0</PDBx:gamma>
 *  <PDBx:delta>114.6</PDBx:delta>
 *  <PDBx:epsilon>216.6</PDBx:epsilon>
 *  <PDBx:zeta>259.3</PDBx:zeta>
 *  </PDBx:struct_mon_nucl>
 *  </PDBx:struct_mon_nuclCategory>
 * </pre>
 */
public class Struct_mon_nucl 
{
		protected java.lang.Float P;


	/**
	 *  P is the phase angle of pseudorotation for five-membered rings.
	 *  For ribose and deoxyribose sugars in nucleic
	 *  acids
	 *  (tau4 +tau1)-(tau3+tau0)
	 *  P = ATAN (-------------------------)
	 *  2tau2 (sin 36+sin 72)
	 *  
	 *  If tau2 is <0, then P=P+180 degree (Altona & Sundaralingam,
	 *  1972).
	 *  
	 *  Ref: Altona, C. & Sundaralingam, M. (1972).
	 *  J. Am. Chem. Soc. 94, 8205-8212.
	 */
	public java.lang.Float getP() 
	{
		return P;
	}
 
	public void setP(java.lang.Float P)
	{
		this.P = P;
	}

 	protected java.lang.Float RSCC_all;


	/**
	 *  The real-space (linear) correlation coefficient RSCC, as
	 *  described by Jones et al. (1991), evaluated over all atoms in the
	 *  nucleic acid monomer.
	 *  
	 *  sum|p~obs~ - <p~obs~>| * sum|p~calc~ - <p~calc~>|
	 *  RSCC = -------------------------------------------------
	 *  [ sum|p~obs~  - <p~obs~> |^2^
	 *  * sum|p~calc~ - <p~calc~>|^2^ ]^1/2^
	 *  
	 *  p~obs~  = the density in an 'experimental' map
	 *  p~calc~ = the density in a 'calculated' map
	 *  
	 *  sum is taken over the specified grid points
	 *  
	 *  Details of how these maps were calculated should be given
	 *  in  attribute RSCC in category struct_mon_details.  < > indicates an average and the
	 *  sums are taken over all map grid  points near the relevant atoms.
	 *  The radius for including grid points in the calculation should
	 *  also be given in  attribute RSCC.
	 *  in category struct_mon_details
	 *  Ref: Jones, T. A., Zou, J.-Y., Cowan, S. W. & Kjeldgaard, M.
	 *  (1991). Acta Cryst. A47, 110-119.
	 */
	public java.lang.Float getRSCC_all() 
	{
		return RSCC_all;
	}
 
	public void setRSCC_all(java.lang.Float RSCC_all)
	{
		this.RSCC_all = RSCC_all;
	}

 	protected java.lang.Float RSCC_base;


	/**
	 *  The real-space (linear) correlation coefficient RSCC, as
	 *  described by Jones et al. (1991), evaluated over all atoms in the
	 *  base moiety of the nucleic acid monomer.
	 *  
	 *  sum|p~obs~ - <p~obs~>| * sum|p~calc~ - <p~calc~>|
	 *  RSCC = -------------------------------------------------
	 *  [ sum|p~obs~  - <p~obs~> |^2^
	 *  * sum|p~calc~ - <p~calc~>|^2^ ]^1/2^
	 *  
	 *  p~obs~  = the density in an 'experimental' map
	 *  p~calc~ = the density in a 'calculated' map
	 *  
	 *  sum is taken over the specified grid points
	 *  
	 *  Details of how these maps were calculated should be given
	 *  in  attribute RSCC in category struct_mon_details.  < > indicates an average and the
	 *  sums are taken over all map grid  points near the relevant atoms.
	 *  The radius for including grid points in the calculation should
	 *  also be given in  attribute RSCC.
	 *  in category struct_mon_details
	 *  Ref: Jones, T. A., Zou, J.-Y., Cowan, S. W. & Kjeldgaard, M.
	 *  (1991). Acta Cryst. A47, 110-119.
	 */
	public java.lang.Float getRSCC_base() 
	{
		return RSCC_base;
	}
 
	public void setRSCC_base(java.lang.Float RSCC_base)
	{
		this.RSCC_base = RSCC_base;
	}

 	protected java.lang.Float RSCC_phos;


	/**
	 *  The real-space (linear) correlation coefficient RSCC, as
	 *  described by Jones et al. (1991), evaluated over all atoms in the
	 *  phosphate moiety of the nucleic acid monomer.
	 *  
	 *  sum|p~obs~ - <p~obs~>| * sum|p~calc~ - <p~calc~>|
	 *  RSCC = -------------------------------------------------
	 *  [ sum|p~obs~  - <p~obs~> |^2^
	 *  * sum|p~calc~ - <p~calc~>|^2^ ]^1/2^
	 *  
	 *  p~obs~  = the density in an 'experimental' map
	 *  p~calc~ = the density in a 'calculated' map
	 *  
	 *  sum is taken over the specified grid points
	 *  
	 *  Details of how these maps were calculated should be given
	 *  in  attribute RSCC in category struct_mon_details.  < > indicates an average and the
	 *  sums are taken over all map grid  points near the relevant atoms.
	 *  The radius for including grid points in the calculation should
	 *  also be given in  attribute RSCC.
	 *  in category struct_mon_details
	 *  Ref: Jones, T. A., Zou, J.-Y., Cowan, S. W. & Kjeldgaard, M.
	 *  (1991). Acta Cryst. A47, 110-119.
	 */
	public java.lang.Float getRSCC_phos() 
	{
		return RSCC_phos;
	}
 
	public void setRSCC_phos(java.lang.Float RSCC_phos)
	{
		this.RSCC_phos = RSCC_phos;
	}

 	protected java.lang.Float RSCC_sugar;


	/**
	 *  The real-space (linear) correlation coefficient RSCC, as
	 *  described by Jones et al. (1991), evaluated over all atoms in the
	 *  sugar moiety of the nucleic acid monomer.
	 *  
	 *  sum|p~obs~ - <p~obs~>| * sum|p~calc~ - <p~calc~>|
	 *  RSCC = -------------------------------------------------
	 *  [ sum|p~obs~  - <p~obs~> |^2^
	 *  * sum|p~calc~ - <p~calc~>|^2^ ]^1/2^
	 *  
	 *  p~obs~  = the density in an 'experimental' map
	 *  p~calc~ = the density in a 'calculated' map
	 *  
	 *  sum is taken over the specified grid points
	 *  
	 *  Details of how these maps were calculated should be given
	 *  in  attribute RSCC in category struct_mon_details.  < > indicates an average and the
	 *  sums are taken over all map grid  points near the relevant atoms.
	 *  The radius for including grid points in the calculation should
	 *  also be given in  attribute RSCC.
	 *  in category struct_mon_details
	 *  Ref: Jones, T. A., Zou, J.-Y., Cowan, S. W. & Kjeldgaard, M.
	 *  (1991). Acta Cryst. A47, 110-119.
	 */
	public java.lang.Float getRSCC_sugar() 
	{
		return RSCC_sugar;
	}
 
	public void setRSCC_sugar(java.lang.Float RSCC_sugar)
	{
		this.RSCC_sugar = RSCC_sugar;
	}

 	protected java.lang.Float RSR_all;


	/**
	 *  The real-space residual RSR, as described by Branden & Jones
	 *  (1990), evaluated over all atoms in the nucleic acid monomer.
	 *  
	 *  sum|p~obs~ - p~calc~|
	 *  RSR = ---------------------
	 *  sum|p~obs~ + p~calc~|
	 *  
	 *  p~obs~  = the density in an 'experimental' map
	 *  p~calc~ = the density in a 'calculated' map
	 *  
	 *  sum is taken over the specified grid points
	 *  
	 *  Details of how these maps were calculated should be given
	 *  in  attribute RSR in category struct_mon_details.  The sums are taken over all map grid
	 *  points near the relevant atoms. The radius for including grid
	 *  points in the calculation should also be given in
	 *  attribute RSR.
	 *  in category struct_mon_details
	 *  Ref: Branden, C.-I. & Jones, T. A. (1990). Nature (London), 343,
	 *  687-689.
	 */
	public java.lang.Float getRSR_all() 
	{
		return RSR_all;
	}
 
	public void setRSR_all(java.lang.Float RSR_all)
	{
		this.RSR_all = RSR_all;
	}

 	protected java.lang.Float RSR_base;


	/**
	 *  The real-space residual RSR, as described by Branden & Jones
	 *  (1990), evaluated over all atoms in the base moiety of the
	 *  nucleic acid monomer.
	 *  
	 *  sum|p~obs~ - p~calc~|
	 *  RSR = ---------------------
	 *  sum|p~obs~ + p~calc~|
	 *  
	 *  p~obs~  = the density in an 'experimental' map
	 *  p~calc~ = the density in a 'calculated' map
	 *  
	 *  sum is taken over the specified grid points
	 *  
	 *  Details of how these maps were calculated should be given
	 *  in  attribute RSR in category struct_mon_details.  The sums are taken over all map grid
	 *  points near the relevant atoms. The radius for including grid
	 *  points in the calculation should also be given in
	 *  attribute RSR.
	 *  in category struct_mon_details
	 *  Ref: Branden, C.-I. & Jones, T. A. (1990). Nature (London), 343,
	 *  687-689.
	 */
	public java.lang.Float getRSR_base() 
	{
		return RSR_base;
	}
 
	public void setRSR_base(java.lang.Float RSR_base)
	{
		this.RSR_base = RSR_base;
	}

 	protected java.lang.Float RSR_phos;


	/**
	 *  The real-space residual RSR, as described by Branden & Jones
	 *  (1990), evaluated over all atoms in the phosphate moiety of the
	 *  nucleic acid monomer.
	 *  
	 *  sum|p~obs~ - p~calc~|
	 *  RSR = ---------------------
	 *  sum|p~obs~ + p~calc~|
	 *  
	 *  p~obs~  = the density in an 'experimental' map
	 *  p~calc~ = the density in a 'calculated' map
	 *  
	 *  sum is taken over the specified grid points
	 *  
	 *  Details of how these maps were calculated should be given
	 *  in  attribute RSR in category struct_mon_details.  The sums are taken over all map grid
	 *  points near the relevant atoms. The radius for including grid
	 *  points in the calculation should also be given in
	 *  attribute RSR.
	 *  in category struct_mon_details
	 *  Ref: Branden, C.-I. & Jones, T. A. (1990). Nature (London), 343,
	 *  687-689.
	 */
	public java.lang.Float getRSR_phos() 
	{
		return RSR_phos;
	}
 
	public void setRSR_phos(java.lang.Float RSR_phos)
	{
		this.RSR_phos = RSR_phos;
	}

 	protected java.lang.Float RSR_sugar;


	/**
	 *  The real-space residual RSR, as described by Branden & Jones
	 *  (1990), evaluated over all atoms in the sugar moiety of the
	 *  nucleic acid monomer.
	 *  
	 *  sum|p~obs~ - p~calc~|
	 *  RSR = ---------------------
	 *  sum|p~obs~ + p~calc~|
	 *  
	 *  p~obs~  = the density in an 'experimental' map
	 *  p~calc~ = the density in a 'calculated' map
	 *  
	 *  sum is taken over the specified grid points
	 *  
	 *  Details of how these maps were calculated should be given
	 *  in  attribute RSR in category struct_mon_details.  The sums are taken over all map grid
	 *  points near the relevant atoms. The radius for including grid
	 *  points in the calculation should also be given in
	 *  attribute RSR.
	 *  in category struct_mon_details
	 *  Ref: Branden, C.-I. & Jones, T. A. (1990). Nature (London), 343,
	 *  687-689.
	 */
	public java.lang.Float getRSR_sugar() 
	{
		return RSR_sugar;
	}
 
	public void setRSR_sugar(java.lang.Float RSR_sugar)
	{
		this.RSR_sugar = RSR_sugar;
	}

 	protected java.lang.Float alpha;


	/**
	 *  The value in degrees of the backbone torsion angle alpha
	 *  (O3'-P-O5'-C5').
	 */
	public java.lang.Float getAlpha() 
	{
		return alpha;
	}
 
	public void setAlpha(java.lang.Float alpha)
	{
		this.alpha = alpha;
	}

 	protected java.lang.String auth_asym_id;


	/**
	 *  A component of the identifier for participants in the site.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAuth_asym_id() 
	{
		return auth_asym_id;
	}
 
	public void setAuth_asym_id(java.lang.String auth_asym_id)
	{
		this.auth_asym_id = auth_asym_id;
	}

 	protected java.lang.String auth_comp_id;


	/**
	 *  A component of the identifier for participants in the site.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAuth_comp_id() 
	{
		return auth_comp_id;
	}
 
	public void setAuth_comp_id(java.lang.String auth_comp_id)
	{
		this.auth_comp_id = auth_comp_id;
	}

 	protected java.lang.String auth_seq_id;


	/**
	 *  A component of the identifier for participants in the site.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAuth_seq_id() 
	{
		return auth_seq_id;
	}
 
	public void setAuth_seq_id(java.lang.String auth_seq_id)
	{
		this.auth_seq_id = auth_seq_id;
	}

 	protected java.lang.Float beta;


	/**
	 *  The value in degrees of the backbone torsion angle beta
	 *  (P-O5'-C5'-C4').
	 */
	public java.lang.Float getBeta() 
	{
		return beta;
	}
 
	public void setBeta(java.lang.Float beta)
	{
		this.beta = beta;
	}

 	protected java.lang.Float chi1;


	/**
	 *  The value in degrees of the sugar-base torsion angle chi1
	 *  (O4'-C1'-N1-C2).
	 */
	public java.lang.Float getChi1() 
	{
		return chi1;
	}
 
	public void setChi1(java.lang.Float chi1)
	{
		this.chi1 = chi1;
	}

 	protected java.lang.Float chi2;


	/**
	 *  The value in degrees of the sugar-base torsion angle chi2
	 *  (O4'-C1'-N9-C4).
	 */
	public java.lang.Float getChi2() 
	{
		return chi2;
	}
 
	public void setChi2(java.lang.Float chi2)
	{
		this.chi2 = chi2;
	}

 	protected java.lang.Float delta;


	/**
	 *  The value in degrees of the backbone torsion angle delta
	 *  (C5'-C4'-C3'-O3').
	 */
	public java.lang.Float getDelta() 
	{
		return delta;
	}
 
	public void setDelta(java.lang.Float delta)
	{
		this.delta = delta;
	}

 	protected java.lang.Float details;


	/**
	 *  A description of special aspects of the residue, its
	 *  conformation, behaviour in refinement, or any other aspect
	 *  that requires annotation.
	 *  Part of the phosphodiester backbone not in
	 *  density.
	 */
	public java.lang.Float getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.Float details)
	{
		this.details = details;
	}

 	protected java.lang.Float epsilon;


	/**
	 *  The value in degrees of the backbone torsion angle epsilon
	 *  (C4'-C3'-O3'-P).
	 */
	public java.lang.Float getEpsilon() 
	{
		return epsilon;
	}
 
	public void setEpsilon(java.lang.Float epsilon)
	{
		this.epsilon = epsilon;
	}

 	protected java.lang.Float gamma;


	/**
	 *  The value in degrees of the backbone torsion angle gamma
	 *  (O5'-C5'-C4'-C3').
	 */
	public java.lang.Float getGamma() 
	{
		return gamma;
	}
 
	public void setGamma(java.lang.Float gamma)
	{
		this.gamma = gamma;
	}

 	protected java.lang.String label_alt_id;


	/**
	 *  A component of the identifier for participants in the site.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_sites_alt in the
	 *  ATOM_SITES_ALT category.
	 */
	public java.lang.String getLabel_alt_id() 
	{
		return label_alt_id;
	}
 
	public void setLabel_alt_id(java.lang.String label_alt_id)
	{
		this.label_alt_id = label_alt_id;
	}

 	protected java.lang.String label_asym_id;


	/**
	 *  A component of the identifier for participants in the site.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getLabel_asym_id() 
	{
		return label_asym_id;
	}
 
	public void setLabel_asym_id(java.lang.String label_asym_id)
	{
		this.label_asym_id = label_asym_id;
	}

 	protected java.lang.String label_comp_id;


	/**
	 *  A component of the identifier for participants in the site.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getLabel_comp_id() 
	{
		return label_comp_id;
	}
 
	public void setLabel_comp_id(java.lang.String label_comp_id)
	{
		this.label_comp_id = label_comp_id;
	}

 	protected java.lang.Integer label_seq_id;


	/**
	 *  A component of the identifier for participants in the site.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getLabel_seq_id() 
	{
		return label_seq_id;
	}
 
	public void setLabel_seq_id(java.lang.Integer label_seq_id)
	{
		this.label_seq_id = label_seq_id;
	}

 	protected java.lang.Float mean_B_all;


	/**
	 *  The mean value of the isotropic displacement parameter
	 *  for all atoms in the monomer.
	 */
	public java.lang.Float getMean_B_all() 
	{
		return mean_B_all;
	}
 
	public void setMean_B_all(java.lang.Float mean_B_all)
	{
		this.mean_B_all = mean_B_all;
	}

 	protected java.lang.Float mean_B_base;


	/**
	 *  The mean value of the isotropic displacement parameter
	 *  for atoms in the base moiety of the nucleic acid monomer.
	 */
	public java.lang.Float getMean_B_base() 
	{
		return mean_B_base;
	}
 
	public void setMean_B_base(java.lang.Float mean_B_base)
	{
		this.mean_B_base = mean_B_base;
	}

 	protected java.lang.Float mean_B_phos;


	/**
	 *  The mean value of the isotropic displacement parameter
	 *  for atoms in the phosphate moiety of the nucleic acid monomer.
	 */
	public java.lang.Float getMean_B_phos() 
	{
		return mean_B_phos;
	}
 
	public void setMean_B_phos(java.lang.Float mean_B_phos)
	{
		this.mean_B_phos = mean_B_phos;
	}

 	protected java.lang.Float mean_B_sugar;


	/**
	 *  The mean value of the isotropic displacement parameter
	 *  for atoms in the sugar moiety of the nucleic acid monomer.
	 */
	public java.lang.Float getMean_B_sugar() 
	{
		return mean_B_sugar;
	}
 
	public void setMean_B_sugar(java.lang.Float mean_B_sugar)
	{
		this.mean_B_sugar = mean_B_sugar;
	}

 	protected java.lang.Float nu0;


	/**
	 *  The value in degrees of the sugar torsion angle nu0
	 *  (C4'-O4'-C1'-C2').
	 */
	public java.lang.Float getNu0() 
	{
		return nu0;
	}
 
	public void setNu0(java.lang.Float nu0)
	{
		this.nu0 = nu0;
	}

 	protected java.lang.Float nu1;


	/**
	 *  The value in degrees of the sugar torsion angle nu1
	 *  (O4'-C1'-C2'-C3').
	 */
	public java.lang.Float getNu1() 
	{
		return nu1;
	}
 
	public void setNu1(java.lang.Float nu1)
	{
		this.nu1 = nu1;
	}

 	protected java.lang.Float nu2;


	/**
	 *  The value in degrees of the sugar torsion angle nu2
	 *  (C1'-C2'-C3'-C4').
	 */
	public java.lang.Float getNu2() 
	{
		return nu2;
	}
 
	public void setNu2(java.lang.Float nu2)
	{
		this.nu2 = nu2;
	}

 	protected java.lang.Float nu3;


	/**
	 *  The value in degrees of the sugar torsion angle nu3
	 *  (C2'-C3'-C4'-O4').
	 */
	public java.lang.Float getNu3() 
	{
		return nu3;
	}
 
	public void setNu3(java.lang.Float nu3)
	{
		this.nu3 = nu3;
	}

 	protected java.lang.Float nu4;


	/**
	 *  The value in degrees of the sugar torsion angle nu4
	 *  (C3'-C4'-O4'-C1').
	 */
	public java.lang.Float getNu4() 
	{
		return nu4;
	}
 
	public void setNu4(java.lang.Float nu4)
	{
		this.nu4 = nu4;
	}

 	protected java.lang.Float tau0;


	/**
	 *  The value in degrees of the sugar torsion angle tau0
	 *  (C4'-O4'-C1'-C2').
	 */
	public java.lang.Float getTau0() 
	{
		return tau0;
	}
 
	public void setTau0(java.lang.Float tau0)
	{
		this.tau0 = tau0;
	}

 	protected java.lang.Float tau1;


	/**
	 *  The value in degrees of the sugar torsion angle tau1
	 *  (O4'-C1'-C2'-C3').
	 */
	public java.lang.Float getTau1() 
	{
		return tau1;
	}
 
	public void setTau1(java.lang.Float tau1)
	{
		this.tau1 = tau1;
	}

 	protected java.lang.Float tau2;


	/**
	 *  The value in degrees of the sugar torsion angle tau2
	 *  (C1'-C2'-C3'-C4').
	 */
	public java.lang.Float getTau2() 
	{
		return tau2;
	}
 
	public void setTau2(java.lang.Float tau2)
	{
		this.tau2 = tau2;
	}

 	protected java.lang.Float tau3;


	/**
	 *  The value in degrees of the sugar torsion angle tau3
	 *  (C2'-C3'-C4'-O4').
	 */
	public java.lang.Float getTau3() 
	{
		return tau3;
	}
 
	public void setTau3(java.lang.Float tau3)
	{
		this.tau3 = tau3;
	}

 	protected java.lang.Float tau4;


	/**
	 *  The value in degrees of the sugar torsion angle tau4
	 *  (C3'-C4'-O4'-C1').
	 */
	public java.lang.Float getTau4() 
	{
		return tau4;
	}
 
	public void setTau4(java.lang.Float tau4)
	{
		this.tau4 = tau4;
	}

 	protected java.lang.Float taum;


	/**
	 *  The maximum amplitude of puckering. This is derived from the
	 *  pseudorotation value P and the torsion angles in the ribose
	 *  ring.
	 *  
	 *  Tau2= Taum cosP
	 *  Tau3= Taum cos(P+144)
	 *  Tau4= Taum cos(P+288)
	 *  Tau0= Taum cos(P+ 72)
	 *  Tau1= Taum cos(P+216)
	 */
	public java.lang.Float getTaum() 
	{
		return taum;
	}
 
	public void setTaum(java.lang.Float taum)
	{
		this.taum = taum;
	}

 	protected java.lang.Float zeta;


	/**
	 *  The value in degrees of the backbone torsion angle zeta
	 *  (C3'-O3'-P-O5').
	 */
	public java.lang.Float getZeta() 
	{
		return zeta;
	}
 
	public void setZeta(java.lang.Float zeta)
	{
		this.zeta = zeta;
	}

 }
