package org.pdb.beans;

/**
 *  Data items in the STRUCT_NCS_DOM_LIM category identify the
 *  start and end points of polypeptide chain segments
 *  that form all or part of a domain in an ensemble of domains
 *  related by noncrystallographic symmetry.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for the collagen-like
 *  peptide, HYP-.
 *  <PDBx:struct_ncs_dom_limCategory>
 *  <PDBx:struct_ncs_dom_lim dom_id="d1" beg_label_alt_id="" beg_label_asym_id="A" beg_label_comp_id="PRO" beg_label_seq_id="1" end_label_alt_id="" end_label_asym_id="A" end_label_comp_id="GLY" end_label_seq_id="29"></PDBx:struct_ncs_dom_lim>
 *  <PDBx:struct_ncs_dom_lim dom_id="d1" beg_label_alt_id="" beg_label_asym_id="B" beg_label_comp_id="PRO" beg_label_seq_id="31" end_label_alt_id="" end_label_asym_id="B" end_label_comp_id="GLY" end_label_seq_id="59"></PDBx:struct_ncs_dom_lim>
 *  <PDBx:struct_ncs_dom_lim dom_id="d1" beg_label_alt_id="" beg_label_asym_id="C" beg_label_comp_id="PRO" beg_label_seq_id="61" end_label_alt_id="" end_label_asym_id="B" end_label_comp_id="GLY" end_label_seq_id="89"></PDBx:struct_ncs_dom_lim>
 *  <PDBx:struct_ncs_dom_lim dom_id="d2" beg_label_alt_id="" beg_label_asym_id="D" beg_label_comp_id="PRO" beg_label_seq_id="91" end_label_alt_id="" end_label_asym_id="D" end_label_comp_id="GLY" end_label_seq_id="119"></PDBx:struct_ncs_dom_lim>
 *  <PDBx:struct_ncs_dom_lim dom_id="d2" beg_label_alt_id="" beg_label_asym_id="E" beg_label_comp_id="PRO" beg_label_seq_id="121" end_label_alt_id="" end_label_asym_id="E" end_label_comp_id="GLY" end_label_seq_id="149"></PDBx:struct_ncs_dom_lim>
 *  <PDBx:struct_ncs_dom_lim dom_id="d2" beg_label_alt_id="" beg_label_asym_id="F" beg_label_comp_id="PRO" beg_label_seq_id="151" end_label_alt_id="" end_label_asym_id="F" end_label_comp_id="GLY" end_label_seq_id="179"></PDBx:struct_ncs_dom_lim>
 *  </PDBx:struct_ncs_dom_limCategory>
 * </pre>
 */
public class Struct_ncs_dom_lim 
{
		protected java.lang.String beg_auth_asym_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the domain begins.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getBeg_auth_asym_id() 
	{
		return beg_auth_asym_id;
	}
 
	public void setBeg_auth_asym_id(java.lang.String beg_auth_asym_id)
	{
		this.beg_auth_asym_id = beg_auth_asym_id;
	}

 	protected java.lang.String beg_auth_comp_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the domain begins.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getBeg_auth_comp_id() 
	{
		return beg_auth_comp_id;
	}
 
	public void setBeg_auth_comp_id(java.lang.String beg_auth_comp_id)
	{
		this.beg_auth_comp_id = beg_auth_comp_id;
	}

 	protected java.lang.String beg_auth_seq_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the domain begins.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getBeg_auth_seq_id() 
	{
		return beg_auth_seq_id;
	}
 
	public void setBeg_auth_seq_id(java.lang.String beg_auth_seq_id)
	{
		this.beg_auth_seq_id = beg_auth_seq_id;
	}

 	protected java.lang.String beg_label_alt_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the domain begins.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_sites_alt in the
	 *  ATOM_SITES_ALT category.
	 */
	public java.lang.String getBeg_label_alt_id() 
	{
		return beg_label_alt_id;
	}
 
	public void setBeg_label_alt_id(java.lang.String beg_label_alt_id)
	{
		this.beg_label_alt_id = beg_label_alt_id;
	}

 	protected java.lang.String beg_label_asym_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the domain begins.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getBeg_label_asym_id() 
	{
		return beg_label_asym_id;
	}
 
	public void setBeg_label_asym_id(java.lang.String beg_label_asym_id)
	{
		this.beg_label_asym_id = beg_label_asym_id;
	}

 	protected java.lang.String beg_label_comp_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the domain begins.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getBeg_label_comp_id() 
	{
		return beg_label_comp_id;
	}
 
	public void setBeg_label_comp_id(java.lang.String beg_label_comp_id)
	{
		this.beg_label_comp_id = beg_label_comp_id;
	}

 	protected java.lang.Integer beg_label_seq_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the domain begins.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getBeg_label_seq_id() 
	{
		return beg_label_seq_id;
	}
 
	public void setBeg_label_seq_id(java.lang.Integer beg_label_seq_id)
	{
		this.beg_label_seq_id = beg_label_seq_id;
	}

 	protected java.lang.String dom_id;


	/**
	 *  This data item is a pointer to  attribute id in category struct_ncs_dom in the
	 *  STRUCT_NCS_DOM category.
	 */
	public java.lang.String getDom_id() 
	{
		return dom_id;
	}
 
	public void setDom_id(java.lang.String dom_id)
	{
		this.dom_id = dom_id;
	}

 	protected java.lang.String end_auth_asym_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the domain ends.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getEnd_auth_asym_id() 
	{
		return end_auth_asym_id;
	}
 
	public void setEnd_auth_asym_id(java.lang.String end_auth_asym_id)
	{
		this.end_auth_asym_id = end_auth_asym_id;
	}

 	protected java.lang.String end_auth_comp_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the domain ends.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getEnd_auth_comp_id() 
	{
		return end_auth_comp_id;
	}
 
	public void setEnd_auth_comp_id(java.lang.String end_auth_comp_id)
	{
		this.end_auth_comp_id = end_auth_comp_id;
	}

 	protected java.lang.String end_auth_seq_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the domain ends.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getEnd_auth_seq_id() 
	{
		return end_auth_seq_id;
	}
 
	public void setEnd_auth_seq_id(java.lang.String end_auth_seq_id)
	{
		this.end_auth_seq_id = end_auth_seq_id;
	}

 	protected java.lang.String end_label_alt_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the domain ends.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_sites_alt in the
	 *  ATOM_SITES_ALT category.
	 */
	public java.lang.String getEnd_label_alt_id() 
	{
		return end_label_alt_id;
	}
 
	public void setEnd_label_alt_id(java.lang.String end_label_alt_id)
	{
		this.end_label_alt_id = end_label_alt_id;
	}

 	protected java.lang.String end_label_asym_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the domain ends.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getEnd_label_asym_id() 
	{
		return end_label_asym_id;
	}
 
	public void setEnd_label_asym_id(java.lang.String end_label_asym_id)
	{
		this.end_label_asym_id = end_label_asym_id;
	}

 	protected java.lang.String end_label_comp_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the domain ends.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getEnd_label_comp_id() 
	{
		return end_label_comp_id;
	}
 
	public void setEnd_label_comp_id(java.lang.String end_label_comp_id)
	{
		this.end_label_comp_id = end_label_comp_id;
	}

 	protected java.lang.Integer end_label_seq_id;


	/**
	 *  A component of the identifier for the monomer at which this
	 *  segment of the domain ends.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getEnd_label_seq_id() 
	{
		return end_label_seq_id;
	}
 
	public void setEnd_label_seq_id(java.lang.Integer end_label_seq_id)
	{
		this.end_label_seq_id = end_label_seq_id;
	}

 	protected java.lang.Integer pdbx_component_id;


	/**
	 *  record the number of component used for NCS.
	 */
	public java.lang.Integer getPdbx_component_id() 
	{
		return pdbx_component_id;
	}
 
	public void setPdbx_component_id(java.lang.Integer pdbx_component_id)
	{
		this.pdbx_component_id = pdbx_component_id;
	}

 	protected java.lang.Float pdbx_refine_code;


	/**
	 *  record the refinement code number (from CCP4.)
	 */
	public java.lang.Float getPdbx_refine_code() 
	{
		return pdbx_refine_code;
	}
 
	public void setPdbx_refine_code(java.lang.Float pdbx_refine_code)
	{
		this.pdbx_refine_code = pdbx_refine_code;
	}

 }
