package org.pdb.beans;

/**
 *  Data items in the STRUCT_NCS_ENS category record information
 *  about ensembles of domains related by noncrystallographic
 *  symmetry. The point group of the ensemble when taken as a
 *  whole may be specified, as well as any special aspects of the
 *  ensemble that require description.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for the collagen-like
 *  peptide, HYP-.
 *  <PDBx:struct_ncs_ensCategory>
 *  <PDBx:struct_ncs_ens id="en1">
 *  <PDBx:details> The ensemble represents the pseudo-twofold symmetry
 *  between domains d1 and d2.</PDBx:details>
 *  </PDBx:struct_ncs_ens>
 *  </PDBx:struct_ncs_ensCategory>
 * </pre>
 */
public class Struct_ncs_ens 
{
		protected java.lang.String details;


	/**
	 *  A description of special aspects of the ensemble.
	 *  The ensemble has a slight translation between
	 *  domains 1 and 4, but overall it can accurately
	 *  be described as point group 222
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category struct_ncs_ens must uniquely identify a
	 *  record in the STRUCT_NCS_ENS list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String point_group;


	/**
	 *  The point group of the ensemble of structural elements related by
	 *  one or more noncrystallographic symmetry operations. The
	 *  relationships need not be precise; this data item is intended
	 *  to give a rough description of the noncrystallographic symmetry
	 *  relationships.
	 *  3
	 *  422
	 *  non-proper
	 */
	public java.lang.String getPoint_group() 
	{
		return point_group;
	}
 
	public void setPoint_group(java.lang.String point_group)
	{
		this.point_group = point_group;
	}

 }
