package org.pdb.beans;

/**
 *  Data items in the STRUCT_NCS_OPER category describe the
 *  noncrystallographic symmetry operations.
 *  
 *  Each operator is specified as a matrix and a subsequent
 *  translation vector. Operators need not represent proper
 *  rotations.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for the protein NS1.
 *  <PDBx:struct_ncs_operCategory>
 *  <PDBx:struct_ncs_oper id="ncsop1">
 *  <PDBx:code>given</PDBx:code>
 *  <PDBx:matrix11>0.247</PDBx:matrix11>
 *  <PDBx:matrix12>0.935</PDBx:matrix12>
 *  <PDBx:matrix13>0.256</PDBx:matrix13>
 *  <PDBx:matrix21>0.929</PDBx:matrix21>
 *  <PDBx:matrix22>0.153</PDBx:matrix22>
 *  <PDBx:matrix23>0.337</PDBx:matrix23>
 *  <PDBx:matrix31>0.276</PDBx:matrix31>
 *  <PDBx:matrix32>0.321</PDBx:matrix32>
 *  <PDBx:matrix33>-0.906</PDBx:matrix33>
 *  <PDBx:vector1>-8.253</PDBx:vector1>
 *  <PDBx:vector2>-11.743</PDBx:vector2>
 *  <PDBx:vector3>-1.782</PDBx:vector3>
 *  <PDBx:details> Matrix and translation vector for pseudo-twofold operation.</PDBx:details>
 *  </PDBx:struct_ncs_oper>
 *  </PDBx:struct_ncs_operCategory>
 * </pre>
 */
public class Struct_ncs_oper 
{
		protected java.lang.String code;


	/**
	 *  A code to indicate whether this operator describes a
	 *  relationship between coordinates all of which are given in the
	 *  data block (in which case the value of code is 'given'), or
	 *  whether the operator is used to generate new coordinates from
	 *  those that are given in the data block (in which case the value
	 *  of code is 'generate').
	 */
	public java.lang.String getCode() 
	{
		return code;
	}
 
	public void setCode(java.lang.String code)
	{
		this.code = code;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of the noncrystallographic
	 *  symmetry operator.
	 *  The operation is given as a precise threefold
	 *  rotation, despite the fact the best rms
	 *  fit between domain 1 and domain 2 yields a
	 *  rotation of 119.7 degrees and a translation
	 *  of 0.13 angstroms.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category struct_ncs_oper must uniquely identify a
	 *  record in the STRUCT_NCS_OPER list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Float matrix11;


	/**
	 *  The [1][1] element of the 3x3 matrix component of a
	 *  noncrystallographic symmetry operation.
	 */
	public java.lang.Float getMatrix11() 
	{
		return matrix11;
	}
 
	public void setMatrix11(java.lang.Float matrix11)
	{
		this.matrix11 = matrix11;
	}

 	protected java.lang.Float matrix12;


	/**
	 *  The [1][2] element of the 3x3 matrix component of a
	 *  noncrystallographic symmetry operation.
	 */
	public java.lang.Float getMatrix12() 
	{
		return matrix12;
	}
 
	public void setMatrix12(java.lang.Float matrix12)
	{
		this.matrix12 = matrix12;
	}

 	protected java.lang.Float matrix13;


	/**
	 *  The [1][3] element of the 3x3 matrix component of a
	 *  noncrystallographic symmetry operation.
	 */
	public java.lang.Float getMatrix13() 
	{
		return matrix13;
	}
 
	public void setMatrix13(java.lang.Float matrix13)
	{
		this.matrix13 = matrix13;
	}

 	protected java.lang.Float matrix21;


	/**
	 *  The [2][1] element of the 3x3 matrix component of a
	 *  noncrystallographic symmetry operation.
	 */
	public java.lang.Float getMatrix21() 
	{
		return matrix21;
	}
 
	public void setMatrix21(java.lang.Float matrix21)
	{
		this.matrix21 = matrix21;
	}

 	protected java.lang.Float matrix22;


	/**
	 *  The [2][2] element of the 3x3 matrix component of a
	 *  noncrystallographic symmetry operation.
	 */
	public java.lang.Float getMatrix22() 
	{
		return matrix22;
	}
 
	public void setMatrix22(java.lang.Float matrix22)
	{
		this.matrix22 = matrix22;
	}

 	protected java.lang.Float matrix23;


	/**
	 *  The [2][3] element of the 3x3 matrix component of a
	 *  noncrystallographic symmetry operation.
	 */
	public java.lang.Float getMatrix23() 
	{
		return matrix23;
	}
 
	public void setMatrix23(java.lang.Float matrix23)
	{
		this.matrix23 = matrix23;
	}

 	protected java.lang.Float matrix31;


	/**
	 *  The [3][1] element of the 3x3 matrix component of a
	 *  noncrystallographic symmetry operation.
	 */
	public java.lang.Float getMatrix31() 
	{
		return matrix31;
	}
 
	public void setMatrix31(java.lang.Float matrix31)
	{
		this.matrix31 = matrix31;
	}

 	protected java.lang.Float matrix32;


	/**
	 *  The [3][2] element of the 3x3 matrix component of a
	 *  noncrystallographic symmetry operation.
	 */
	public java.lang.Float getMatrix32() 
	{
		return matrix32;
	}
 
	public void setMatrix32(java.lang.Float matrix32)
	{
		this.matrix32 = matrix32;
	}

 	protected java.lang.Float matrix33;


	/**
	 *  The [3][3] element of the 3x3 matrix component of a
	 *  noncrystallographic symmetry operation.
	 */
	public java.lang.Float getMatrix33() 
	{
		return matrix33;
	}
 
	public void setMatrix33(java.lang.Float matrix33)
	{
		this.matrix33 = matrix33;
	}

 	protected java.lang.Float vector1;


	/**
	 *  The [1] element of the three-element vector component of a
	 *  noncrystallographic symmetry operation.
	 */
	public java.lang.Float getVector1() 
	{
		return vector1;
	}
 
	public void setVector1(java.lang.Float vector1)
	{
		this.vector1 = vector1;
	}

 	protected java.lang.Float vector2;


	/**
	 *  The [2] element of the three-element vector component of a
	 *  noncrystallographic symmetry operation.
	 */
	public java.lang.Float getVector2() 
	{
		return vector2;
	}
 
	public void setVector2(java.lang.Float vector2)
	{
		this.vector2 = vector2;
	}

 	protected java.lang.Float vector3;


	/**
	 *  The [3] element of the three-element vector component of a
	 *  noncrystallographic symmetry operation.
	 */
	public java.lang.Float getVector3() 
	{
		return vector3;
	}
 
	public void setVector3(java.lang.Float vector3)
	{
		this.vector3 = vector3;
	}

 }
