package org.pdb.beans;

/**
 *  Data items in the STRUCT_REF_SEQ category provide a mechanism
 *  for indicating and annotating a region (or regions) of alignment
 *  between the sequence of an entity or biological unit described
 *  in the data block and the sequence in the referenced database
 *  entry.
 *  
 * <pre>
 *  Example 1 - based on the sequence alignment of CHER from M. xantus
 *  (36 to 288) and CHER from S. typhimurium (18 to 276).
 *  <PDBx:struct_ref_seqCategory>
 *  <PDBx:struct_ref_seq align_id="alg1">
 *  <PDBx:ref_id>seqdb1</PDBx:ref_id>
 *  <PDBx:seq_align_beg>36</PDBx:seq_align_beg>
 *  <PDBx:seq_align_end>288</PDBx:seq_align_end>
 *  <PDBx:db_align_beg>18</PDBx:db_align_beg>
 *  <PDBx:db_align_end>276</PDBx:db_align_end>
 *  <PDBx:details> The alignment contains 3 gaps larger than 2 residues</PDBx:details>
 *  </PDBx:struct_ref_seq>
 *  </PDBx:struct_ref_seqCategory>
 * </pre>
 */
public class Struct_ref_seq 
{
		protected java.lang.String align_id;


	/**
	 *  The value of  attribute align_id in category struct_ref_seq must uniquely identify a
	 *  record in the STRUCT_REF_SEQ list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getAlign_id() 
	{
		return align_id;
	}
 
	public void setAlign_id(java.lang.String align_id)
	{
		this.align_id = align_id;
	}

 	protected java.lang.Integer db_align_beg;


	/**
	 *  The sequence position in the referenced database entry
	 *  at which the alignment begins.
	 */
	public java.lang.Integer getDb_align_beg() 
	{
		return db_align_beg;
	}
 
	public void setDb_align_beg(java.lang.Integer db_align_beg)
	{
		this.db_align_beg = db_align_beg;
	}

 	protected java.lang.Integer db_align_end;


	/**
	 *  The sequence position in the referenced database entry
	 *  at which the alignment ends.
	 */
	public java.lang.Integer getDb_align_end() 
	{
		return db_align_end;
	}
 
	public void setDb_align_end(java.lang.Integer db_align_end)
	{
		this.db_align_end = db_align_end;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of the sequence alignment.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String pdbx_PDB_id_code;


	/**
	 *  The PDB code of the structure.
	 *  
	 *  
	 *  1BBP
	 */
	public java.lang.String getPdbx_PDB_id_code() 
	{
		return pdbx_PDB_id_code;
	}
 
	public void setPdbx_PDB_id_code(java.lang.String pdbx_PDB_id_code)
	{
		this.pdbx_PDB_id_code = pdbx_PDB_id_code;
	}

 	protected java.lang.String pdbx_auth_seq_align_beg;


	/**
	 *  Initial position in the PDB sequence segment.
	 *  1
	 *  2
	 */
	public java.lang.String getPdbx_auth_seq_align_beg() 
	{
		return pdbx_auth_seq_align_beg;
	}
 
	public void setPdbx_auth_seq_align_beg(java.lang.String pdbx_auth_seq_align_beg)
	{
		this.pdbx_auth_seq_align_beg = pdbx_auth_seq_align_beg;
	}

 	protected java.lang.String pdbx_auth_seq_align_end;


	/**
	 *  Ending position in the PDB sequence segment
	 *  1
	 *  2
	 */
	public java.lang.String getPdbx_auth_seq_align_end() 
	{
		return pdbx_auth_seq_align_end;
	}
 
	public void setPdbx_auth_seq_align_end(java.lang.String pdbx_auth_seq_align_end)
	{
		this.pdbx_auth_seq_align_end = pdbx_auth_seq_align_end;
	}

 	protected java.lang.String pdbx_db_accession;


	/**
	 *  Accession code of the reference database.
	 *  P07617
	 */
	public java.lang.String getPdbx_db_accession() 
	{
		return pdbx_db_accession;
	}
 
	public void setPdbx_db_accession(java.lang.String pdbx_db_accession)
	{
		this.pdbx_db_accession = pdbx_db_accession;
	}

 	protected java.lang.String pdbx_db_align_beg_ins_code;


	/**
	 *  Initial insertion code of the sequence segment of the
	 *  reference database.
	 *  1
	 *  2
	 */
	public java.lang.String getPdbx_db_align_beg_ins_code() 
	{
		return pdbx_db_align_beg_ins_code;
	}
 
	public void setPdbx_db_align_beg_ins_code(java.lang.String pdbx_db_align_beg_ins_code)
	{
		this.pdbx_db_align_beg_ins_code = pdbx_db_align_beg_ins_code;
	}

 	protected java.lang.String pdbx_db_align_end_ins_code;


	/**
	 *  Ending insertion code of the sequence segment of the
	 *  reference database.
	 *  1
	 *  2
	 */
	public java.lang.String getPdbx_db_align_end_ins_code() 
	{
		return pdbx_db_align_end_ins_code;
	}
 
	public void setPdbx_db_align_end_ins_code(java.lang.String pdbx_db_align_end_ins_code)
	{
		this.pdbx_db_align_end_ins_code = pdbx_db_align_end_ins_code;
	}

 	protected java.lang.String pdbx_seq_align_beg_ins_code;


	/**
	 *  Initial insertion code of the PDB sequence segment.
	 *  1
	 *  2
	 */
	public java.lang.String getPdbx_seq_align_beg_ins_code() 
	{
		return pdbx_seq_align_beg_ins_code;
	}
 
	public void setPdbx_seq_align_beg_ins_code(java.lang.String pdbx_seq_align_beg_ins_code)
	{
		this.pdbx_seq_align_beg_ins_code = pdbx_seq_align_beg_ins_code;
	}

 	protected java.lang.String pdbx_seq_align_end_ins_code;


	/**
	 *  Ending insertion code of the sequence segment
	 *  1
	 *  2
	 */
	public java.lang.String getPdbx_seq_align_end_ins_code() 
	{
		return pdbx_seq_align_end_ins_code;
	}
 
	public void setPdbx_seq_align_end_ins_code(java.lang.String pdbx_seq_align_end_ins_code)
	{
		this.pdbx_seq_align_end_ins_code = pdbx_seq_align_end_ins_code;
	}

 	protected java.lang.String pdbx_strand_id;


	/**
	 *  The PDB strand/chain ID .
	 *  A
	 *  B
	 */
	public java.lang.String getPdbx_strand_id() 
	{
		return pdbx_strand_id;
	}
 
	public void setPdbx_strand_id(java.lang.String pdbx_strand_id)
	{
		this.pdbx_strand_id = pdbx_strand_id;
	}

 	protected java.lang.String ref_id;


	/**
	 *  This data item is a pointer to  attribute id in category struct_ref in the
	 *  STRUCT_REF category.
	 */
	public java.lang.String getRef_id() 
	{
		return ref_id;
	}
 
	public void setRef_id(java.lang.String ref_id)
	{
		this.ref_id = ref_id;
	}

 	protected java.lang.Integer seq_align_beg;


	/**
	 *  The sequence position in the entity or biological unit described
	 *  in the data block at which the alignment begins.
	 *  
	 *  This data item is a pointer to  attribute num in category entity_poly_seq in the
	 *  ENTITY_POLY_SEQ category.
	 */
	public java.lang.Integer getSeq_align_beg() 
	{
		return seq_align_beg;
	}
 
	public void setSeq_align_beg(java.lang.Integer seq_align_beg)
	{
		this.seq_align_beg = seq_align_beg;
	}

 	protected java.lang.Integer seq_align_end;


	/**
	 *  The sequence position in the entity or biological unit described
	 *  in the data block at which the alignment ends.
	 *  
	 *  This data item is a pointer to  attribute num in category entity_poly_seq in the
	 *  ENTITY_POLY_SEQ category.
	 */
	public java.lang.Integer getSeq_align_end() 
	{
		return seq_align_end;
	}
 
	public void setSeq_align_end(java.lang.Integer seq_align_end)
	{
		this.seq_align_end = seq_align_end;
	}

 }
