package org.pdb.beans;

/**
 *  Data items in the STRUCT_REF_SEQ_DIF category provide a
 *  mechanism for indicating and annotating point differences
 *  between the sequence of the entity or biological unit described
 *  in the data block and the sequence of the referenced database
 *  entry.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for CAP-DNA complex.
 *  <PDBx:struct_ref_seq_difCategory>
 *  <PDBx:struct_ref_seq_dif pdbx_ordinal="1">
 *  <PDBx:align_id>algn2</PDBx:align_id>
 *  <PDBx:seq_num>181</PDBx:seq_num>
 *  <PDBx:db_mon_id>GLU</PDBx:db_mon_id>
 *  <PDBx:mon_id>PHE</PDBx:mon_id>
 *  <PDBx:details> A point mutation was introduced in the CAP at position 181
 *  substituting PHE for GLU.</PDBx:details>
 *  </PDBx:struct_ref_seq_dif>
 *  </PDBx:struct_ref_seq_difCategory>
 * </pre>
 */
public class Struct_ref_seq_dif 
{
		protected java.lang.String align_id;


	/**
	 *  This data item is a pointer to  attribute align_id in category struct_ref_seq in
	 *  the STRUCT_REF_SEQ  category.
	 */
	public java.lang.String getAlign_id() 
	{
		return align_id;
	}
 
	public void setAlign_id(java.lang.String align_id)
	{
		this.align_id = align_id;
	}

 	protected java.lang.String db_mon_id;


	/**
	 *  The monomer type found at this position in the referenced
	 *  database entry.
	 *  
	 *  This data item is a pointer to  attribute id in category chem_comp in the CHEM_COMP
	 *  category.
	 */
	public java.lang.String getDb_mon_id() 
	{
		return db_mon_id;
	}
 
	public void setDb_mon_id(java.lang.String db_mon_id)
	{
		this.db_mon_id = db_mon_id;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of the point differences
	 *  between the sequence of the entity or biological unit described
	 *  in the data block and that in the referenced database entry.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String mon_id;


	/**
	 *  The monomer type found at this position in the sequence of
	 *  the entity or biological unit described in this data block.
	 *  
	 *  This data item is a pointer to  attribute id in category chem_comp in the CHEM_COMP
	 *  category.
	 */
	public java.lang.String getMon_id() 
	{
		return mon_id;
	}
 
	public void setMon_id(java.lang.String mon_id)
	{
		this.mon_id = mon_id;
	}

 	protected java.lang.String pdbx_auth_seq_num;


	/**
	 *  Insertion code in PDB sequence
	 *  
	 *  1
	 *  2
	 */
	public java.lang.String getPdbx_auth_seq_num() 
	{
		return pdbx_auth_seq_num;
	}
 
	public void setPdbx_auth_seq_num(java.lang.String pdbx_auth_seq_num)
	{
		this.pdbx_auth_seq_num = pdbx_auth_seq_num;
	}

 	protected java.lang.Integer pdbx_ordinal;


	/**
	 *  A synthetic integer primary key for this category.
	 */
	public java.lang.Integer getPdbx_ordinal() 
	{
		return pdbx_ordinal;
	}
 
	public void setPdbx_ordinal(java.lang.Integer pdbx_ordinal)
	{
		this.pdbx_ordinal = pdbx_ordinal;
	}

 	protected java.lang.String pdbx_pdb_id_code;


	/**
	 *  The PDB ID code.
	 *  1BBP
	 */
	public java.lang.String getPdbx_pdb_id_code() 
	{
		return pdbx_pdb_id_code;
	}
 
	public void setPdbx_pdb_id_code(java.lang.String pdbx_pdb_id_code)
	{
		this.pdbx_pdb_id_code = pdbx_pdb_id_code;
	}

 	protected java.lang.String pdbx_pdb_ins_code;


	/**
	 *  Insertion code in PDB sequence
	 *  
	 *  1
	 *  2
	 */
	public java.lang.String getPdbx_pdb_ins_code() 
	{
		return pdbx_pdb_ins_code;
	}
 
	public void setPdbx_pdb_ins_code(java.lang.String pdbx_pdb_ins_code)
	{
		this.pdbx_pdb_ins_code = pdbx_pdb_ins_code;
	}

 	protected java.lang.String pdbx_pdb_strand_id;


	/**
	 *  PDB strand/chain id.
	 *  A
	 *  B
	 */
	public java.lang.String getPdbx_pdb_strand_id() 
	{
		return pdbx_pdb_strand_id;
	}
 
	public void setPdbx_pdb_strand_id(java.lang.String pdbx_pdb_strand_id)
	{
		this.pdbx_pdb_strand_id = pdbx_pdb_strand_id;
	}

 	protected java.lang.String pdbx_seq_db_accession_code;


	/**
	 *  Sequence database accession number.
	 *  P07617
	 */
	public java.lang.String getPdbx_seq_db_accession_code() 
	{
		return pdbx_seq_db_accession_code;
	}
 
	public void setPdbx_seq_db_accession_code(java.lang.String pdbx_seq_db_accession_code)
	{
		this.pdbx_seq_db_accession_code = pdbx_seq_db_accession_code;
	}

 	protected java.lang.String pdbx_seq_db_name;


	/**
	 *  Sequence database name.
	 *  
	 *  SWS
	 */
	public java.lang.String getPdbx_seq_db_name() 
	{
		return pdbx_seq_db_name;
	}
 
	public void setPdbx_seq_db_name(java.lang.String pdbx_seq_db_name)
	{
		this.pdbx_seq_db_name = pdbx_seq_db_name;
	}

 	protected java.lang.String pdbx_seq_db_seq_num;


	/**
	 *  Sequence database sequence number.
	 *  
	 *  142
	 */
	public java.lang.String getPdbx_seq_db_seq_num() 
	{
		return pdbx_seq_db_seq_num;
	}
 
	public void setPdbx_seq_db_seq_num(java.lang.String pdbx_seq_db_seq_num)
	{
		this.pdbx_seq_db_seq_num = pdbx_seq_db_seq_num;
	}

 	protected java.lang.Integer seq_num;


	/**
	 *  This data item is a pointer to  attribute num in category entity_poly_seq in the
	 *  ENTITY_POLY_SEQ category.
	 */
	public java.lang.Integer getSeq_num() 
	{
		return seq_num;
	}
 
	public void setSeq_num(java.lang.Integer seq_num)
	{
		this.seq_num = seq_num;
	}

 }
