package org.pdb.beans;

/**
 *  Data items in the STRUCT_SHEET category record details about
 *  the beta-sheets.
 *  
 * <pre>
 *  Example 1 - simple beta-barrel.
 *  
 *  N  O    N  O    N  O    N  O    N  O    N  O
 *  10--11--12--13--14--15--16--17--18--19--20  strand_a
 *  N  O    N  O    N  O    N  O    N  O
 *  /  \    /  \    /  \    /  \    /  \
 *  N  O    N  O    N  O    N  O    N  O    N  O
 *  30--31--32--33--34--35--36--37--38--39--40  strand_b
 *  N  O    N  O    N  O    N  O    N  O
 *  /  \    /  \    /  \    /  \    /  \
 *  N  O    N  O    N  O    N  O    N  O    N  O
 *  50--51--52--53--54--55--56--57--58--59--60  strand_c
 *  N  O    N  O    N  O    N  O    N  O
 *  /  \    /  \    /  \    /  \    /  \
 *  N  O    N  O    N  O    N  O    N  O    N  O
 *  70--71--72--73--74--75--76--77--78--79--80  strand_d
 *  N  O    N  O    N  O    N  O    N  O
 *  /  \    /  \    /  \    /  \    /  \
 *  N  O    N  O    N  O    N  O    N  O    N  O
 *  90--91--92--93--94--95--96--97--98--99-100  strand_e
 *  N  O    N  O    N  O    N  O    N  O
 *  /  \    /  \    /  \    /  \    /  \
 *  N  O    N  O    N  O    N  O    N  O    N  O
 *  110-111-112-113-114-115-116-117-118-119-120  strand_f
 *  N  O    N  O    N  O    N  O    N  O
 *  /  \    /  \    /  \    /  \    /  \
 *  N  O    N  O    N  O    N  O    N  O    N  O
 *  130-131-132-133-134-135-136-137-138-139-140  strand_g
 *  N  O    N  O    N  O    N  O    N  O
 *  /  \    /  \    /  \    /  \    /  \
 *  N  O    N  O    N  O    N  O    N  O    N  O
 *  150-151-152-153-154-155-156-157-158-159-160  strand_h
 *  N  O    N  O    N  O    N  O    N  O
 *  /  \    /  \    /  \    /  \    /  \
 *  <PDBx:struct_sheetCategory>
 *  <PDBx:struct_sheet id="sheet_1">
 *  <PDBx:type>beta-barrel</PDBx:type>
 *  <PDBx:number_strands>8</PDBx:number_strands>
 *  </PDBx:struct_sheet>
 *  </PDBx:struct_sheetCategory>
 *  
 *  
 *  Example 2 - five stranded mixed-sense sheet with one two-piece strand.
 *  
 *  N  O    N  O    N  O    N  O
 *  -10--11--12--13--14--15--16--17--18->  strand_a
 *  N  O    N  O    N  O    N  O    N  O
 *  |  |    |  |    |  |    |  |    |  |
 *  O  N    O  N    O  N    O  N    O  N
 *  <-119-118-117-116-115-114-113-112-111-110-  strand_b
 *  O  N    O  N    O  N    O  N    O  N
 *  \  /   \   /   \   /   \   /   \
 *  O  N    O  N    O  N    O  N    O  N    O  N
 *  <-41--40--39--38--37--36--35--34--33--32--31--30-  strand_c
 *  O  N    O  N    O  N    O  N    O  N    O  N
 *  |  |    |  |    |  |    |  |    |  |    |  |
 *  N  O    N  O    N  O    N  O    N  O    N  O
 *  strand_d1  -50--51--52->   -90--91--92--93--95--95--96--97->  strand_d2
 *  N  O            N  O    N  O    N  O    N  O
 *  |  |    |  |    |  |    |  |    |  |    |  |
 *  O  N    O  N    O  N    O  N    O  N    O  N
 *  <-80--79--78--77--76--75--74--73--72--71--70-   strand_e
 *  O  N    O  N    O  N    O  N    O  N
 *  <PDBx:struct_sheetCategory>
 *  <PDBx:struct_sheet id="sheet_2">
 *  <PDBx:type>five stranded, mixed-sense</PDBx:type>
 *  <PDBx:number_strands>5</PDBx:number_strands>
 *  <PDBx:details>strand_d is in two pieces</PDBx:details>
 *  </PDBx:struct_sheet>
 *  </PDBx:struct_sheetCategory>
 * </pre>
 */
public class Struct_sheet 
{
		protected java.lang.String details;


	/**
	 *  A description of special aspects of the beta-sheet.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category struct_sheet must uniquely identify a record in
	 *  the STRUCT_SHEET list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Integer number_strands;


	/**
	 *  The number of strands in the sheet. If a given range of residues
	 *  bulges out from the strands, it is still counted as one strand.
	 *  If a strand is composed of two different regions of polypeptide,
	 *  it is still counted as one strand, as long as the proper hydrogen-
	 *  bonding connections are made to adjacent strands.
	 */
	public java.lang.Integer getNumber_strands() 
	{
		return number_strands;
	}
 
	public void setNumber_strands(java.lang.Integer number_strands)
	{
		this.number_strands = number_strands;
	}

 	protected java.lang.String type;


	/**
	 *  A simple descriptor for the type of the sheet.
	 *  jelly-roll
	 *  Rossmann fold
	 *  beta barrel
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 }
