package org.pdb.beans;

/**
 *  Data items in the STRUCT_SHEET_ORDER category record details
 *  about the order of the residue ranges that form a beta-sheet.
 *  All order links are pairwise and the specified pairs are
 *  assumed to be adjacent to one another in the sheet. These data
 *  items are an alternative to the STRUCT_SHEET_TOPOLOGY data
 *  items and they allow all manner of sheets to be described.
 *  
 * <pre>
 *  Example 1 - simple beta-barrel.
 *  <PDBx:struct_sheet_orderCategory>
 *  <PDBx:struct_sheet_order sheet_id="sheet_1" range_id_1="strand_a" range_id_2="strand_b">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_1" range_id_1="strand_b" range_id_2="strand_c">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_1" range_id_1="strand_c" range_id_2="strand_d">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_1" range_id_1="strand_d" range_id_2="strand_e">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_1" range_id_1="strand_e" range_id_2="strand_f">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_1" range_id_1="strand_f" range_id_2="strand_g">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_1" range_id_1="strand_g" range_id_2="strand_h">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_1" range_id_1="strand_h" range_id_2="strand_a">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  </PDBx:struct_sheet_orderCategory>
 *  
 *  
 *  Example 2 - five stranded mixed-sense sheet with one two-piece strand.
 *  <PDBx:struct_sheet_orderCategory>
 *  <PDBx:struct_sheet_order sheet_id="sheet_2" range_id_1="strand_a" range_id_2="strand_b">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>anti-parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_2" range_id_1="strand_b" range_id_2="strand_c">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_2" range_id_1="strand_c" range_id_2="strand_d1">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>anti-parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_2" range_id_1="strand_c" range_id_2="strand_d2">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>anti-parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_2" range_id_1="strand_d1" range_id_2="strand_e">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>anti-parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_2" range_id_1="strand_d2" range_id_2="strand_e">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>anti-parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  </PDBx:struct_sheet_orderCategory>
 * </pre>
 */
public class Struct_sheet_order 
{
		protected java.lang.Integer offset;


	/**
	 *  Designates the relative position in the sheet, plus or minus, of
	 *  the second residue range to the first.
	 */
	public java.lang.Integer getOffset() 
	{
		return offset;
	}
 
	public void setOffset(java.lang.Integer offset)
	{
		this.offset = offset;
	}

 	protected java.lang.String range_id_1;


	/**
	 *  This data item is a pointer to  attribute id in category struct_sheet_range in
	 *  the STRUCT_SHEET_RANGE category.
	 */
	public java.lang.String getRange_id_1() 
	{
		return range_id_1;
	}
 
	public void setRange_id_1(java.lang.String range_id_1)
	{
		this.range_id_1 = range_id_1;
	}

 	protected java.lang.String range_id_2;


	/**
	 *  This data item is a pointer to  attribute id in category struct_sheet_range in
	 *  the STRUCT_SHEET_RANGE category.
	 */
	public java.lang.String getRange_id_2() 
	{
		return range_id_2;
	}
 
	public void setRange_id_2(java.lang.String range_id_2)
	{
		this.range_id_2 = range_id_2;
	}

 	protected java.lang.String sense;


	/**
	 *  A flag to indicate whether the two designated residue ranges are
	 *  parallel or antiparallel to one another.
	 */
	public java.lang.String getSense() 
	{
		return sense;
	}
 
	public void setSense(java.lang.String sense)
	{
		this.sense = sense;
	}

 	protected java.lang.String sheet_id;


	/**
	 *  This data item is a pointer to  attribute id in category struct_sheet in the
	 *  STRUCT_SHEET category.
	 */
	public java.lang.String getSheet_id() 
	{
		return sheet_id;
	}
 
	public void setSheet_id(java.lang.String sheet_id)
	{
		this.sheet_id = sheet_id;
	}

 }
