package org.pdb.beans;

/**
 *  Data items in the STRUCT_SITE category record details about
 *  portions of the structure that contribute to structurally
 *  relevant sites (e.g. active sites, substrate-binding subsites,
 *  metal-coordination sites).
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_siteCategory>
 *  <PDBx:struct_site id="P2 site C">
 *  <PDBx:details> residues with a contact &lt; 3.7 \&#37;A to an atom in the P2
 *  moiety of the inhibitor in the conformation with
 *  _struct_asym.id = C</PDBx:details>
 *  </PDBx:struct_site>
 *  <PDBx:struct_site id="P2 site D">
 *  <PDBx:details> residues with a contact &lt; 3.7 \&#37;A to an atom in the P1
 *  moiety of the inhibitor in the conformation with
 *  _struct_asym.id = D)</PDBx:details>
 *  </PDBx:struct_site>
 *  </PDBx:struct_siteCategory>
 * </pre>
 */
public class Struct_site 
{
		protected java.lang.String details;


	/**
	 *  A description of special aspects of the site.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category struct_site must uniquely identify a record in
	 *  the STRUCT_SITE list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Integer pdbx_num_residues;


	/**
	 *  Number of residues in the site.
	 */
	public java.lang.Integer getPdbx_num_residues() 
	{
		return pdbx_num_residues;
	}
 
	public void setPdbx_num_residues(java.lang.Integer pdbx_num_residues)
	{
		this.pdbx_num_residues = pdbx_num_residues;
	}

 }
