package org.pdb.beans;

/**
 *  Data items in the STRUCT_SITE_GEN category record details about
 *  the generation of portions of the structure that contribute to
 *  structurally relevant sites.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_site_genCategory>
 *  <PDBx:struct_site_gen id="1" site_id="1">
 *  <PDBx:label_comp_id>VAL</PDBx:label_comp_id>
 *  <PDBx:label_asym_id>A</PDBx:label_asym_id>
 *  <PDBx:label_seq_id>32</PDBx:label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_site_gen>
 *  <PDBx:struct_site_gen id="2" site_id="1">
 *  <PDBx:label_comp_id>ILE</PDBx:label_comp_id>
 *  <PDBx:label_asym_id>A</PDBx:label_asym_id>
 *  <PDBx:label_seq_id>47</PDBx:label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_site_gen>
 *  <PDBx:struct_site_gen id="3" site_id="1">
 *  <PDBx:label_comp_id>VAL</PDBx:label_comp_id>
 *  <PDBx:label_asym_id>A</PDBx:label_asym_id>
 *  <PDBx:label_seq_id>82</PDBx:label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_site_gen>
 *  <PDBx:struct_site_gen id="4" site_id="1">
 *  <PDBx:label_comp_id>ILE</PDBx:label_comp_id>
 *  <PDBx:label_asym_id>A</PDBx:label_asym_id>
 *  <PDBx:label_seq_id>84</PDBx:label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_site_gen>
 *  <PDBx:struct_site_gen id="5" site_id="2">
 *  <PDBx:label_comp_id>VAL</PDBx:label_comp_id>
 *  <PDBx:label_asym_id>B</PDBx:label_asym_id>
 *  <PDBx:label_seq_id>232</PDBx:label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_site_gen>
 *  <PDBx:struct_site_gen id="6" site_id="2">
 *  <PDBx:label_comp_id>ILE</PDBx:label_comp_id>
 *  <PDBx:label_asym_id>B</PDBx:label_asym_id>
 *  <PDBx:label_seq_id>247</PDBx:label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_site_gen>
 *  <PDBx:struct_site_gen id="7" site_id="2">
 *  <PDBx:label_comp_id>VAL</PDBx:label_comp_id>
 *  <PDBx:label_asym_id>B</PDBx:label_asym_id>
 *  <PDBx:label_seq_id>282</PDBx:label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_site_gen>
 *  <PDBx:struct_site_gen id="8" site_id="2">
 *  <PDBx:label_comp_id>ILE</PDBx:label_comp_id>
 *  <PDBx:label_asym_id>B</PDBx:label_asym_id>
 *  <PDBx:label_seq_id>284</PDBx:label_seq_id>
 *  <PDBx:symmetry>1_555</PDBx:symmetry>
 *  </PDBx:struct_site_gen>
 *  </PDBx:struct_site_genCategory>
 * </pre>
 */
public class Struct_site_gen 
{
		protected java.lang.String auth_asym_id;


	/**
	 *  A component of the identifier for participants in the site.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAuth_asym_id() 
	{
		return auth_asym_id;
	}
 
	public void setAuth_asym_id(java.lang.String auth_asym_id)
	{
		this.auth_asym_id = auth_asym_id;
	}

 	protected java.lang.String auth_atom_id;


	/**
	 *  A component of the identifier for participants in the site.
	 *  
	 *  This data item is a pointer to  attribute auth_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAuth_atom_id() 
	{
		return auth_atom_id;
	}
 
	public void setAuth_atom_id(java.lang.String auth_atom_id)
	{
		this.auth_atom_id = auth_atom_id;
	}

 	protected java.lang.String auth_comp_id;


	/**
	 *  A component of the identifier for participants in the site.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAuth_comp_id() 
	{
		return auth_comp_id;
	}
 
	public void setAuth_comp_id(java.lang.String auth_comp_id)
	{
		this.auth_comp_id = auth_comp_id;
	}

 	protected java.lang.String auth_seq_id;


	/**
	 *  A component of the identifier for participants in the site.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAuth_seq_id() 
	{
		return auth_seq_id;
	}
 
	public void setAuth_seq_id(java.lang.String auth_seq_id)
	{
		this.auth_seq_id = auth_seq_id;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of the symmetry generation of
	 *  this portion of the structural site.
	 *  The zinc atom lies on a special position;
	 *  application of symmetry elements to generate
	 *  the insulin hexamer will generate excess zinc
	 *  atoms, which must be removed by hand.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category struct_site_gen must uniquely identify a record
	 *  in the STRUCT_SITE_GEN list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String label_alt_id;


	/**
	 *  A component of the identifier for participants in the site.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_sites_alt in the
	 *  ATOM_SITES_ALT category.
	 */
	public java.lang.String getLabel_alt_id() 
	{
		return label_alt_id;
	}
 
	public void setLabel_alt_id(java.lang.String label_alt_id)
	{
		this.label_alt_id = label_alt_id;
	}

 	protected java.lang.String label_asym_id;


	/**
	 *  A component of the identifier for participants in the site.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getLabel_asym_id() 
	{
		return label_asym_id;
	}
 
	public void setLabel_asym_id(java.lang.String label_asym_id)
	{
		this.label_asym_id = label_asym_id;
	}

 	protected java.lang.String label_atom_id;


	/**
	 *  A component of the identifier for participants in the site.
	 *  
	 *  This data item is a pointer to  attribute atom_id in category chem_comp_atom in the
	 *  CHEM_COMP_ATOM category.
	 */
	public java.lang.String getLabel_atom_id() 
	{
		return label_atom_id;
	}
 
	public void setLabel_atom_id(java.lang.String label_atom_id)
	{
		this.label_atom_id = label_atom_id;
	}

 	protected java.lang.String label_comp_id;


	/**
	 *  A component of the identifier for participants in the site.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getLabel_comp_id() 
	{
		return label_comp_id;
	}
 
	public void setLabel_comp_id(java.lang.String label_comp_id)
	{
		this.label_comp_id = label_comp_id;
	}

 	protected java.lang.Integer label_seq_id;


	/**
	 *  A component of the identifier for participants in the site.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getLabel_seq_id() 
	{
		return label_seq_id;
	}
 
	public void setLabel_seq_id(java.lang.Integer label_seq_id)
	{
		this.label_seq_id = label_seq_id;
	}

 	protected java.lang.String pdbx_auth_ins_code;


	/**
	 *  PDB insertion code.
	 */
	public java.lang.String getPdbx_auth_ins_code() 
	{
		return pdbx_auth_ins_code;
	}
 
	public void setPdbx_auth_ins_code(java.lang.String pdbx_auth_ins_code)
	{
		this.pdbx_auth_ins_code = pdbx_auth_ins_code;
	}

 	protected java.lang.Integer pdbx_num_res;


	/**
	 *  Number of residues in the site.
	 */
	public java.lang.Integer getPdbx_num_res() 
	{
		return pdbx_num_res;
	}
 
	public void setPdbx_num_res(java.lang.Integer pdbx_num_res)
	{
		this.pdbx_num_res = pdbx_num_res;
	}

 	protected java.lang.String site_id;


	/**
	 *  This data item is a pointer to  attribute id in category struct_site in the STRUCT_SITE
	 *  category.
	 */
	public java.lang.String getSite_id() 
	{
		return site_id;
	}
 
	public void setSite_id(java.lang.String site_id)
	{
		this.site_id = site_id;
	}

 	protected java.lang.String symmetry;


	/**
	 *  Describes the symmetry operation that should be applied to the
	 *  atom set specified by  attribute label* in category struct_site_gen to generate a
	 *  portion of the site.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getSymmetry() 
	{
		return symmetry;
	}
 
	public void setSymmetry(java.lang.String symmetry)
	{
		this.symmetry = symmetry;
	}

 }
