package org.pdb.beans;

/**
 *  Data items in the STRUCT_SITE_KEYWORDS category record
 *  keywords describing the site.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_site_keywordsCategory>
 *  <PDBx:struct_site_keywords site_id="P2 site C" text="binding site"></PDBx:struct_site_keywords>
 *  <PDBx:struct_site_keywords site_id="P2 site C" text="binding pocket"></PDBx:struct_site_keywords>
 *  <PDBx:struct_site_keywords site_id="P2 site C" text="P2 site"></PDBx:struct_site_keywords>
 *  <PDBx:struct_site_keywords site_id="P2 site C" text="P2 pocket"></PDBx:struct_site_keywords>
 *  <PDBx:struct_site_keywords site_id="P2 site D" text="binding site"></PDBx:struct_site_keywords>
 *  <PDBx:struct_site_keywords site_id="P2 site D" text="binding pocket"></PDBx:struct_site_keywords>
 *  <PDBx:struct_site_keywords site_id="P2 site D" text="P2 site"></PDBx:struct_site_keywords>
 *  <PDBx:struct_site_keywords site_id="P2 site D" text="P2 pocket"></PDBx:struct_site_keywords>
 *  </PDBx:struct_site_keywordsCategory>
 * </pre>
 */
public class Struct_site_keywords 
{
		protected java.lang.String site_id;


	/**
	 *  This data item is a pointer to  attribute id in category struct_site in the STRUCT_SITE
	 *  category.
	 */
	public java.lang.String getSite_id() 
	{
		return site_id;
	}
 
	public void setSite_id(java.lang.String site_id)
	{
		this.site_id = site_id;
	}

 	protected java.lang.String text;


	/**
	 *  Keywords describing this site.
	 *  active site
	 *  binding pocket
	 *  Ca coordination
	 */
	public java.lang.String getText() 
	{
		return text;
	}
 
	public void setText(java.lang.String text)
	{
		this.text = text;
	}

 }
