package org.pdb.beans;

/**
 *  Data items in the SYMMETRY_EQUIV category list the
 *  symmetry-equivalent positions for the space group.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:symmetry_equivCategory>
 *  <PDBx:symmetry_equiv id="1">
 *  <PDBx:pos_as_xyz>+x,+y,+z</PDBx:pos_as_xyz>
 *  </PDBx:symmetry_equiv>
 *  <PDBx:symmetry_equiv id="2">
 *  <PDBx:pos_as_xyz>-x,-y,z</PDBx:pos_as_xyz>
 *  </PDBx:symmetry_equiv>
 *  <PDBx:symmetry_equiv id="3">
 *  <PDBx:pos_as_xyz>1/2+x,1/2-y,-z</PDBx:pos_as_xyz>
 *  </PDBx:symmetry_equiv>
 *  <PDBx:symmetry_equiv id="4">
 *  <PDBx:pos_as_xyz>1/2-x,1/2+y,-z</PDBx:pos_as_xyz>
 *  </PDBx:symmetry_equiv>
 *  </PDBx:symmetry_equivCategory>
 * </pre>
 */
public class Symmetry_equiv 
{
		protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category symmetry_equiv must uniquely identify
	 *  a record in the SYMMETRY_EQUIV category.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String pos_as_xyz;


	/**
	 *  Symmetry-equivalent position in the 'xyz' representation. Except
	 *  for the space group P1, these data will be repeated in a loop.
	 *  The format of the data item is as per International Tables for
	 *  Crystallography Vol. A (2002). All equivalent positions should
	 *  be entered, including those for lattice centring and a centre of
	 *  symmetry, if present.
	 *  -y+x,-y,1/3+z
	 */
	public java.lang.String getPos_as_xyz() 
	{
		return pos_as_xyz;
	}
 
	public void setPos_as_xyz(java.lang.String pos_as_xyz)
	{
		this.pos_as_xyz = pos_as_xyz;
	}

 }
