package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the ATOM_SITES category record details about
 *  the crystallographic cell and cell transformations, which are
 *  common to all atom sites.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:atom_sitesCategory>
 *  <PDBx:atom_sites entry_id="5HVP">
 *  <PDBx:Cartn_transform_axes>c along z, astar along x, b along y</PDBx:Cartn_transform_axes>
 *  <PDBx:Cartn_transf_matrix11>58.39</PDBx:Cartn_transf_matrix11>
 *  <PDBx:Cartn_transf_matrix12>0.00</PDBx:Cartn_transf_matrix12>
 *  <PDBx:Cartn_transf_matrix13>0.00</PDBx:Cartn_transf_matrix13>
 *  <PDBx:Cartn_transf_matrix21>0.00</PDBx:Cartn_transf_matrix21>
 *  <PDBx:Cartn_transf_matrix22>86.70</PDBx:Cartn_transf_matrix22>
 *  <PDBx:Cartn_transf_matrix23>0.00</PDBx:Cartn_transf_matrix23>
 *  <PDBx:Cartn_transf_matrix31>0.00</PDBx:Cartn_transf_matrix31>
 *  <PDBx:Cartn_transf_matrix32>0.00</PDBx:Cartn_transf_matrix32>
 *  <PDBx:Cartn_transf_matrix33>46.27</PDBx:Cartn_transf_matrix33>
 *  <PDBx:Cartn_transf_vector1>0.00</PDBx:Cartn_transf_vector1>
 *  <PDBx:Cartn_transf_vector2>0.00</PDBx:Cartn_transf_vector2>
 *  <PDBx:Cartn_transf_vector3>0.00</PDBx:Cartn_transf_vector3>
 *  </PDBx:atom_sites>
 *  </PDBx:atom_sitesCategory>
 * </pre>
 */
public class Atom_sites extends org.pdb.beans.Atom_sites implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "atom_sites";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Atom_sites()
	{
	}

	/** Full constructor */
	public Atom_sites(
		Datablock datablock,
		java.lang.Float Cartn_transf_matrix11,
		java.lang.Float Cartn_transf_matrix12,
		java.lang.Float Cartn_transf_matrix13,
		java.lang.Float Cartn_transf_matrix21,
		java.lang.Float Cartn_transf_matrix22,
		java.lang.Float Cartn_transf_matrix23,
		java.lang.Float Cartn_transf_matrix31,
		java.lang.Float Cartn_transf_matrix32,
		java.lang.Float Cartn_transf_matrix33,
		java.lang.Float Cartn_transf_vector1,
		java.lang.Float Cartn_transf_vector2,
		java.lang.Float Cartn_transf_vector3,
		java.lang.String Cartn_transform_axes,
		java.lang.String entry_id,
		java.lang.Float fract_transf_matrix11,
		java.lang.Float fract_transf_matrix12,
		java.lang.Float fract_transf_matrix13,
		java.lang.Float fract_transf_matrix21,
		java.lang.Float fract_transf_matrix22,
		java.lang.Float fract_transf_matrix23,
		java.lang.Float fract_transf_matrix31,
		java.lang.Float fract_transf_matrix32,
		java.lang.Float fract_transf_matrix33,
		java.lang.Float fract_transf_vector1,
		java.lang.Float fract_transf_vector2,
		java.lang.Float fract_transf_vector3,
		java.lang.String solution_hydrogens,
		java.lang.String solution_primary,
		java.lang.String solution_secondary,
		java.lang.String special_details)
	{
		this.datablock = datablock;
		this.Cartn_transf_matrix11 = Cartn_transf_matrix11;
		this.Cartn_transf_matrix12 = Cartn_transf_matrix12;
		this.Cartn_transf_matrix13 = Cartn_transf_matrix13;
		this.Cartn_transf_matrix21 = Cartn_transf_matrix21;
		this.Cartn_transf_matrix22 = Cartn_transf_matrix22;
		this.Cartn_transf_matrix23 = Cartn_transf_matrix23;
		this.Cartn_transf_matrix31 = Cartn_transf_matrix31;
		this.Cartn_transf_matrix32 = Cartn_transf_matrix32;
		this.Cartn_transf_matrix33 = Cartn_transf_matrix33;
		this.Cartn_transf_vector1 = Cartn_transf_vector1;
		this.Cartn_transf_vector2 = Cartn_transf_vector2;
		this.Cartn_transf_vector3 = Cartn_transf_vector3;
		this.Cartn_transform_axes = Cartn_transform_axes;
		this.entry_id = entry_id;
		this.fract_transf_matrix11 = fract_transf_matrix11;
		this.fract_transf_matrix12 = fract_transf_matrix12;
		this.fract_transf_matrix13 = fract_transf_matrix13;
		this.fract_transf_matrix21 = fract_transf_matrix21;
		this.fract_transf_matrix22 = fract_transf_matrix22;
		this.fract_transf_matrix23 = fract_transf_matrix23;
		this.fract_transf_matrix31 = fract_transf_matrix31;
		this.fract_transf_matrix32 = fract_transf_matrix32;
		this.fract_transf_matrix33 = fract_transf_matrix33;
		this.fract_transf_vector1 = fract_transf_vector1;
		this.fract_transf_vector2 = fract_transf_vector2;
		this.fract_transf_vector3 = fract_transf_vector3;
		this.solution_hydrogens = solution_hydrogens;
		this.solution_primary = solution_primary;
		this.solution_secondary = solution_secondary;
		this.special_details = special_details;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Atom_sites");
		sb.append("\n");
		if (Cartn_transf_matrix11 != null)
		{
			sb.append("Cartn_transf_matrix11 = ");
			sb.append(Cartn_transf_matrix11);
			sb.append('\n');
		}
		if (Cartn_transf_matrix12 != null)
		{
			sb.append("Cartn_transf_matrix12 = ");
			sb.append(Cartn_transf_matrix12);
			sb.append('\n');
		}
		if (Cartn_transf_matrix13 != null)
		{
			sb.append("Cartn_transf_matrix13 = ");
			sb.append(Cartn_transf_matrix13);
			sb.append('\n');
		}
		if (Cartn_transf_matrix21 != null)
		{
			sb.append("Cartn_transf_matrix21 = ");
			sb.append(Cartn_transf_matrix21);
			sb.append('\n');
		}
		if (Cartn_transf_matrix22 != null)
		{
			sb.append("Cartn_transf_matrix22 = ");
			sb.append(Cartn_transf_matrix22);
			sb.append('\n');
		}
		if (Cartn_transf_matrix23 != null)
		{
			sb.append("Cartn_transf_matrix23 = ");
			sb.append(Cartn_transf_matrix23);
			sb.append('\n');
		}
		if (Cartn_transf_matrix31 != null)
		{
			sb.append("Cartn_transf_matrix31 = ");
			sb.append(Cartn_transf_matrix31);
			sb.append('\n');
		}
		if (Cartn_transf_matrix32 != null)
		{
			sb.append("Cartn_transf_matrix32 = ");
			sb.append(Cartn_transf_matrix32);
			sb.append('\n');
		}
		if (Cartn_transf_matrix33 != null)
		{
			sb.append("Cartn_transf_matrix33 = ");
			sb.append(Cartn_transf_matrix33);
			sb.append('\n');
		}
		if (Cartn_transf_vector1 != null)
		{
			sb.append("Cartn_transf_vector1 = ");
			sb.append(Cartn_transf_vector1);
			sb.append('\n');
		}
		if (Cartn_transf_vector2 != null)
		{
			sb.append("Cartn_transf_vector2 = ");
			sb.append(Cartn_transf_vector2);
			sb.append('\n');
		}
		if (Cartn_transf_vector3 != null)
		{
			sb.append("Cartn_transf_vector3 = ");
			sb.append(Cartn_transf_vector3);
			sb.append('\n');
		}
		if (Cartn_transform_axes != null)
		{
			sb.append("Cartn_transform_axes = ");
			sb.append(Cartn_transform_axes);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (fract_transf_matrix11 != null)
		{
			sb.append("fract_transf_matrix11 = ");
			sb.append(fract_transf_matrix11);
			sb.append('\n');
		}
		if (fract_transf_matrix12 != null)
		{
			sb.append("fract_transf_matrix12 = ");
			sb.append(fract_transf_matrix12);
			sb.append('\n');
		}
		if (fract_transf_matrix13 != null)
		{
			sb.append("fract_transf_matrix13 = ");
			sb.append(fract_transf_matrix13);
			sb.append('\n');
		}
		if (fract_transf_matrix21 != null)
		{
			sb.append("fract_transf_matrix21 = ");
			sb.append(fract_transf_matrix21);
			sb.append('\n');
		}
		if (fract_transf_matrix22 != null)
		{
			sb.append("fract_transf_matrix22 = ");
			sb.append(fract_transf_matrix22);
			sb.append('\n');
		}
		if (fract_transf_matrix23 != null)
		{
			sb.append("fract_transf_matrix23 = ");
			sb.append(fract_transf_matrix23);
			sb.append('\n');
		}
		if (fract_transf_matrix31 != null)
		{
			sb.append("fract_transf_matrix31 = ");
			sb.append(fract_transf_matrix31);
			sb.append('\n');
		}
		if (fract_transf_matrix32 != null)
		{
			sb.append("fract_transf_matrix32 = ");
			sb.append(fract_transf_matrix32);
			sb.append('\n');
		}
		if (fract_transf_matrix33 != null)
		{
			sb.append("fract_transf_matrix33 = ");
			sb.append(fract_transf_matrix33);
			sb.append('\n');
		}
		if (fract_transf_vector1 != null)
		{
			sb.append("fract_transf_vector1 = ");
			sb.append(fract_transf_vector1);
			sb.append('\n');
		}
		if (fract_transf_vector2 != null)
		{
			sb.append("fract_transf_vector2 = ");
			sb.append(fract_transf_vector2);
			sb.append('\n');
		}
		if (fract_transf_vector3 != null)
		{
			sb.append("fract_transf_vector3 = ");
			sb.append(fract_transf_vector3);
			sb.append('\n');
		}
		if (solution_hydrogens != null)
		{
			sb.append("solution_hydrogens = ");
			sb.append(solution_hydrogens);
			sb.append('\n');
		}
		if (solution_primary != null)
		{
			sb.append("solution_primary = ");
			sb.append(solution_primary);
			sb.append('\n');
		}
		if (solution_secondary != null)
		{
			sb.append("solution_secondary = ");
			sb.append(solution_secondary);
			sb.append('\n');
		}
		if (special_details != null)
		{
			sb.append("special_details = ");
			sb.append(special_details);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		Cartn_transf_matrix11 = null;
		Cartn_transf_matrix12 = null;
		Cartn_transf_matrix13 = null;
		Cartn_transf_matrix21 = null;
		Cartn_transf_matrix22 = null;
		Cartn_transf_matrix23 = null;
		Cartn_transf_matrix31 = null;
		Cartn_transf_matrix32 = null;
		Cartn_transf_matrix33 = null;
		Cartn_transf_vector1 = null;
		Cartn_transf_vector2 = null;
		Cartn_transf_vector3 = null;
		Cartn_transform_axes = null;
		entry_id = null;
		fract_transf_matrix11 = null;
		fract_transf_matrix12 = null;
		fract_transf_matrix13 = null;
		fract_transf_matrix21 = null;
		fract_transf_matrix22 = null;
		fract_transf_matrix23 = null;
		fract_transf_matrix31 = null;
		fract_transf_matrix32 = null;
		fract_transf_matrix33 = null;
		fract_transf_vector1 = null;
		fract_transf_vector2 = null;
		fract_transf_vector3 = null;
		solution_hydrogens = null;
		solution_primary = null;
		solution_secondary = null;
		special_details = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Atom_sites)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:atom_sites>\n");
			if (Cartn_transf_matrix11 != null) ow.write(indent + " <PDBx:Cartn_transf_matrix11>" + Cartn_transf_matrix11 + "</PDBx:Cartn_transf_matrix11>\n");
			if (Cartn_transf_matrix12 != null) ow.write(indent + " <PDBx:Cartn_transf_matrix12>" + Cartn_transf_matrix12 + "</PDBx:Cartn_transf_matrix12>\n");
			if (Cartn_transf_matrix13 != null) ow.write(indent + " <PDBx:Cartn_transf_matrix13>" + Cartn_transf_matrix13 + "</PDBx:Cartn_transf_matrix13>\n");
			if (Cartn_transf_matrix21 != null) ow.write(indent + " <PDBx:Cartn_transf_matrix21>" + Cartn_transf_matrix21 + "</PDBx:Cartn_transf_matrix21>\n");
			if (Cartn_transf_matrix22 != null) ow.write(indent + " <PDBx:Cartn_transf_matrix22>" + Cartn_transf_matrix22 + "</PDBx:Cartn_transf_matrix22>\n");
			if (Cartn_transf_matrix23 != null) ow.write(indent + " <PDBx:Cartn_transf_matrix23>" + Cartn_transf_matrix23 + "</PDBx:Cartn_transf_matrix23>\n");
			if (Cartn_transf_matrix31 != null) ow.write(indent + " <PDBx:Cartn_transf_matrix31>" + Cartn_transf_matrix31 + "</PDBx:Cartn_transf_matrix31>\n");
			if (Cartn_transf_matrix32 != null) ow.write(indent + " <PDBx:Cartn_transf_matrix32>" + Cartn_transf_matrix32 + "</PDBx:Cartn_transf_matrix32>\n");
			if (Cartn_transf_matrix33 != null) ow.write(indent + " <PDBx:Cartn_transf_matrix33>" + Cartn_transf_matrix33 + "</PDBx:Cartn_transf_matrix33>\n");
			if (Cartn_transf_vector1 != null) ow.write(indent + " <PDBx:Cartn_transf_vector1>" + Cartn_transf_vector1 + "</PDBx:Cartn_transf_vector1>\n");
			if (Cartn_transf_vector2 != null) ow.write(indent + " <PDBx:Cartn_transf_vector2>" + Cartn_transf_vector2 + "</PDBx:Cartn_transf_vector2>\n");
			if (Cartn_transf_vector3 != null) ow.write(indent + " <PDBx:Cartn_transf_vector3>" + Cartn_transf_vector3 + "</PDBx:Cartn_transf_vector3>\n");
			if (Cartn_transform_axes != null) ow.write(indent + " <PDBx:Cartn_transform_axes>" + Cartn_transform_axes + "</PDBx:Cartn_transform_axes>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (fract_transf_matrix11 != null) ow.write(indent + " <PDBx:fract_transf_matrix11>" + fract_transf_matrix11 + "</PDBx:fract_transf_matrix11>\n");
			if (fract_transf_matrix12 != null) ow.write(indent + " <PDBx:fract_transf_matrix12>" + fract_transf_matrix12 + "</PDBx:fract_transf_matrix12>\n");
			if (fract_transf_matrix13 != null) ow.write(indent + " <PDBx:fract_transf_matrix13>" + fract_transf_matrix13 + "</PDBx:fract_transf_matrix13>\n");
			if (fract_transf_matrix21 != null) ow.write(indent + " <PDBx:fract_transf_matrix21>" + fract_transf_matrix21 + "</PDBx:fract_transf_matrix21>\n");
			if (fract_transf_matrix22 != null) ow.write(indent + " <PDBx:fract_transf_matrix22>" + fract_transf_matrix22 + "</PDBx:fract_transf_matrix22>\n");
			if (fract_transf_matrix23 != null) ow.write(indent + " <PDBx:fract_transf_matrix23>" + fract_transf_matrix23 + "</PDBx:fract_transf_matrix23>\n");
			if (fract_transf_matrix31 != null) ow.write(indent + " <PDBx:fract_transf_matrix31>" + fract_transf_matrix31 + "</PDBx:fract_transf_matrix31>\n");
			if (fract_transf_matrix32 != null) ow.write(indent + " <PDBx:fract_transf_matrix32>" + fract_transf_matrix32 + "</PDBx:fract_transf_matrix32>\n");
			if (fract_transf_matrix33 != null) ow.write(indent + " <PDBx:fract_transf_matrix33>" + fract_transf_matrix33 + "</PDBx:fract_transf_matrix33>\n");
			if (fract_transf_vector1 != null) ow.write(indent + " <PDBx:fract_transf_vector1>" + fract_transf_vector1 + "</PDBx:fract_transf_vector1>\n");
			if (fract_transf_vector2 != null) ow.write(indent + " <PDBx:fract_transf_vector2>" + fract_transf_vector2 + "</PDBx:fract_transf_vector2>\n");
			if (fract_transf_vector3 != null) ow.write(indent + " <PDBx:fract_transf_vector3>" + fract_transf_vector3 + "</PDBx:fract_transf_vector3>\n");
			if (solution_hydrogens != null) ow.write(indent + " <PDBx:solution_hydrogens>" + solution_hydrogens + "</PDBx:solution_hydrogens>\n");
			if (solution_primary != null) ow.write(indent + " <PDBx:solution_primary>" + solution_primary + "</PDBx:solution_primary>\n");
			if (solution_secondary != null) ow.write(indent + " <PDBx:solution_secondary>" + solution_secondary + "</PDBx:solution_secondary>\n");
			if (special_details != null) ow.write(indent + " <PDBx:special_details>" + special_details + "</PDBx:special_details>\n");
			ow.write(indent + "</PDBx:atom_sites>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
