package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the ATOM_SITES_ALT category record details
 *  about the structural ensembles that should be generated from
 *  atom sites or groups of atom sites that are modelled in
 *  alternative conformations in this data block.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:atom_sites_altCategory>
 *  <PDBx:atom_sites_alt id="">
 *  <PDBx:details> Atom sites with the alternative ID set to null are not
 *  modeled in alternative conformations</PDBx:details>
 *  </PDBx:atom_sites_alt>
 *  <PDBx:atom_sites_alt id="1">
 *  <PDBx:details> Atom sites with the alternative ID set to 1 have been
 *  modeled in alternative conformations with respect to atom
 *  sites marked with alternative ID 2. The conformations of
 *  amino-acid side chains and solvent atoms with alternative
 *  ID set to 1 correlate with the conformation of the
 *  inhibitor marked with alternative ID 1. They have been
 *  given an occupancy of 0.58 to match the occupancy assigned
 *  to the inhibitor.</PDBx:details>
 *  </PDBx:atom_sites_alt>
 *  <PDBx:atom_sites_alt id="2">
 *  <PDBx:details> Atom sites with the alternative ID set to 2 have been
 *  modeled in alternative conformations with respect to atom
 *  sites marked with alternative ID 1. The conformations of
 *  amino-acid side chains and solvent atoms with alternative
 *  ID set to 2 correlate with the conformation of the
 *  inhibitor marked with alternative ID 2. They have been
 *  given an occupancy of 0.42 to match the occupancy assigned
 *  to the inhibitor.</PDBx:details>
 *  </PDBx:atom_sites_alt>
 *  <PDBx:atom_sites_alt id="3">
 *  <PDBx:details> Atom sites with the alternative ID set to 3 have been
 *  modeled in alternative conformations with respect to
 *  atoms marked with alternative ID 4. The conformations of
 *  amino-acid side chains and solvent atoms with alternative
 *  ID set to 3 do not correlate with the conformation of the
 *  inhibitor. These atom sites have arbitrarily been given
 *  an occupancy of 0.50.</PDBx:details>
 *  </PDBx:atom_sites_alt>
 *  <PDBx:atom_sites_alt id="4">
 *  <PDBx:details> Atom sites with the alternative ID set to 4 have been
 *  modeled in alternative conformations with respect to
 *  atoms marked with alternative ID 3. The conformations of
 *  amino-acid side chains and solvent atoms with alternative
 *  ID set to 4 do not correlate with the conformation of the
 *  inhibitor. These atom sites have arbitrarily been given
 *  an occupancy of 0.50.</PDBx:details>
 *  </PDBx:atom_sites_alt>
 *  </PDBx:atom_sites_altCategory>
 * </pre>
 */
public class Atom_sites_alt extends org.pdb.beans.Atom_sites_alt implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "atom_sites_alt";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Atom_sites_alt()
	{
	}

	/** Full constructor */
	public Atom_sites_alt(
		Datablock datablock,
		java.lang.String details,
		java.lang.String id_)
	{
		this.datablock = datablock;
		this.details = details;
		this.id_ = id_;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Atom_sites_alt");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		id_ = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Atom_sites_alt)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:atom_sites_alt>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			ow.write(indent + "</PDBx:atom_sites_alt>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
