package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the ATOM_TYPE category record details about the
 *  properties of the atoms that occupy the atom sites, such as the
 *  atomic scattering factors.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:atom_typeCategory>
 *  <PDBx:atom_type symbol="C">
 *  <PDBx:oxidation_number>0</PDBx:oxidation_number>
 *  <PDBx:scat_Cromer_Mann_a1>2.31000</PDBx:scat_Cromer_Mann_a1>
 *  <PDBx:scat_Cromer_Mann_a2>20.8439</PDBx:scat_Cromer_Mann_a2>
 *  <PDBx:scat_Cromer_Mann_a3>1.02000</PDBx:scat_Cromer_Mann_a3>
 *  <PDBx:scat_Cromer_Mann_a4>10.2075</PDBx:scat_Cromer_Mann_a4>
 *  <PDBx:scat_Cromer_Mann_b1>1.58860</PDBx:scat_Cromer_Mann_b1>
 *  <PDBx:scat_Cromer_Mann_b2>0.568700</PDBx:scat_Cromer_Mann_b2>
 *  <PDBx:scat_Cromer_Mann_b3>0.865000</PDBx:scat_Cromer_Mann_b3>
 *  <PDBx:scat_Cromer_Mann_b4>51.6512</PDBx:scat_Cromer_Mann_b4>
 *  <PDBx:scat_Cromer_Mann_c>0.21560</PDBx:scat_Cromer_Mann_c>
 *  </PDBx:atom_type>
 *  <PDBx:atom_type symbol="N">
 *  <PDBx:oxidation_number>0</PDBx:oxidation_number>
 *  <PDBx:scat_Cromer_Mann_a1>12.2126</PDBx:scat_Cromer_Mann_a1>
 *  <PDBx:scat_Cromer_Mann_a2>0.005700</PDBx:scat_Cromer_Mann_a2>
 *  <PDBx:scat_Cromer_Mann_a3>3.13220</PDBx:scat_Cromer_Mann_a3>
 *  <PDBx:scat_Cromer_Mann_a4>9.89330</PDBx:scat_Cromer_Mann_a4>
 *  <PDBx:scat_Cromer_Mann_b1>2.01250</PDBx:scat_Cromer_Mann_b1>
 *  <PDBx:scat_Cromer_Mann_b2>28.9975</PDBx:scat_Cromer_Mann_b2>
 *  <PDBx:scat_Cromer_Mann_b3>1.16630</PDBx:scat_Cromer_Mann_b3>
 *  <PDBx:scat_Cromer_Mann_b4>0.582600</PDBx:scat_Cromer_Mann_b4>
 *  <PDBx:scat_Cromer_Mann_c>-11.529</PDBx:scat_Cromer_Mann_c>
 *  </PDBx:atom_type>
 *  <PDBx:atom_type symbol="O">
 *  <PDBx:oxidation_number>0</PDBx:oxidation_number>
 *  <PDBx:scat_Cromer_Mann_a1>3.04850</PDBx:scat_Cromer_Mann_a1>
 *  <PDBx:scat_Cromer_Mann_a2>13.2771</PDBx:scat_Cromer_Mann_a2>
 *  <PDBx:scat_Cromer_Mann_a3>2.28680</PDBx:scat_Cromer_Mann_a3>
 *  <PDBx:scat_Cromer_Mann_a4>5.70110</PDBx:scat_Cromer_Mann_a4>
 *  <PDBx:scat_Cromer_Mann_b1>1.54630</PDBx:scat_Cromer_Mann_b1>
 *  <PDBx:scat_Cromer_Mann_b2>0.323900</PDBx:scat_Cromer_Mann_b2>
 *  <PDBx:scat_Cromer_Mann_b3>0.867000</PDBx:scat_Cromer_Mann_b3>
 *  <PDBx:scat_Cromer_Mann_b4>32.9089</PDBx:scat_Cromer_Mann_b4>
 *  <PDBx:scat_Cromer_Mann_c>0.250800</PDBx:scat_Cromer_Mann_c>
 *  </PDBx:atom_type>
 *  <PDBx:atom_type symbol="S">
 *  <PDBx:oxidation_number>0</PDBx:oxidation_number>
 *  <PDBx:scat_Cromer_Mann_a1>6.90530</PDBx:scat_Cromer_Mann_a1>
 *  <PDBx:scat_Cromer_Mann_a2>1.46790</PDBx:scat_Cromer_Mann_a2>
 *  <PDBx:scat_Cromer_Mann_a3>5.20340</PDBx:scat_Cromer_Mann_a3>
 *  <PDBx:scat_Cromer_Mann_a4>22.2151</PDBx:scat_Cromer_Mann_a4>
 *  <PDBx:scat_Cromer_Mann_b1>1.43790</PDBx:scat_Cromer_Mann_b1>
 *  <PDBx:scat_Cromer_Mann_b2>0.253600</PDBx:scat_Cromer_Mann_b2>
 *  <PDBx:scat_Cromer_Mann_b3>1.58630</PDBx:scat_Cromer_Mann_b3>
 *  <PDBx:scat_Cromer_Mann_b4>56.1720</PDBx:scat_Cromer_Mann_b4>
 *  <PDBx:scat_Cromer_Mann_c>0.866900</PDBx:scat_Cromer_Mann_c>
 *  </PDBx:atom_type>
 *  <PDBx:atom_type symbol="CL">
 *  <PDBx:oxidation_number>-1</PDBx:oxidation_number>
 *  <PDBx:scat_Cromer_Mann_a1>18.2915</PDBx:scat_Cromer_Mann_a1>
 *  <PDBx:scat_Cromer_Mann_a2>0.006600</PDBx:scat_Cromer_Mann_a2>
 *  <PDBx:scat_Cromer_Mann_a3>7.20840</PDBx:scat_Cromer_Mann_a3>
 *  <PDBx:scat_Cromer_Mann_a4>1.17170</PDBx:scat_Cromer_Mann_a4>
 *  <PDBx:scat_Cromer_Mann_b1>6.53370</PDBx:scat_Cromer_Mann_b1>
 *  <PDBx:scat_Cromer_Mann_b2>19.5424</PDBx:scat_Cromer_Mann_b2>
 *  <PDBx:scat_Cromer_Mann_b3>2.33860</PDBx:scat_Cromer_Mann_b3>
 *  <PDBx:scat_Cromer_Mann_b4>60.4486</PDBx:scat_Cromer_Mann_b4>
 *  <PDBx:scat_Cromer_Mann_c>-16.378</PDBx:scat_Cromer_Mann_c>
 *  </PDBx:atom_type>
 *  </PDBx:atom_typeCategory>
 *  
 *  
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:atom_typeCategory>
 *  <PDBx:atom_type symbol="C">
 *  <PDBx:oxidation_number>0</PDBx:oxidation_number>
 *  <PDBx:number_in_cell>72</PDBx:number_in_cell>
 *  <PDBx:scat_dispersion_real>.017</PDBx:scat_dispersion_real>
 *  <PDBx:scat_dispersion_imag>.009</PDBx:scat_dispersion_imag>
 *  <PDBx:scat_source>International_Tables_Vol_IV_Table_2.2B</PDBx:scat_source>
 *  </PDBx:atom_type>
 *  <PDBx:atom_type symbol="H">
 *  <PDBx:oxidation_number>0</PDBx:oxidation_number>
 *  <PDBx:number_in_cell>100</PDBx:number_in_cell>
 *  <PDBx:scat_dispersion_real>0.</PDBx:scat_dispersion_real>
 *  <PDBx:scat_dispersion_imag>0.</PDBx:scat_dispersion_imag>
 *  <PDBx:scat_source>International_Tables_Vol_IV_Table_2.2B</PDBx:scat_source>
 *  </PDBx:atom_type>
 *  <PDBx:atom_type symbol="O">
 *  <PDBx:oxidation_number>0</PDBx:oxidation_number>
 *  <PDBx:number_in_cell>12</PDBx:number_in_cell>
 *  <PDBx:scat_dispersion_real>.047</PDBx:scat_dispersion_real>
 *  <PDBx:scat_dispersion_imag>.032</PDBx:scat_dispersion_imag>
 *  <PDBx:scat_source>International_Tables_Vol_IV_Table_2.2B</PDBx:scat_source>
 *  </PDBx:atom_type>
 *  <PDBx:atom_type symbol="N">
 *  <PDBx:oxidation_number>0</PDBx:oxidation_number>
 *  <PDBx:number_in_cell>4</PDBx:number_in_cell>
 *  <PDBx:scat_dispersion_real>.029</PDBx:scat_dispersion_real>
 *  <PDBx:scat_dispersion_imag>.018</PDBx:scat_dispersion_imag>
 *  <PDBx:scat_source>International_Tables_Vol_IV_Table_2.2B</PDBx:scat_source>
 *  </PDBx:atom_type>
 *  </PDBx:atom_typeCategory>
 * </pre>
 */
public class Atom_type extends org.pdb.beans.Atom_type implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "atom_type";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Atom_type()
	{
	}

	/** Full constructor */
	public Atom_type(
		Datablock datablock,
		java.lang.Float analytical_mass_percent,
		java.lang.String description,
		java.lang.Integer number_in_cell,
		java.lang.Integer oxidation_number,
		java.lang.Float radius_bond,
		java.lang.Float radius_contact,
		java.lang.Float scat_Cromer_Mann_a1,
		java.lang.Float scat_Cromer_Mann_a2,
		java.lang.Float scat_Cromer_Mann_a3,
		java.lang.Float scat_Cromer_Mann_a4,
		java.lang.Float scat_Cromer_Mann_b1,
		java.lang.Float scat_Cromer_Mann_b2,
		java.lang.Float scat_Cromer_Mann_b3,
		java.lang.Float scat_Cromer_Mann_b4,
		java.lang.Float scat_Cromer_Mann_c,
		java.lang.Float scat_dispersion_imag,
		java.lang.Float scat_dispersion_real,
		java.lang.String scat_dispersion_source,
		java.lang.Float scat_length_neutron,
		java.lang.String scat_source,
		java.lang.String scat_versus_stol_list,
		java.lang.String symbol)
	{
		this.datablock = datablock;
		this.analytical_mass_percent = analytical_mass_percent;
		this.description = description;
		this.number_in_cell = number_in_cell;
		this.oxidation_number = oxidation_number;
		this.radius_bond = radius_bond;
		this.radius_contact = radius_contact;
		this.scat_Cromer_Mann_a1 = scat_Cromer_Mann_a1;
		this.scat_Cromer_Mann_a2 = scat_Cromer_Mann_a2;
		this.scat_Cromer_Mann_a3 = scat_Cromer_Mann_a3;
		this.scat_Cromer_Mann_a4 = scat_Cromer_Mann_a4;
		this.scat_Cromer_Mann_b1 = scat_Cromer_Mann_b1;
		this.scat_Cromer_Mann_b2 = scat_Cromer_Mann_b2;
		this.scat_Cromer_Mann_b3 = scat_Cromer_Mann_b3;
		this.scat_Cromer_Mann_b4 = scat_Cromer_Mann_b4;
		this.scat_Cromer_Mann_c = scat_Cromer_Mann_c;
		this.scat_dispersion_imag = scat_dispersion_imag;
		this.scat_dispersion_real = scat_dispersion_real;
		this.scat_dispersion_source = scat_dispersion_source;
		this.scat_length_neutron = scat_length_neutron;
		this.scat_source = scat_source;
		this.scat_versus_stol_list = scat_versus_stol_list;
		this.symbol = symbol;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Atom_type");
		sb.append("\n");
		if (analytical_mass_percent != null)
		{
			sb.append("analytical_mass_percent = ");
			sb.append(analytical_mass_percent);
			sb.append('\n');
		}
		if (description != null)
		{
			sb.append("description = ");
			sb.append(description);
			sb.append('\n');
		}
		if (number_in_cell != null)
		{
			sb.append("number_in_cell = ");
			sb.append(number_in_cell);
			sb.append('\n');
		}
		if (oxidation_number != null)
		{
			sb.append("oxidation_number = ");
			sb.append(oxidation_number);
			sb.append('\n');
		}
		if (radius_bond != null)
		{
			sb.append("radius_bond = ");
			sb.append(radius_bond);
			sb.append('\n');
		}
		if (radius_contact != null)
		{
			sb.append("radius_contact = ");
			sb.append(radius_contact);
			sb.append('\n');
		}
		if (scat_Cromer_Mann_a1 != null)
		{
			sb.append("scat_Cromer_Mann_a1 = ");
			sb.append(scat_Cromer_Mann_a1);
			sb.append('\n');
		}
		if (scat_Cromer_Mann_a2 != null)
		{
			sb.append("scat_Cromer_Mann_a2 = ");
			sb.append(scat_Cromer_Mann_a2);
			sb.append('\n');
		}
		if (scat_Cromer_Mann_a3 != null)
		{
			sb.append("scat_Cromer_Mann_a3 = ");
			sb.append(scat_Cromer_Mann_a3);
			sb.append('\n');
		}
		if (scat_Cromer_Mann_a4 != null)
		{
			sb.append("scat_Cromer_Mann_a4 = ");
			sb.append(scat_Cromer_Mann_a4);
			sb.append('\n');
		}
		if (scat_Cromer_Mann_b1 != null)
		{
			sb.append("scat_Cromer_Mann_b1 = ");
			sb.append(scat_Cromer_Mann_b1);
			sb.append('\n');
		}
		if (scat_Cromer_Mann_b2 != null)
		{
			sb.append("scat_Cromer_Mann_b2 = ");
			sb.append(scat_Cromer_Mann_b2);
			sb.append('\n');
		}
		if (scat_Cromer_Mann_b3 != null)
		{
			sb.append("scat_Cromer_Mann_b3 = ");
			sb.append(scat_Cromer_Mann_b3);
			sb.append('\n');
		}
		if (scat_Cromer_Mann_b4 != null)
		{
			sb.append("scat_Cromer_Mann_b4 = ");
			sb.append(scat_Cromer_Mann_b4);
			sb.append('\n');
		}
		if (scat_Cromer_Mann_c != null)
		{
			sb.append("scat_Cromer_Mann_c = ");
			sb.append(scat_Cromer_Mann_c);
			sb.append('\n');
		}
		if (scat_dispersion_imag != null)
		{
			sb.append("scat_dispersion_imag = ");
			sb.append(scat_dispersion_imag);
			sb.append('\n');
		}
		if (scat_dispersion_real != null)
		{
			sb.append("scat_dispersion_real = ");
			sb.append(scat_dispersion_real);
			sb.append('\n');
		}
		if (scat_dispersion_source != null)
		{
			sb.append("scat_dispersion_source = ");
			sb.append(scat_dispersion_source);
			sb.append('\n');
		}
		if (scat_length_neutron != null)
		{
			sb.append("scat_length_neutron = ");
			sb.append(scat_length_neutron);
			sb.append('\n');
		}
		if (scat_source != null)
		{
			sb.append("scat_source = ");
			sb.append(scat_source);
			sb.append('\n');
		}
		if (scat_versus_stol_list != null)
		{
			sb.append("scat_versus_stol_list = ");
			sb.append(scat_versus_stol_list);
			sb.append('\n');
		}
		if (symbol != null)
		{
			sb.append("symbol = ");
			sb.append(symbol);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		analytical_mass_percent = null;
		description = null;
		number_in_cell = null;
		oxidation_number = null;
		radius_bond = null;
		radius_contact = null;
		scat_Cromer_Mann_a1 = null;
		scat_Cromer_Mann_a2 = null;
		scat_Cromer_Mann_a3 = null;
		scat_Cromer_Mann_a4 = null;
		scat_Cromer_Mann_b1 = null;
		scat_Cromer_Mann_b2 = null;
		scat_Cromer_Mann_b3 = null;
		scat_Cromer_Mann_b4 = null;
		scat_Cromer_Mann_c = null;
		scat_dispersion_imag = null;
		scat_dispersion_real = null;
		scat_dispersion_source = null;
		scat_length_neutron = null;
		scat_source = null;
		scat_versus_stol_list = null;
		symbol = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Atom_type)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:atom_type>\n");
			if (analytical_mass_percent != null) ow.write(indent + " <PDBx:analytical_mass_percent>" + analytical_mass_percent + "</PDBx:analytical_mass_percent>\n");
			if (description != null) ow.write(indent + " <PDBx:description>" + description + "</PDBx:description>\n");
			if (number_in_cell != null) ow.write(indent + " <PDBx:number_in_cell>" + number_in_cell + "</PDBx:number_in_cell>\n");
			if (oxidation_number != null) ow.write(indent + " <PDBx:oxidation_number>" + oxidation_number + "</PDBx:oxidation_number>\n");
			if (radius_bond != null) ow.write(indent + " <PDBx:radius_bond>" + radius_bond + "</PDBx:radius_bond>\n");
			if (radius_contact != null) ow.write(indent + " <PDBx:radius_contact>" + radius_contact + "</PDBx:radius_contact>\n");
			if (scat_Cromer_Mann_a1 != null) ow.write(indent + " <PDBx:scat_Cromer_Mann_a1>" + scat_Cromer_Mann_a1 + "</PDBx:scat_Cromer_Mann_a1>\n");
			if (scat_Cromer_Mann_a2 != null) ow.write(indent + " <PDBx:scat_Cromer_Mann_a2>" + scat_Cromer_Mann_a2 + "</PDBx:scat_Cromer_Mann_a2>\n");
			if (scat_Cromer_Mann_a3 != null) ow.write(indent + " <PDBx:scat_Cromer_Mann_a3>" + scat_Cromer_Mann_a3 + "</PDBx:scat_Cromer_Mann_a3>\n");
			if (scat_Cromer_Mann_a4 != null) ow.write(indent + " <PDBx:scat_Cromer_Mann_a4>" + scat_Cromer_Mann_a4 + "</PDBx:scat_Cromer_Mann_a4>\n");
			if (scat_Cromer_Mann_b1 != null) ow.write(indent + " <PDBx:scat_Cromer_Mann_b1>" + scat_Cromer_Mann_b1 + "</PDBx:scat_Cromer_Mann_b1>\n");
			if (scat_Cromer_Mann_b2 != null) ow.write(indent + " <PDBx:scat_Cromer_Mann_b2>" + scat_Cromer_Mann_b2 + "</PDBx:scat_Cromer_Mann_b2>\n");
			if (scat_Cromer_Mann_b3 != null) ow.write(indent + " <PDBx:scat_Cromer_Mann_b3>" + scat_Cromer_Mann_b3 + "</PDBx:scat_Cromer_Mann_b3>\n");
			if (scat_Cromer_Mann_b4 != null) ow.write(indent + " <PDBx:scat_Cromer_Mann_b4>" + scat_Cromer_Mann_b4 + "</PDBx:scat_Cromer_Mann_b4>\n");
			if (scat_Cromer_Mann_c != null) ow.write(indent + " <PDBx:scat_Cromer_Mann_c>" + scat_Cromer_Mann_c + "</PDBx:scat_Cromer_Mann_c>\n");
			if (scat_dispersion_imag != null) ow.write(indent + " <PDBx:scat_dispersion_imag>" + scat_dispersion_imag + "</PDBx:scat_dispersion_imag>\n");
			if (scat_dispersion_real != null) ow.write(indent + " <PDBx:scat_dispersion_real>" + scat_dispersion_real + "</PDBx:scat_dispersion_real>\n");
			if (scat_dispersion_source != null) ow.write(indent + " <PDBx:scat_dispersion_source>" + scat_dispersion_source + "</PDBx:scat_dispersion_source>\n");
			if (scat_length_neutron != null) ow.write(indent + " <PDBx:scat_length_neutron>" + scat_length_neutron + "</PDBx:scat_length_neutron>\n");
			if (scat_source != null) ow.write(indent + " <PDBx:scat_source>" + scat_source + "</PDBx:scat_source>\n");
			if (scat_versus_stol_list != null) ow.write(indent + " <PDBx:scat_versus_stol_list>" + scat_versus_stol_list + "</PDBx:scat_versus_stol_list>\n");
			if (symbol != null) ow.write(indent + " <PDBx:symbol>" + symbol + "</PDBx:symbol>\n");
			ow.write(indent + "</PDBx:atom_type>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
