package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the AUDIT category record details about the
 *  creation and subsequent updating of the data block.
 *  
 *  Note that these items apply only to the creation and updating of
 *  the data block, and should not be confused with the data items
 *  in the JOURNAL category that record different stages in the
 *  publication of the material in the data block.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:auditCategory>
 *  <PDBx:audit revision_id="1">
 *  <PDBx:creation_date>1992-12-08</PDBx:creation_date>
 *  <PDBx:creation_method> Created by hand from PDB entry 5HVP, from the J. Biol.
 *  Chem. paper describing this structure and from
 *  laboratory records</PDBx:creation_method>
 *  <PDBx:update_record> 1992-12-09  adjusted to reflect comments from B. McKeever
 *  1992-12-10  adjusted to reflect comments from H. Berman
 *  1992-12-12  adjusted to reflect comments from K. Watenpaugh</PDBx:update_record>
 *  </PDBx:audit>
 *  </PDBx:auditCategory>
 *  
 *  
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:auditCategory>
 *  <PDBx:audit>
 *  <PDBx:creation_date>1991-03-20</PDBx:creation_date>
 *  <PDBx:creation_method>from_xtal_archive_file_using_CIFIO</PDBx:creation_method>
 *  <PDBx:update_record> 1991-04-09  text and data added by Tony Willis.
 *  1991-04-15  rec&apos;d by co-editor as manuscript HL0007.
 *  1991-04-17  adjustments based on first referee report.
 *  1991-04-18  adjustments based on second referee report.</PDBx:update_record>
 *  </PDBx:audit>
 *  </PDBx:auditCategory>
 * </pre>
 */
public class Audit extends org.pdb.beans.Audit implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "audit";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Audit()
	{
	}

	/** Full constructor */
	public Audit(
		Datablock datablock,
		java.util.Date creation_date,
		java.lang.String creation_method,
		java.lang.String revision_id,
		java.lang.String update_record)
	{
		this.datablock = datablock;
		this.creation_date = creation_date;
		this.creation_method = creation_method;
		this.revision_id = revision_id;
		this.update_record = update_record;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Audit");
		sb.append("\n");
		if (creation_date != null)
		{
			sb.append("creation_date = ");
			sb.append(creation_date);
			sb.append('\n');
		}
		if (creation_method != null)
		{
			sb.append("creation_method = ");
			sb.append(creation_method);
			sb.append('\n');
		}
		if (revision_id != null)
		{
			sb.append("revision_id = ");
			sb.append(revision_id);
			sb.append('\n');
		}
		if (update_record != null)
		{
			sb.append("update_record = ");
			sb.append(update_record);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		creation_date = null;
		creation_method = null;
		revision_id = null;
		update_record = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Audit)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:audit>\n");
			if (creation_date != null) ow.write(indent + " <PDBx:creation_date>" + creation_date + "</PDBx:creation_date>\n");
			if (creation_method != null) ow.write(indent + " <PDBx:creation_method>" + creation_method + "</PDBx:creation_method>\n");
			if (revision_id != null) ow.write(indent + " <PDBx:revision_id>" + revision_id + "</PDBx:revision_id>\n");
			if (update_record != null) ow.write(indent + " <PDBx:update_record>" + update_record + "</PDBx:update_record>\n");
			ow.write(indent + "</PDBx:audit>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
