package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the AUDIT_LINK category record details about the
 *  relationships between data blocks in the current CIF.
 *  
 * <pre>
 *  Example 1 - multiple structure paper, as illustrated
 *  in A Guide to CIF for Authors (1995). IUCr: Chester.
 *  <PDBx:audit_linkCategory>
 *  <PDBx:audit_link block_code="" block_description="discursive text of paper with two structures"></PDBx:audit_link>
 *  <PDBx:audit_link block_code="morA_(1)" block_description="structure 1 of 2"></PDBx:audit_link>
 *  <PDBx:audit_link block_code="morA_(2)" block_description="structure 2 of 2"></PDBx:audit_link>
 *  </PDBx:audit_linkCategory>
 *  
 *  
 *  Example 2 - example file for the one-dimensional incommensurately
 *  modulated structure of K~2~SeO~4~.
 *  <PDBx:audit_linkCategory>
 *  <PDBx:audit_link block_code="" block_description="publication details"></PDBx:audit_link>
 *  <PDBx:audit_link block_code="KSE_COM" block_description="experimental data common to ref./mod. structures"></PDBx:audit_link>
 *  <PDBx:audit_link block_code="KSE_REF" block_description="reference structure"></PDBx:audit_link>
 *  <PDBx:audit_link block_code="KSE_MOD" block_description="modulated structure"></PDBx:audit_link>
 *  </PDBx:audit_linkCategory>
 * </pre>
 */
public class Audit_link extends org.pdb.beans.Audit_link implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "audit_link";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Audit_link()
	{
	}

	/** Full constructor */
	public Audit_link(
		Datablock datablock,
		java.lang.String block_code,
		java.lang.String block_description)
	{
		this.datablock = datablock;
		this.block_code = block_code;
		this.block_description = block_description;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Audit_link");
		sb.append("\n");
		if (block_code != null)
		{
			sb.append("block_code = ");
			sb.append(block_code);
			sb.append('\n');
		}
		if (block_description != null)
		{
			sb.append("block_description = ");
			sb.append(block_description);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		block_code = null;
		block_description = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Audit_link)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:audit_link>\n");
			if (block_code != null) ow.write(indent + " <PDBx:block_code>" + block_code + "</PDBx:block_code>\n");
			if (block_description != null) ow.write(indent + " <PDBx:block_description>" + block_description + "</PDBx:block_description>\n");
			ow.write(indent + "</PDBx:audit_link>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
