package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CELL category record details about the
 *  crystallographic cell parameters.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:cellCategory>
 *  <PDBx:cell entry_id="5HVP">
 *  <PDBx:length_a>58.39</PDBx:length_a>
 *  <PDBx:length_a_esd>0.05</PDBx:length_a_esd>
 *  <PDBx:length_b>86.70</PDBx:length_b>
 *  <PDBx:length_b_esd>0.12</PDBx:length_b_esd>
 *  <PDBx:length_c>46.27</PDBx:length_c>
 *  <PDBx:length_c_esd>0.06</PDBx:length_c_esd>
 *  <PDBx:angle_alpha>90.00</PDBx:angle_alpha>
 *  <PDBx:angle_beta>90.00</PDBx:angle_beta>
 *  <PDBx:angle_gamma>90.00</PDBx:angle_gamma>
 *  <PDBx:volume>234237.</PDBx:volume>
 *  <PDBx:details> The cell parameters were refined every twenty frames during
 *  data integration. The cell lengths given are the mean of
 *  55 such refinements; the esds given are the root mean
 *  square deviations of these 55 observations from that mean.</PDBx:details>
 *  </PDBx:cell>
 *  </PDBx:cellCategory>
 *  
 *  
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:cellCategory>
 *  <PDBx:cell>
 *  <PDBx:length_a>5.959</PDBx:length_a>
 *  <PDBx:length_a_esd>0.001</PDBx:length_a_esd>
 *  <PDBx:length_b>14.956</PDBx:length_b>
 *  <PDBx:length_b_esd>0.001</PDBx:length_b_esd>
 *  <PDBx:length_c>19.737</PDBx:length_c>
 *  <PDBx:length_c_esd>0.003</PDBx:length_c_esd>
 *  <PDBx:angle_alpha>90.0</PDBx:angle_alpha>
 *  <PDBx:angle_beta>90.0</PDBx:angle_beta>
 *  <PDBx:angle_gamma>90.0</PDBx:angle_gamma>
 *  <PDBx:volume>1759.0</PDBx:volume>
 *  <PDBx:volume_esd>0.3</PDBx:volume_esd>
 *  </PDBx:cell>
 *  </PDBx:cellCategory>
 * </pre>
 */
public class Cell extends org.pdb.beans.Cell implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "cell";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Cell()
	{
	}

	/** Full constructor */
	public Cell(
		Datablock datablock,
		java.lang.Integer Z_PDB,
		java.lang.Float angle_alpha,
		java.lang.Float angle_alpha_esd,
		java.lang.Float angle_beta,
		java.lang.Float angle_beta_esd,
		java.lang.Float angle_gamma,
		java.lang.Float angle_gamma_esd,
		java.lang.String details,
		java.lang.String entry_id,
		java.lang.Integer formula_units_Z,
		java.lang.Float length_a,
		java.lang.Float length_a_esd,
		java.lang.Float length_b,
		java.lang.Float length_b_esd,
		java.lang.Float length_c,
		java.lang.Float length_c_esd,
		java.lang.String pdbx_unique_axis,
		java.lang.Float reciprocal_angle_alpha,
		java.lang.Float reciprocal_angle_alpha_esd,
		java.lang.Float reciprocal_angle_beta,
		java.lang.Float reciprocal_angle_beta_esd,
		java.lang.Float reciprocal_angle_gamma,
		java.lang.Float reciprocal_angle_gamma_esd,
		java.lang.Float reciprocal_length_a,
		java.lang.Float reciprocal_length_a_esd,
		java.lang.Float reciprocal_length_b,
		java.lang.Float reciprocal_length_b_esd,
		java.lang.Float reciprocal_length_c,
		java.lang.Float reciprocal_length_c_esd,
		java.lang.Float volume,
		java.lang.Float volume_esd)
	{
		this.datablock = datablock;
		this.Z_PDB = Z_PDB;
		this.angle_alpha = angle_alpha;
		this.angle_alpha_esd = angle_alpha_esd;
		this.angle_beta = angle_beta;
		this.angle_beta_esd = angle_beta_esd;
		this.angle_gamma = angle_gamma;
		this.angle_gamma_esd = angle_gamma_esd;
		this.details = details;
		this.entry_id = entry_id;
		this.formula_units_Z = formula_units_Z;
		this.length_a = length_a;
		this.length_a_esd = length_a_esd;
		this.length_b = length_b;
		this.length_b_esd = length_b_esd;
		this.length_c = length_c;
		this.length_c_esd = length_c_esd;
		this.pdbx_unique_axis = pdbx_unique_axis;
		this.reciprocal_angle_alpha = reciprocal_angle_alpha;
		this.reciprocal_angle_alpha_esd = reciprocal_angle_alpha_esd;
		this.reciprocal_angle_beta = reciprocal_angle_beta;
		this.reciprocal_angle_beta_esd = reciprocal_angle_beta_esd;
		this.reciprocal_angle_gamma = reciprocal_angle_gamma;
		this.reciprocal_angle_gamma_esd = reciprocal_angle_gamma_esd;
		this.reciprocal_length_a = reciprocal_length_a;
		this.reciprocal_length_a_esd = reciprocal_length_a_esd;
		this.reciprocal_length_b = reciprocal_length_b;
		this.reciprocal_length_b_esd = reciprocal_length_b_esd;
		this.reciprocal_length_c = reciprocal_length_c;
		this.reciprocal_length_c_esd = reciprocal_length_c_esd;
		this.volume = volume;
		this.volume_esd = volume_esd;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Cell");
		sb.append("\n");
		if (Z_PDB != null)
		{
			sb.append("Z_PDB = ");
			sb.append(Z_PDB);
			sb.append('\n');
		}
		if (angle_alpha != null)
		{
			sb.append("angle_alpha = ");
			sb.append(angle_alpha);
			sb.append('\n');
		}
		if (angle_alpha_esd != null)
		{
			sb.append("angle_alpha_esd = ");
			sb.append(angle_alpha_esd);
			sb.append('\n');
		}
		if (angle_beta != null)
		{
			sb.append("angle_beta = ");
			sb.append(angle_beta);
			sb.append('\n');
		}
		if (angle_beta_esd != null)
		{
			sb.append("angle_beta_esd = ");
			sb.append(angle_beta_esd);
			sb.append('\n');
		}
		if (angle_gamma != null)
		{
			sb.append("angle_gamma = ");
			sb.append(angle_gamma);
			sb.append('\n');
		}
		if (angle_gamma_esd != null)
		{
			sb.append("angle_gamma_esd = ");
			sb.append(angle_gamma_esd);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (formula_units_Z != null)
		{
			sb.append("formula_units_Z = ");
			sb.append(formula_units_Z);
			sb.append('\n');
		}
		if (length_a != null)
		{
			sb.append("length_a = ");
			sb.append(length_a);
			sb.append('\n');
		}
		if (length_a_esd != null)
		{
			sb.append("length_a_esd = ");
			sb.append(length_a_esd);
			sb.append('\n');
		}
		if (length_b != null)
		{
			sb.append("length_b = ");
			sb.append(length_b);
			sb.append('\n');
		}
		if (length_b_esd != null)
		{
			sb.append("length_b_esd = ");
			sb.append(length_b_esd);
			sb.append('\n');
		}
		if (length_c != null)
		{
			sb.append("length_c = ");
			sb.append(length_c);
			sb.append('\n');
		}
		if (length_c_esd != null)
		{
			sb.append("length_c_esd = ");
			sb.append(length_c_esd);
			sb.append('\n');
		}
		if (pdbx_unique_axis != null)
		{
			sb.append("pdbx_unique_axis = ");
			sb.append(pdbx_unique_axis);
			sb.append('\n');
		}
		if (reciprocal_angle_alpha != null)
		{
			sb.append("reciprocal_angle_alpha = ");
			sb.append(reciprocal_angle_alpha);
			sb.append('\n');
		}
		if (reciprocal_angle_alpha_esd != null)
		{
			sb.append("reciprocal_angle_alpha_esd = ");
			sb.append(reciprocal_angle_alpha_esd);
			sb.append('\n');
		}
		if (reciprocal_angle_beta != null)
		{
			sb.append("reciprocal_angle_beta = ");
			sb.append(reciprocal_angle_beta);
			sb.append('\n');
		}
		if (reciprocal_angle_beta_esd != null)
		{
			sb.append("reciprocal_angle_beta_esd = ");
			sb.append(reciprocal_angle_beta_esd);
			sb.append('\n');
		}
		if (reciprocal_angle_gamma != null)
		{
			sb.append("reciprocal_angle_gamma = ");
			sb.append(reciprocal_angle_gamma);
			sb.append('\n');
		}
		if (reciprocal_angle_gamma_esd != null)
		{
			sb.append("reciprocal_angle_gamma_esd = ");
			sb.append(reciprocal_angle_gamma_esd);
			sb.append('\n');
		}
		if (reciprocal_length_a != null)
		{
			sb.append("reciprocal_length_a = ");
			sb.append(reciprocal_length_a);
			sb.append('\n');
		}
		if (reciprocal_length_a_esd != null)
		{
			sb.append("reciprocal_length_a_esd = ");
			sb.append(reciprocal_length_a_esd);
			sb.append('\n');
		}
		if (reciprocal_length_b != null)
		{
			sb.append("reciprocal_length_b = ");
			sb.append(reciprocal_length_b);
			sb.append('\n');
		}
		if (reciprocal_length_b_esd != null)
		{
			sb.append("reciprocal_length_b_esd = ");
			sb.append(reciprocal_length_b_esd);
			sb.append('\n');
		}
		if (reciprocal_length_c != null)
		{
			sb.append("reciprocal_length_c = ");
			sb.append(reciprocal_length_c);
			sb.append('\n');
		}
		if (reciprocal_length_c_esd != null)
		{
			sb.append("reciprocal_length_c_esd = ");
			sb.append(reciprocal_length_c_esd);
			sb.append('\n');
		}
		if (volume != null)
		{
			sb.append("volume = ");
			sb.append(volume);
			sb.append('\n');
		}
		if (volume_esd != null)
		{
			sb.append("volume_esd = ");
			sb.append(volume_esd);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		Z_PDB = null;
		angle_alpha = null;
		angle_alpha_esd = null;
		angle_beta = null;
		angle_beta_esd = null;
		angle_gamma = null;
		angle_gamma_esd = null;
		details = null;
		entry_id = null;
		formula_units_Z = null;
		length_a = null;
		length_a_esd = null;
		length_b = null;
		length_b_esd = null;
		length_c = null;
		length_c_esd = null;
		pdbx_unique_axis = null;
		reciprocal_angle_alpha = null;
		reciprocal_angle_alpha_esd = null;
		reciprocal_angle_beta = null;
		reciprocal_angle_beta_esd = null;
		reciprocal_angle_gamma = null;
		reciprocal_angle_gamma_esd = null;
		reciprocal_length_a = null;
		reciprocal_length_a_esd = null;
		reciprocal_length_b = null;
		reciprocal_length_b_esd = null;
		reciprocal_length_c = null;
		reciprocal_length_c_esd = null;
		volume = null;
		volume_esd = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Cell)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:cell>\n");
			if (Z_PDB != null) ow.write(indent + " <PDBx:Z_PDB>" + Z_PDB + "</PDBx:Z_PDB>\n");
			if (angle_alpha != null) ow.write(indent + " <PDBx:angle_alpha>" + angle_alpha + "</PDBx:angle_alpha>\n");
			if (angle_alpha_esd != null) ow.write(indent + " <PDBx:angle_alpha_esd>" + angle_alpha_esd + "</PDBx:angle_alpha_esd>\n");
			if (angle_beta != null) ow.write(indent + " <PDBx:angle_beta>" + angle_beta + "</PDBx:angle_beta>\n");
			if (angle_beta_esd != null) ow.write(indent + " <PDBx:angle_beta_esd>" + angle_beta_esd + "</PDBx:angle_beta_esd>\n");
			if (angle_gamma != null) ow.write(indent + " <PDBx:angle_gamma>" + angle_gamma + "</PDBx:angle_gamma>\n");
			if (angle_gamma_esd != null) ow.write(indent + " <PDBx:angle_gamma_esd>" + angle_gamma_esd + "</PDBx:angle_gamma_esd>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (formula_units_Z != null) ow.write(indent + " <PDBx:formula_units_Z>" + formula_units_Z + "</PDBx:formula_units_Z>\n");
			if (length_a != null) ow.write(indent + " <PDBx:length_a>" + length_a + "</PDBx:length_a>\n");
			if (length_a_esd != null) ow.write(indent + " <PDBx:length_a_esd>" + length_a_esd + "</PDBx:length_a_esd>\n");
			if (length_b != null) ow.write(indent + " <PDBx:length_b>" + length_b + "</PDBx:length_b>\n");
			if (length_b_esd != null) ow.write(indent + " <PDBx:length_b_esd>" + length_b_esd + "</PDBx:length_b_esd>\n");
			if (length_c != null) ow.write(indent + " <PDBx:length_c>" + length_c + "</PDBx:length_c>\n");
			if (length_c_esd != null) ow.write(indent + " <PDBx:length_c_esd>" + length_c_esd + "</PDBx:length_c_esd>\n");
			if (pdbx_unique_axis != null) ow.write(indent + " <PDBx:pdbx_unique_axis>" + pdbx_unique_axis + "</PDBx:pdbx_unique_axis>\n");
			if (reciprocal_angle_alpha != null) ow.write(indent + " <PDBx:reciprocal_angle_alpha>" + reciprocal_angle_alpha + "</PDBx:reciprocal_angle_alpha>\n");
			if (reciprocal_angle_alpha_esd != null) ow.write(indent + " <PDBx:reciprocal_angle_alpha_esd>" + reciprocal_angle_alpha_esd + "</PDBx:reciprocal_angle_alpha_esd>\n");
			if (reciprocal_angle_beta != null) ow.write(indent + " <PDBx:reciprocal_angle_beta>" + reciprocal_angle_beta + "</PDBx:reciprocal_angle_beta>\n");
			if (reciprocal_angle_beta_esd != null) ow.write(indent + " <PDBx:reciprocal_angle_beta_esd>" + reciprocal_angle_beta_esd + "</PDBx:reciprocal_angle_beta_esd>\n");
			if (reciprocal_angle_gamma != null) ow.write(indent + " <PDBx:reciprocal_angle_gamma>" + reciprocal_angle_gamma + "</PDBx:reciprocal_angle_gamma>\n");
			if (reciprocal_angle_gamma_esd != null) ow.write(indent + " <PDBx:reciprocal_angle_gamma_esd>" + reciprocal_angle_gamma_esd + "</PDBx:reciprocal_angle_gamma_esd>\n");
			if (reciprocal_length_a != null) ow.write(indent + " <PDBx:reciprocal_length_a>" + reciprocal_length_a + "</PDBx:reciprocal_length_a>\n");
			if (reciprocal_length_a_esd != null) ow.write(indent + " <PDBx:reciprocal_length_a_esd>" + reciprocal_length_a_esd + "</PDBx:reciprocal_length_a_esd>\n");
			if (reciprocal_length_b != null) ow.write(indent + " <PDBx:reciprocal_length_b>" + reciprocal_length_b + "</PDBx:reciprocal_length_b>\n");
			if (reciprocal_length_b_esd != null) ow.write(indent + " <PDBx:reciprocal_length_b_esd>" + reciprocal_length_b_esd + "</PDBx:reciprocal_length_b_esd>\n");
			if (reciprocal_length_c != null) ow.write(indent + " <PDBx:reciprocal_length_c>" + reciprocal_length_c + "</PDBx:reciprocal_length_c>\n");
			if (reciprocal_length_c_esd != null) ow.write(indent + " <PDBx:reciprocal_length_c_esd>" + reciprocal_length_c_esd + "</PDBx:reciprocal_length_c_esd>\n");
			if (volume != null) ow.write(indent + " <PDBx:volume>" + volume + "</PDBx:volume>\n");
			if (volume_esd != null) ow.write(indent + " <PDBx:volume_esd>" + volume_esd + "</PDBx:volume_esd>\n");
			ow.write(indent + "</PDBx:cell>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
