package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEM_COMP_ANGLE category record details about
 *  angles in a chemical component. Angles are designated by three
 *  atoms, with the second atom forming the vertex of the angle.
 *  Target values may be specified as angles in degrees, as a
 *  distance between the first and third atoms, or both.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:chem_comp_angleCategory>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="N" atom_id_2="CA" atom_id_3="C">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CA" atom_id_2="C" atom_id_3="O">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CB" atom_id_2="CA" atom_id_3="C">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CB" atom_id_2="CA" atom_id_3="N">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CA" atom_id_2="CB" atom_id_3="CG">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CB" atom_id_2="CG" atom_id_3="CD1">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CB" atom_id_2="CG" atom_id_3="CD2">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CD1" atom_id_2="CG" atom_id_3="CD2">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CG" atom_id_2="CD1" atom_id_3="CE1">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CD1" atom_id_2="CE1" atom_id_3="CZ">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CE1" atom_id_2="CZ" atom_id_3="CE2">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CZ" atom_id_2="CE2" atom_id_3="CD2">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CG" atom_id_2="CD2" atom_id_3="CE2">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="val" atom_id_1="N" atom_id_2="CA" atom_id_3="C">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="val" atom_id_1="CA" atom_id_2="C" atom_id_3="O">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="val" atom_id_1="CB" atom_id_2="CA" atom_id_3="C">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="val" atom_id_1="CB" atom_id_2="CA" atom_id_3="N">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="val" atom_id_1="CA" atom_id_2="CB" atom_id_3="CG1">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="val" atom_id_1="CA" atom_id_2="CB" atom_id_3="CG2">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="val" atom_id_1="CG1" atom_id_2="CB" atom_id_3="CG2">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  </PDBx:chem_comp_angleCategory>
 * </pre>
 */
public class Chem_comp_angle extends org.pdb.beans.Chem_comp_angle implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chem_comp_angle";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chem_comp_angle()
	{
	}

	/** Full constructor */
	public Chem_comp_angle(
		Datablock datablock,
		java.lang.String atom_id_1,
		java.lang.String atom_id_2,
		java.lang.String atom_id_3,
		java.lang.String comp_id,
		java.lang.Float value_angle,
		java.lang.Float value_angle_esd,
		java.lang.Float value_dist,
		java.lang.Float value_dist_esd)
	{
		this.datablock = datablock;
		this.atom_id_1 = atom_id_1;
		this.atom_id_2 = atom_id_2;
		this.atom_id_3 = atom_id_3;
		this.comp_id = comp_id;
		this.value_angle = value_angle;
		this.value_angle_esd = value_angle_esd;
		this.value_dist = value_dist;
		this.value_dist_esd = value_dist_esd;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chem_comp_angle");
		sb.append("\n");
		if (atom_id_1 != null)
		{
			sb.append("atom_id_1 = ");
			sb.append(atom_id_1);
			sb.append('\n');
		}
		if (atom_id_2 != null)
		{
			sb.append("atom_id_2 = ");
			sb.append(atom_id_2);
			sb.append('\n');
		}
		if (atom_id_3 != null)
		{
			sb.append("atom_id_3 = ");
			sb.append(atom_id_3);
			sb.append('\n');
		}
		if (comp_id != null)
		{
			sb.append("comp_id = ");
			sb.append(comp_id);
			sb.append('\n');
		}
		if (value_angle != null)
		{
			sb.append("value_angle = ");
			sb.append(value_angle);
			sb.append('\n');
		}
		if (value_angle_esd != null)
		{
			sb.append("value_angle_esd = ");
			sb.append(value_angle_esd);
			sb.append('\n');
		}
		if (value_dist != null)
		{
			sb.append("value_dist = ");
			sb.append(value_dist);
			sb.append('\n');
		}
		if (value_dist_esd != null)
		{
			sb.append("value_dist_esd = ");
			sb.append(value_dist_esd);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		atom_id_1 = null;
		atom_id_2 = null;
		atom_id_3 = null;
		comp_id = null;
		value_angle = null;
		value_angle_esd = null;
		value_dist = null;
		value_dist_esd = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chem_comp_angle)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chem_comp_angle>\n");
			if (atom_id_1 != null) ow.write(indent + " <PDBx:atom_id_1>" + atom_id_1 + "</PDBx:atom_id_1>\n");
			if (atom_id_2 != null) ow.write(indent + " <PDBx:atom_id_2>" + atom_id_2 + "</PDBx:atom_id_2>\n");
			if (atom_id_3 != null) ow.write(indent + " <PDBx:atom_id_3>" + atom_id_3 + "</PDBx:atom_id_3>\n");
			if (comp_id != null) ow.write(indent + " <PDBx:comp_id>" + comp_id + "</PDBx:comp_id>\n");
			if (value_angle != null) ow.write(indent + " <PDBx:value_angle>" + value_angle + "</PDBx:value_angle>\n");
			if (value_angle_esd != null) ow.write(indent + " <PDBx:value_angle_esd>" + value_angle_esd + "</PDBx:value_angle_esd>\n");
			if (value_dist != null) ow.write(indent + " <PDBx:value_dist>" + value_dist + "</PDBx:value_dist>\n");
			if (value_dist_esd != null) ow.write(indent + " <PDBx:value_dist_esd>" + value_dist_esd + "</PDBx:value_dist_esd>\n");
			ow.write(indent + "</PDBx:chem_comp_angle>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
