package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEM_COMP_ATOM category record details about
 *  the atoms in a chemical component. Specifying the atomic
 *  coordinates for the components in this category is an
 *  alternative to specifying the structure of the component
 *  via bonds, angles, planes etc. in the appropriate
 *  CHEM_COMP subcategories.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:chem_comp_atomCategory>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="N">
 *  <PDBx:type_symbol>N</PDBx:type_symbol>
 *  <PDBx:substruct_code>main</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>1.20134</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.84658</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>0.00000</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="CA">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>main</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>0.00000</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.00000</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>0.00000</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="C">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>main</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>-1.25029</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.88107</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>0.00000</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="O">
 *  <PDBx:type_symbol>O</PDBx:type_symbol>
 *  <PDBx:substruct_code>main</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>-2.18525</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.66029</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>-0.78409</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="CB">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>side</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>0.00662</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>-1.03603</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>1.11081</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="CG">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>side</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>0.03254</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>-0.49711</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>2.50951</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="CD1">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>side</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>-1.15813</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>-0.12084</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>3.13467</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="CE1">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>side</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>-1.15720</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.38038</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>4.42732</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="CZ">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>side</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>0.05385</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.51332</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>5.11032</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="CE2">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>side</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>1.26137</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.11613</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>4.50975</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="CD2">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>side</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>1.23668</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>-0.38351</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>3.20288</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="val" atom_id="N">
 *  <PDBx:type_symbol>N</PDBx:type_symbol>
 *  <PDBx:substruct_code>main</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>1.20134</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.84658</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>0.00000</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="val" atom_id="CA">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>main</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>0.00000</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.00000</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>0.00000</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="val" atom_id="C">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>main</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>-1.25029</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.88107</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>0.00000</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="val" atom_id="O">
 *  <PDBx:type_symbol>O</PDBx:type_symbol>
 *  <PDBx:substruct_code>main</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>-2.18525</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.66029</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>-0.78409</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="val" atom_id="CB">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>side</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>0.05260</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>-0.99339</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>1.17429</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="val" atom_id="CG1">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>side</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>-0.13288</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>-0.31545</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>2.52668</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="val" atom_id="CG2">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>side</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>-0.94265</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>-2.12930</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>0.99811</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  </PDBx:chem_comp_atomCategory>
 * </pre>
 */
public class Chem_comp_atom extends org.pdb.beans.Chem_comp_atom implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chem_comp_atom";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chem_comp_atom()
	{
	}

	/** Full constructor */
	public Chem_comp_atom(
		Datablock datablock,
		java.lang.String alt_atom_id,
		java.lang.String atom_id,
		java.lang.Integer charge,
		java.lang.String comp_id,
		java.lang.Float model_Cartn_x,
		java.lang.Float model_Cartn_x_esd,
		java.lang.Float model_Cartn_y,
		java.lang.Float model_Cartn_y_esd,
		java.lang.Float model_Cartn_z,
		java.lang.Float model_Cartn_z_esd,
		java.lang.Float partial_charge,
		java.lang.Integer pdbx_align,
		java.lang.String pdbx_alt_atom_id,
		java.lang.String pdbx_alt_comp_id,
		java.lang.String pdbx_aromatic_flag,
		java.lang.String pdbx_leaving_atom_flag,
		java.lang.Float pdbx_model_Cartn_x_ideal,
		java.lang.Float pdbx_model_Cartn_y_ideal,
		java.lang.Float pdbx_model_Cartn_z_ideal,
		java.lang.Integer pdbx_ordinal,
		java.lang.String pdbx_stereo_config,
		java.lang.String substruct_code,
		java.lang.String type_symbol)
	{
		this.datablock = datablock;
		this.alt_atom_id = alt_atom_id;
		this.atom_id = atom_id;
		this.charge = charge;
		this.comp_id = comp_id;
		this.model_Cartn_x = model_Cartn_x;
		this.model_Cartn_x_esd = model_Cartn_x_esd;
		this.model_Cartn_y = model_Cartn_y;
		this.model_Cartn_y_esd = model_Cartn_y_esd;
		this.model_Cartn_z = model_Cartn_z;
		this.model_Cartn_z_esd = model_Cartn_z_esd;
		this.partial_charge = partial_charge;
		this.pdbx_align = pdbx_align;
		this.pdbx_alt_atom_id = pdbx_alt_atom_id;
		this.pdbx_alt_comp_id = pdbx_alt_comp_id;
		this.pdbx_aromatic_flag = pdbx_aromatic_flag;
		this.pdbx_leaving_atom_flag = pdbx_leaving_atom_flag;
		this.pdbx_model_Cartn_x_ideal = pdbx_model_Cartn_x_ideal;
		this.pdbx_model_Cartn_y_ideal = pdbx_model_Cartn_y_ideal;
		this.pdbx_model_Cartn_z_ideal = pdbx_model_Cartn_z_ideal;
		this.pdbx_ordinal = pdbx_ordinal;
		this.pdbx_stereo_config = pdbx_stereo_config;
		this.substruct_code = substruct_code;
		this.type_symbol = type_symbol;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chem_comp_atom");
		sb.append("\n");
		if (alt_atom_id != null)
		{
			sb.append("alt_atom_id = ");
			sb.append(alt_atom_id);
			sb.append('\n');
		}
		if (atom_id != null)
		{
			sb.append("atom_id = ");
			sb.append(atom_id);
			sb.append('\n');
		}
		if (charge != null)
		{
			sb.append("charge = ");
			sb.append(charge);
			sb.append('\n');
		}
		if (comp_id != null)
		{
			sb.append("comp_id = ");
			sb.append(comp_id);
			sb.append('\n');
		}
		if (model_Cartn_x != null)
		{
			sb.append("model_Cartn_x = ");
			sb.append(model_Cartn_x);
			sb.append('\n');
		}
		if (model_Cartn_x_esd != null)
		{
			sb.append("model_Cartn_x_esd = ");
			sb.append(model_Cartn_x_esd);
			sb.append('\n');
		}
		if (model_Cartn_y != null)
		{
			sb.append("model_Cartn_y = ");
			sb.append(model_Cartn_y);
			sb.append('\n');
		}
		if (model_Cartn_y_esd != null)
		{
			sb.append("model_Cartn_y_esd = ");
			sb.append(model_Cartn_y_esd);
			sb.append('\n');
		}
		if (model_Cartn_z != null)
		{
			sb.append("model_Cartn_z = ");
			sb.append(model_Cartn_z);
			sb.append('\n');
		}
		if (model_Cartn_z_esd != null)
		{
			sb.append("model_Cartn_z_esd = ");
			sb.append(model_Cartn_z_esd);
			sb.append('\n');
		}
		if (partial_charge != null)
		{
			sb.append("partial_charge = ");
			sb.append(partial_charge);
			sb.append('\n');
		}
		if (pdbx_align != null)
		{
			sb.append("pdbx_align = ");
			sb.append(pdbx_align);
			sb.append('\n');
		}
		if (pdbx_alt_atom_id != null)
		{
			sb.append("pdbx_alt_atom_id = ");
			sb.append(pdbx_alt_atom_id);
			sb.append('\n');
		}
		if (pdbx_alt_comp_id != null)
		{
			sb.append("pdbx_alt_comp_id = ");
			sb.append(pdbx_alt_comp_id);
			sb.append('\n');
		}
		if (pdbx_aromatic_flag != null)
		{
			sb.append("pdbx_aromatic_flag = ");
			sb.append(pdbx_aromatic_flag);
			sb.append('\n');
		}
		if (pdbx_leaving_atom_flag != null)
		{
			sb.append("pdbx_leaving_atom_flag = ");
			sb.append(pdbx_leaving_atom_flag);
			sb.append('\n');
		}
		if (pdbx_model_Cartn_x_ideal != null)
		{
			sb.append("pdbx_model_Cartn_x_ideal = ");
			sb.append(pdbx_model_Cartn_x_ideal);
			sb.append('\n');
		}
		if (pdbx_model_Cartn_y_ideal != null)
		{
			sb.append("pdbx_model_Cartn_y_ideal = ");
			sb.append(pdbx_model_Cartn_y_ideal);
			sb.append('\n');
		}
		if (pdbx_model_Cartn_z_ideal != null)
		{
			sb.append("pdbx_model_Cartn_z_ideal = ");
			sb.append(pdbx_model_Cartn_z_ideal);
			sb.append('\n');
		}
		if (pdbx_ordinal != null)
		{
			sb.append("pdbx_ordinal = ");
			sb.append(pdbx_ordinal);
			sb.append('\n');
		}
		if (pdbx_stereo_config != null)
		{
			sb.append("pdbx_stereo_config = ");
			sb.append(pdbx_stereo_config);
			sb.append('\n');
		}
		if (substruct_code != null)
		{
			sb.append("substruct_code = ");
			sb.append(substruct_code);
			sb.append('\n');
		}
		if (type_symbol != null)
		{
			sb.append("type_symbol = ");
			sb.append(type_symbol);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		alt_atom_id = null;
		atom_id = null;
		charge = null;
		comp_id = null;
		model_Cartn_x = null;
		model_Cartn_x_esd = null;
		model_Cartn_y = null;
		model_Cartn_y_esd = null;
		model_Cartn_z = null;
		model_Cartn_z_esd = null;
		partial_charge = null;
		pdbx_align = null;
		pdbx_alt_atom_id = null;
		pdbx_alt_comp_id = null;
		pdbx_aromatic_flag = null;
		pdbx_leaving_atom_flag = null;
		pdbx_model_Cartn_x_ideal = null;
		pdbx_model_Cartn_y_ideal = null;
		pdbx_model_Cartn_z_ideal = null;
		pdbx_ordinal = null;
		pdbx_stereo_config = null;
		substruct_code = null;
		type_symbol = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chem_comp_atom)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chem_comp_atom>\n");
			if (alt_atom_id != null) ow.write(indent + " <PDBx:alt_atom_id>" + alt_atom_id + "</PDBx:alt_atom_id>\n");
			if (atom_id != null) ow.write(indent + " <PDBx:atom_id>" + atom_id + "</PDBx:atom_id>\n");
			if (charge != null) ow.write(indent + " <PDBx:charge>" + charge + "</PDBx:charge>\n");
			if (comp_id != null) ow.write(indent + " <PDBx:comp_id>" + comp_id + "</PDBx:comp_id>\n");
			if (model_Cartn_x != null) ow.write(indent + " <PDBx:model_Cartn_x>" + model_Cartn_x + "</PDBx:model_Cartn_x>\n");
			if (model_Cartn_x_esd != null) ow.write(indent + " <PDBx:model_Cartn_x_esd>" + model_Cartn_x_esd + "</PDBx:model_Cartn_x_esd>\n");
			if (model_Cartn_y != null) ow.write(indent + " <PDBx:model_Cartn_y>" + model_Cartn_y + "</PDBx:model_Cartn_y>\n");
			if (model_Cartn_y_esd != null) ow.write(indent + " <PDBx:model_Cartn_y_esd>" + model_Cartn_y_esd + "</PDBx:model_Cartn_y_esd>\n");
			if (model_Cartn_z != null) ow.write(indent + " <PDBx:model_Cartn_z>" + model_Cartn_z + "</PDBx:model_Cartn_z>\n");
			if (model_Cartn_z_esd != null) ow.write(indent + " <PDBx:model_Cartn_z_esd>" + model_Cartn_z_esd + "</PDBx:model_Cartn_z_esd>\n");
			if (partial_charge != null) ow.write(indent + " <PDBx:partial_charge>" + partial_charge + "</PDBx:partial_charge>\n");
			if (pdbx_align != null) ow.write(indent + " <PDBx:pdbx_align>" + pdbx_align + "</PDBx:pdbx_align>\n");
			if (pdbx_alt_atom_id != null) ow.write(indent + " <PDBx:pdbx_alt_atom_id>" + pdbx_alt_atom_id + "</PDBx:pdbx_alt_atom_id>\n");
			if (pdbx_alt_comp_id != null) ow.write(indent + " <PDBx:pdbx_alt_comp_id>" + pdbx_alt_comp_id + "</PDBx:pdbx_alt_comp_id>\n");
			if (pdbx_aromatic_flag != null) ow.write(indent + " <PDBx:pdbx_aromatic_flag>" + pdbx_aromatic_flag + "</PDBx:pdbx_aromatic_flag>\n");
			if (pdbx_leaving_atom_flag != null) ow.write(indent + " <PDBx:pdbx_leaving_atom_flag>" + pdbx_leaving_atom_flag + "</PDBx:pdbx_leaving_atom_flag>\n");
			if (pdbx_model_Cartn_x_ideal != null) ow.write(indent + " <PDBx:pdbx_model_Cartn_x_ideal>" + pdbx_model_Cartn_x_ideal + "</PDBx:pdbx_model_Cartn_x_ideal>\n");
			if (pdbx_model_Cartn_y_ideal != null) ow.write(indent + " <PDBx:pdbx_model_Cartn_y_ideal>" + pdbx_model_Cartn_y_ideal + "</PDBx:pdbx_model_Cartn_y_ideal>\n");
			if (pdbx_model_Cartn_z_ideal != null) ow.write(indent + " <PDBx:pdbx_model_Cartn_z_ideal>" + pdbx_model_Cartn_z_ideal + "</PDBx:pdbx_model_Cartn_z_ideal>\n");
			if (pdbx_ordinal != null) ow.write(indent + " <PDBx:pdbx_ordinal>" + pdbx_ordinal + "</PDBx:pdbx_ordinal>\n");
			if (pdbx_stereo_config != null) ow.write(indent + " <PDBx:pdbx_stereo_config>" + pdbx_stereo_config + "</PDBx:pdbx_stereo_config>\n");
			if (substruct_code != null) ow.write(indent + " <PDBx:substruct_code>" + substruct_code + "</PDBx:substruct_code>\n");
			if (type_symbol != null) ow.write(indent + " <PDBx:type_symbol>" + type_symbol + "</PDBx:type_symbol>\n");
			ow.write(indent + "</PDBx:chem_comp_atom>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
