package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEM_COMP_BOND category record details about
 *  the bonds between atoms in a chemical component. Target values
 *  may be specified as bond orders, as a distance between the two
 *  atoms, or both.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:chem_comp_bondCategory>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="N" atom_id_2="CA">
 *  <PDBx:value_order>sing</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="CA" atom_id_2="C">
 *  <PDBx:value_order>sing</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="C" atom_id_2="O">
 *  <PDBx:value_order>doub</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="CB" atom_id_2="CA">
 *  <PDBx:value_order>sing</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="CB" atom_id_2="CG">
 *  <PDBx:value_order>sing</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="CG" atom_id_2="CD1">
 *  <PDBx:value_order>arom</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="CD1" atom_id_2="CE1">
 *  <PDBx:value_order>arom</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="CE1" atom_id_2="CZ">
 *  <PDBx:value_order>arom</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="CZ" atom_id_2="CE2">
 *  <PDBx:value_order>arom</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="CE2" atom_id_2="CD2">
 *  <PDBx:value_order>arom</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="CD2" atom_id_2="CG">
 *  <PDBx:value_order>arom</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="val" atom_id_1="N" atom_id_2="CA">
 *  <PDBx:value_order>sing</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="val" atom_id_1="CA" atom_id_2="C">
 *  <PDBx:value_order>sing</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="val" atom_id_1="C" atom_id_2="O">
 *  <PDBx:value_order>doub</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="val" atom_id_1="CB" atom_id_2="CA">
 *  <PDBx:value_order>sing</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="val" atom_id_1="CB" atom_id_2="CG1">
 *  <PDBx:value_order>sing</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="val" atom_id_1="CB" atom_id_2="CG2">
 *  <PDBx:value_order>sing</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  </PDBx:chem_comp_bondCategory>
 * </pre>
 */
public class Chem_comp_bond extends org.pdb.beans.Chem_comp_bond implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chem_comp_bond";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chem_comp_bond()
	{
	}

	/** Full constructor */
	public Chem_comp_bond(
		Datablock datablock,
		java.lang.String atom_id_1,
		java.lang.String atom_id_2,
		java.lang.String comp_id,
		java.lang.String pdbx_aromatic_flag,
		java.lang.Integer pdbx_ordinal,
		java.lang.String pdbx_stereo_config,
		java.lang.Float value_dist,
		java.lang.Float value_dist_esd,
		java.lang.String value_order)
	{
		this.datablock = datablock;
		this.atom_id_1 = atom_id_1;
		this.atom_id_2 = atom_id_2;
		this.comp_id = comp_id;
		this.pdbx_aromatic_flag = pdbx_aromatic_flag;
		this.pdbx_ordinal = pdbx_ordinal;
		this.pdbx_stereo_config = pdbx_stereo_config;
		this.value_dist = value_dist;
		this.value_dist_esd = value_dist_esd;
		this.value_order = value_order;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chem_comp_bond");
		sb.append("\n");
		if (atom_id_1 != null)
		{
			sb.append("atom_id_1 = ");
			sb.append(atom_id_1);
			sb.append('\n');
		}
		if (atom_id_2 != null)
		{
			sb.append("atom_id_2 = ");
			sb.append(atom_id_2);
			sb.append('\n');
		}
		if (comp_id != null)
		{
			sb.append("comp_id = ");
			sb.append(comp_id);
			sb.append('\n');
		}
		if (pdbx_aromatic_flag != null)
		{
			sb.append("pdbx_aromatic_flag = ");
			sb.append(pdbx_aromatic_flag);
			sb.append('\n');
		}
		if (pdbx_ordinal != null)
		{
			sb.append("pdbx_ordinal = ");
			sb.append(pdbx_ordinal);
			sb.append('\n');
		}
		if (pdbx_stereo_config != null)
		{
			sb.append("pdbx_stereo_config = ");
			sb.append(pdbx_stereo_config);
			sb.append('\n');
		}
		if (value_dist != null)
		{
			sb.append("value_dist = ");
			sb.append(value_dist);
			sb.append('\n');
		}
		if (value_dist_esd != null)
		{
			sb.append("value_dist_esd = ");
			sb.append(value_dist_esd);
			sb.append('\n');
		}
		if (value_order != null)
		{
			sb.append("value_order = ");
			sb.append(value_order);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		atom_id_1 = null;
		atom_id_2 = null;
		comp_id = null;
		pdbx_aromatic_flag = null;
		pdbx_ordinal = null;
		pdbx_stereo_config = null;
		value_dist = null;
		value_dist_esd = null;
		value_order = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chem_comp_bond)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chem_comp_bond>\n");
			if (atom_id_1 != null) ow.write(indent + " <PDBx:atom_id_1>" + atom_id_1 + "</PDBx:atom_id_1>\n");
			if (atom_id_2 != null) ow.write(indent + " <PDBx:atom_id_2>" + atom_id_2 + "</PDBx:atom_id_2>\n");
			if (comp_id != null) ow.write(indent + " <PDBx:comp_id>" + comp_id + "</PDBx:comp_id>\n");
			if (pdbx_aromatic_flag != null) ow.write(indent + " <PDBx:pdbx_aromatic_flag>" + pdbx_aromatic_flag + "</PDBx:pdbx_aromatic_flag>\n");
			if (pdbx_ordinal != null) ow.write(indent + " <PDBx:pdbx_ordinal>" + pdbx_ordinal + "</PDBx:pdbx_ordinal>\n");
			if (pdbx_stereo_config != null) ow.write(indent + " <PDBx:pdbx_stereo_config>" + pdbx_stereo_config + "</PDBx:pdbx_stereo_config>\n");
			if (value_dist != null) ow.write(indent + " <PDBx:value_dist>" + value_dist + "</PDBx:value_dist>\n");
			if (value_dist_esd != null) ow.write(indent + " <PDBx:value_dist_esd>" + value_dist_esd + "</PDBx:value_dist_esd>\n");
			if (value_order != null) ow.write(indent + " <PDBx:value_order>" + value_order + "</PDBx:value_order>\n");
			ow.write(indent + "</PDBx:chem_comp_bond>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
