package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEM_COMP_CHIR_ATOM category enumerate the
 *  atoms bonded to a chiral atom within a chemical component.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:chem_comp_chir_atomCategory>
 *  <PDBx:chem_comp_chir_atom comp_id="phe" chir_id="1" atom_id="N"></PDBx:chem_comp_chir_atom>
 *  <PDBx:chem_comp_chir_atom comp_id="phe" chir_id="1" atom_id="C"></PDBx:chem_comp_chir_atom>
 *  <PDBx:chem_comp_chir_atom comp_id="phe" chir_id="1" atom_id="CB"></PDBx:chem_comp_chir_atom>
 *  <PDBx:chem_comp_chir_atom comp_id="val" chir_id="1" atom_id="N"></PDBx:chem_comp_chir_atom>
 *  <PDBx:chem_comp_chir_atom comp_id="val" chir_id="1" atom_id="C"></PDBx:chem_comp_chir_atom>
 *  <PDBx:chem_comp_chir_atom comp_id="val" chir_id="1" atom_id="CB"></PDBx:chem_comp_chir_atom>
 *  </PDBx:chem_comp_chir_atomCategory>
 * </pre>
 */
public class Chem_comp_chir_atom extends org.pdb.beans.Chem_comp_chir_atom implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chem_comp_chir_atom";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chem_comp_chir_atom()
	{
	}

	/** Full constructor */
	public Chem_comp_chir_atom(
		Datablock datablock,
		java.lang.String atom_id,
		java.lang.String chir_id,
		java.lang.String comp_id,
		java.lang.Float dev)
	{
		this.datablock = datablock;
		this.atom_id = atom_id;
		this.chir_id = chir_id;
		this.comp_id = comp_id;
		this.dev = dev;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chem_comp_chir_atom");
		sb.append("\n");
		if (atom_id != null)
		{
			sb.append("atom_id = ");
			sb.append(atom_id);
			sb.append('\n');
		}
		if (chir_id != null)
		{
			sb.append("chir_id = ");
			sb.append(chir_id);
			sb.append('\n');
		}
		if (comp_id != null)
		{
			sb.append("comp_id = ");
			sb.append(comp_id);
			sb.append('\n');
		}
		if (dev != null)
		{
			sb.append("dev = ");
			sb.append(dev);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		atom_id = null;
		chir_id = null;
		comp_id = null;
		dev = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chem_comp_chir_atom)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chem_comp_chir_atom>\n");
			if (atom_id != null) ow.write(indent + " <PDBx:atom_id>" + atom_id + "</PDBx:atom_id>\n");
			if (chir_id != null) ow.write(indent + " <PDBx:chir_id>" + chir_id + "</PDBx:chir_id>\n");
			if (comp_id != null) ow.write(indent + " <PDBx:comp_id>" + comp_id + "</PDBx:comp_id>\n");
			if (dev != null) ow.write(indent + " <PDBx:dev>" + dev + "</PDBx:dev>\n");
			ow.write(indent + "</PDBx:chem_comp_chir_atom>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
