package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEM_COMP_LINK category give details about
 *  the links between chemical components.
 */
public class Chem_comp_link extends org.pdb.beans.Chem_comp_link implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chem_comp_link";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chem_comp_link()
	{
	}

	/** Full constructor */
	public Chem_comp_link(
		Datablock datablock,
		java.lang.String details,
		java.lang.String link_id,
		java.lang.String type_comp_1,
		java.lang.String type_comp_2)
	{
		this.datablock = datablock;
		this.details = details;
		this.link_id = link_id;
		this.type_comp_1 = type_comp_1;
		this.type_comp_2 = type_comp_2;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chem_comp_link");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (link_id != null)
		{
			sb.append("link_id = ");
			sb.append(link_id);
			sb.append('\n');
		}
		if (type_comp_1 != null)
		{
			sb.append("type_comp_1 = ");
			sb.append(type_comp_1);
			sb.append('\n');
		}
		if (type_comp_2 != null)
		{
			sb.append("type_comp_2 = ");
			sb.append(type_comp_2);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		link_id = null;
		type_comp_1 = null;
		type_comp_2 = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chem_comp_link)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chem_comp_link>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (link_id != null) ow.write(indent + " <PDBx:link_id>" + link_id + "</PDBx:link_id>\n");
			if (type_comp_1 != null) ow.write(indent + " <PDBx:type_comp_1>" + type_comp_1 + "</PDBx:type_comp_1>\n");
			if (type_comp_2 != null) ow.write(indent + " <PDBx:type_comp_2>" + type_comp_2 + "</PDBx:type_comp_2>\n");
			ow.write(indent + "</PDBx:chem_comp_link>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
