package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEM_COMP_PLANE category provide identifiers
 *  for the planes in a chemical component.  The atoms in the plane
 *  are specified in the CHEM_COMP_PLANE_ATOM category.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:chem_comp_planeCategory>
 *  <PDBx:chem_comp_plane comp_id="phe" id="phe1"></PDBx:chem_comp_plane>
 *  </PDBx:chem_comp_planeCategory>
 * </pre>
 */
public class Chem_comp_plane extends org.pdb.beans.Chem_comp_plane implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chem_comp_plane";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chem_comp_plane()
	{
	}

	/** Full constructor */
	public Chem_comp_plane(
		Datablock datablock,
		java.lang.String comp_id,
		java.lang.String id_,
		java.lang.Integer number_atoms_all,
		java.lang.Integer number_atoms_nh)
	{
		this.datablock = datablock;
		this.comp_id = comp_id;
		this.id_ = id_;
		this.number_atoms_all = number_atoms_all;
		this.number_atoms_nh = number_atoms_nh;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chem_comp_plane");
		sb.append("\n");
		if (comp_id != null)
		{
			sb.append("comp_id = ");
			sb.append(comp_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (number_atoms_all != null)
		{
			sb.append("number_atoms_all = ");
			sb.append(number_atoms_all);
			sb.append('\n');
		}
		if (number_atoms_nh != null)
		{
			sb.append("number_atoms_nh = ");
			sb.append(number_atoms_nh);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		comp_id = null;
		id_ = null;
		number_atoms_all = null;
		number_atoms_nh = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chem_comp_plane)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chem_comp_plane>\n");
			if (comp_id != null) ow.write(indent + " <PDBx:comp_id>" + comp_id + "</PDBx:comp_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (number_atoms_all != null) ow.write(indent + " <PDBx:number_atoms_all>" + number_atoms_all + "</PDBx:number_atoms_all>\n");
			if (number_atoms_nh != null) ow.write(indent + " <PDBx:number_atoms_nh>" + number_atoms_nh + "</PDBx:number_atoms_nh>\n");
			ow.write(indent + "</PDBx:chem_comp_plane>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
