package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEM_COMP_PLANE_ATOM category enumerate the
 *  atoms in a plane within a chemical component.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:chem_comp_plane_atomCategory>
 *  <PDBx:chem_comp_plane_atom plane_id="phe1" comp_id="phe" atom_id="CB"></PDBx:chem_comp_plane_atom>
 *  <PDBx:chem_comp_plane_atom plane_id="phe1" comp_id="phe" atom_id="CG"></PDBx:chem_comp_plane_atom>
 *  <PDBx:chem_comp_plane_atom plane_id="phe1" comp_id="phe" atom_id="CD1"></PDBx:chem_comp_plane_atom>
 *  <PDBx:chem_comp_plane_atom plane_id="phe1" comp_id="phe" atom_id="CE1"></PDBx:chem_comp_plane_atom>
 *  <PDBx:chem_comp_plane_atom plane_id="phe1" comp_id="phe" atom_id="CZ"></PDBx:chem_comp_plane_atom>
 *  <PDBx:chem_comp_plane_atom plane_id="phe1" comp_id="phe" atom_id="CE2"></PDBx:chem_comp_plane_atom>
 *  <PDBx:chem_comp_plane_atom plane_id="phe1" comp_id="phe" atom_id="CD2"></PDBx:chem_comp_plane_atom>
 *  </PDBx:chem_comp_plane_atomCategory>
 * </pre>
 */
public class Chem_comp_plane_atom extends org.pdb.beans.Chem_comp_plane_atom implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chem_comp_plane_atom";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chem_comp_plane_atom()
	{
	}

	/** Full constructor */
	public Chem_comp_plane_atom(
		Datablock datablock,
		java.lang.String atom_id,
		java.lang.String comp_id,
		java.lang.Float dist_esd,
		java.lang.String plane_id)
	{
		this.datablock = datablock;
		this.atom_id = atom_id;
		this.comp_id = comp_id;
		this.dist_esd = dist_esd;
		this.plane_id = plane_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chem_comp_plane_atom");
		sb.append("\n");
		if (atom_id != null)
		{
			sb.append("atom_id = ");
			sb.append(atom_id);
			sb.append('\n');
		}
		if (comp_id != null)
		{
			sb.append("comp_id = ");
			sb.append(comp_id);
			sb.append('\n');
		}
		if (dist_esd != null)
		{
			sb.append("dist_esd = ");
			sb.append(dist_esd);
			sb.append('\n');
		}
		if (plane_id != null)
		{
			sb.append("plane_id = ");
			sb.append(plane_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		atom_id = null;
		comp_id = null;
		dist_esd = null;
		plane_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chem_comp_plane_atom)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chem_comp_plane_atom>\n");
			if (atom_id != null) ow.write(indent + " <PDBx:atom_id>" + atom_id + "</PDBx:atom_id>\n");
			if (comp_id != null) ow.write(indent + " <PDBx:comp_id>" + comp_id + "</PDBx:comp_id>\n");
			if (dist_esd != null) ow.write(indent + " <PDBx:dist_esd>" + dist_esd + "</PDBx:dist_esd>\n");
			if (plane_id != null) ow.write(indent + " <PDBx:plane_id>" + plane_id + "</PDBx:plane_id>\n");
			ow.write(indent + "</PDBx:chem_comp_plane_atom>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
