package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEM_COMP_TOR category record details about
 *  the torsion angles in a chemical component. As torsion angles
 *  can have more than one target value, the target values are
 *  specified in the CHEM_COMP_TOR_VALUE category.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:chem_comp_torCategory>
 *  <PDBx:chem_comp_tor comp_id="phe" id="phe_chi1">
 *  <PDBx:atom_id_1>N</PDBx:atom_id_1>
 *  <PDBx:atom_id_2>CA</PDBx:atom_id_2>
 *  <PDBx:atom_id_3>CB</PDBx:atom_id_3>
 *  <PDBx:atom_id_4>CG</PDBx:atom_id_4>
 *  </PDBx:chem_comp_tor>
 *  <PDBx:chem_comp_tor comp_id="phe" id="phe_chi2">
 *  <PDBx:atom_id_1>CA</PDBx:atom_id_1>
 *  <PDBx:atom_id_2>CB</PDBx:atom_id_2>
 *  <PDBx:atom_id_3>CG</PDBx:atom_id_3>
 *  <PDBx:atom_id_4>CD1</PDBx:atom_id_4>
 *  </PDBx:chem_comp_tor>
 *  <PDBx:chem_comp_tor comp_id="phe" id="phe_ring1">
 *  <PDBx:atom_id_1>CB</PDBx:atom_id_1>
 *  <PDBx:atom_id_2>CG</PDBx:atom_id_2>
 *  <PDBx:atom_id_3>CD1</PDBx:atom_id_3>
 *  <PDBx:atom_id_4>CE1</PDBx:atom_id_4>
 *  </PDBx:chem_comp_tor>
 *  <PDBx:chem_comp_tor comp_id="phe" id="phe_ring2">
 *  <PDBx:atom_id_1>CB</PDBx:atom_id_1>
 *  <PDBx:atom_id_2>CG</PDBx:atom_id_2>
 *  <PDBx:atom_id_3>CD2</PDBx:atom_id_3>
 *  <PDBx:atom_id_4>CE2</PDBx:atom_id_4>
 *  </PDBx:chem_comp_tor>
 *  <PDBx:chem_comp_tor comp_id="phe" id="phe_ring3">
 *  <PDBx:atom_id_1>CG</PDBx:atom_id_1>
 *  <PDBx:atom_id_2>CD1</PDBx:atom_id_2>
 *  <PDBx:atom_id_3>CE1</PDBx:atom_id_3>
 *  <PDBx:atom_id_4>CZ</PDBx:atom_id_4>
 *  </PDBx:chem_comp_tor>
 *  <PDBx:chem_comp_tor comp_id="phe" id="phe_ring4">
 *  <PDBx:atom_id_1>CD1</PDBx:atom_id_1>
 *  <PDBx:atom_id_2>CE1</PDBx:atom_id_2>
 *  <PDBx:atom_id_3>CZ</PDBx:atom_id_3>
 *  <PDBx:atom_id_4>CE2</PDBx:atom_id_4>
 *  </PDBx:chem_comp_tor>
 *  <PDBx:chem_comp_tor comp_id="phe" id="phe_ring5">
 *  <PDBx:atom_id_1>CE1</PDBx:atom_id_1>
 *  <PDBx:atom_id_2>CZ</PDBx:atom_id_2>
 *  <PDBx:atom_id_3>CE2</PDBx:atom_id_3>
 *  <PDBx:atom_id_4>CD2</PDBx:atom_id_4>
 *  </PDBx:chem_comp_tor>
 *  </PDBx:chem_comp_torCategory>
 * </pre>
 */
public class Chem_comp_tor extends org.pdb.beans.Chem_comp_tor implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chem_comp_tor";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chem_comp_tor()
	{
	}

	/** Full constructor */
	public Chem_comp_tor(
		Datablock datablock,
		java.lang.String atom_id_1,
		java.lang.String atom_id_2,
		java.lang.String atom_id_3,
		java.lang.String atom_id_4,
		java.lang.String comp_id,
		java.lang.String id_)
	{
		this.datablock = datablock;
		this.atom_id_1 = atom_id_1;
		this.atom_id_2 = atom_id_2;
		this.atom_id_3 = atom_id_3;
		this.atom_id_4 = atom_id_4;
		this.comp_id = comp_id;
		this.id_ = id_;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chem_comp_tor");
		sb.append("\n");
		if (atom_id_1 != null)
		{
			sb.append("atom_id_1 = ");
			sb.append(atom_id_1);
			sb.append('\n');
		}
		if (atom_id_2 != null)
		{
			sb.append("atom_id_2 = ");
			sb.append(atom_id_2);
			sb.append('\n');
		}
		if (atom_id_3 != null)
		{
			sb.append("atom_id_3 = ");
			sb.append(atom_id_3);
			sb.append('\n');
		}
		if (atom_id_4 != null)
		{
			sb.append("atom_id_4 = ");
			sb.append(atom_id_4);
			sb.append('\n');
		}
		if (comp_id != null)
		{
			sb.append("comp_id = ");
			sb.append(comp_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		atom_id_1 = null;
		atom_id_2 = null;
		atom_id_3 = null;
		atom_id_4 = null;
		comp_id = null;
		id_ = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chem_comp_tor)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chem_comp_tor>\n");
			if (atom_id_1 != null) ow.write(indent + " <PDBx:atom_id_1>" + atom_id_1 + "</PDBx:atom_id_1>\n");
			if (atom_id_2 != null) ow.write(indent + " <PDBx:atom_id_2>" + atom_id_2 + "</PDBx:atom_id_2>\n");
			if (atom_id_3 != null) ow.write(indent + " <PDBx:atom_id_3>" + atom_id_3 + "</PDBx:atom_id_3>\n");
			if (atom_id_4 != null) ow.write(indent + " <PDBx:atom_id_4>" + atom_id_4 + "</PDBx:atom_id_4>\n");
			if (comp_id != null) ow.write(indent + " <PDBx:comp_id>" + comp_id + "</PDBx:comp_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			ow.write(indent + "</PDBx:chem_comp_tor>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
