package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEM_COMP_TOR_VALUE category record details
 *  about the target values for the torsion angles enumerated in the
 *  CHEM_COMP_TOR list. Target values may be specified as angles
 *  in degrees, as a distance between the first and fourth atoms, or
 *  both.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:chem_comp_tor_valueCategory>
 *  <PDBx:chem_comp_tor_value tor_id="phe_chi1" comp_id="phe">
 *  <PDBx:angle>-60.0</PDBx:angle>
 *  <PDBx:dist>2.88</PDBx:dist>
 *  </PDBx:chem_comp_tor_value>
 *  <PDBx:chem_comp_tor_value tor_id="phe_chi1" comp_id="phe">
 *  <PDBx:angle>180.0</PDBx:angle>
 *  <PDBx:dist>3.72</PDBx:dist>
 *  </PDBx:chem_comp_tor_value>
 *  <PDBx:chem_comp_tor_value tor_id="phe_chi1" comp_id="phe">
 *  <PDBx:angle>60.0</PDBx:angle>
 *  <PDBx:dist>2.88</PDBx:dist>
 *  </PDBx:chem_comp_tor_value>
 *  <PDBx:chem_comp_tor_value tor_id="phe_chi2" comp_id="phe">
 *  <PDBx:angle>90.0</PDBx:angle>
 *  <PDBx:dist>3.34</PDBx:dist>
 *  </PDBx:chem_comp_tor_value>
 *  <PDBx:chem_comp_tor_value tor_id="phe_chi2" comp_id="phe">
 *  <PDBx:angle>-90.0</PDBx:angle>
 *  <PDBx:dist>3.34</PDBx:dist>
 *  </PDBx:chem_comp_tor_value>
 *  <PDBx:chem_comp_tor_value tor_id="phe_ring1" comp_id="phe">
 *  <PDBx:angle>180.0</PDBx:angle>
 *  <PDBx:dist>3.75</PDBx:dist>
 *  </PDBx:chem_comp_tor_value>
 *  <PDBx:chem_comp_tor_value tor_id="phe_ring2" comp_id="phe">
 *  <PDBx:angle>180.0</PDBx:angle>
 *  <PDBx:dist>3.75</PDBx:dist>
 *  </PDBx:chem_comp_tor_value>
 *  <PDBx:chem_comp_tor_value tor_id="phe_ring3" comp_id="phe">
 *  <PDBx:angle>0.0</PDBx:angle>
 *  <PDBx:dist>2.80</PDBx:dist>
 *  </PDBx:chem_comp_tor_value>
 *  <PDBx:chem_comp_tor_value tor_id="phe_ring4" comp_id="phe">
 *  <PDBx:angle>0.0</PDBx:angle>
 *  <PDBx:dist>2.80</PDBx:dist>
 *  </PDBx:chem_comp_tor_value>
 *  <PDBx:chem_comp_tor_value tor_id="phe_ring5" comp_id="phe">
 *  <PDBx:angle>0.0</PDBx:angle>
 *  <PDBx:dist>2.80</PDBx:dist>
 *  </PDBx:chem_comp_tor_value>
 *  </PDBx:chem_comp_tor_valueCategory>
 * </pre>
 */
public class Chem_comp_tor_value extends org.pdb.beans.Chem_comp_tor_value implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chem_comp_tor_value";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chem_comp_tor_value()
	{
	}

	/** Full constructor */
	public Chem_comp_tor_value(
		Datablock datablock,
		java.lang.Float angle,
		java.lang.Float angle_esd,
		java.lang.String comp_id,
		java.lang.Float dist,
		java.lang.Float dist_esd,
		java.lang.String tor_id)
	{
		this.datablock = datablock;
		this.angle = angle;
		this.angle_esd = angle_esd;
		this.comp_id = comp_id;
		this.dist = dist;
		this.dist_esd = dist_esd;
		this.tor_id = tor_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chem_comp_tor_value");
		sb.append("\n");
		if (angle != null)
		{
			sb.append("angle = ");
			sb.append(angle);
			sb.append('\n');
		}
		if (angle_esd != null)
		{
			sb.append("angle_esd = ");
			sb.append(angle_esd);
			sb.append('\n');
		}
		if (comp_id != null)
		{
			sb.append("comp_id = ");
			sb.append(comp_id);
			sb.append('\n');
		}
		if (dist != null)
		{
			sb.append("dist = ");
			sb.append(dist);
			sb.append('\n');
		}
		if (dist_esd != null)
		{
			sb.append("dist_esd = ");
			sb.append(dist_esd);
			sb.append('\n');
		}
		if (tor_id != null)
		{
			sb.append("tor_id = ");
			sb.append(tor_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		angle = null;
		angle_esd = null;
		comp_id = null;
		dist = null;
		dist_esd = null;
		tor_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chem_comp_tor_value)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chem_comp_tor_value>\n");
			if (angle != null) ow.write(indent + " <PDBx:angle>" + angle + "</PDBx:angle>\n");
			if (angle_esd != null) ow.write(indent + " <PDBx:angle_esd>" + angle_esd + "</PDBx:angle_esd>\n");
			if (comp_id != null) ow.write(indent + " <PDBx:comp_id>" + comp_id + "</PDBx:comp_id>\n");
			if (dist != null) ow.write(indent + " <PDBx:dist>" + dist + "</PDBx:dist>\n");
			if (dist_esd != null) ow.write(indent + " <PDBx:dist_esd>" + dist_esd + "</PDBx:dist_esd>\n");
			if (tor_id != null) ow.write(indent + " <PDBx:tor_id>" + tor_id + "</PDBx:tor_id>\n");
			ow.write(indent + "</PDBx:chem_comp_tor_value>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
