package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEM_LINK_ANGLE category record details
 *  about angles in a link between chemical components.
 *  
 * <pre>
 *  Example 1 - Engh & Huber parameters [Acta Cryst. (1991), A47,
 *  392-400] as interpreted by J. P. Priestle (1995). Consistent
 *  Stereochemical Dictionaries for Refinement and Model
 *  Building. CCP4 Daresbury Study Weekend,
 *  DL-CONF-95-001, ISSN 1358-6254. Warrington: Daresbury
 *  Laboratory.
 *  <PDBx:chem_link_angleCategory>
 *  <PDBx:chem_link_angle link_id="PEPTIDE" atom_id_1="N" atom_id_2="CA" atom_id_3="C">
 *  <PDBx:value_angle>111.2</PDBx:value_angle>
 *  <PDBx:value_angle_esd>2.8</PDBx:value_angle_esd>
 *  <PDBx:atom_1_comp_id>1</PDBx:atom_1_comp_id>
 *  <PDBx:atom_2_comp_id>1</PDBx:atom_2_comp_id>
 *  <PDBx:atom_3_comp_id>1</PDBx:atom_3_comp_id>
 *  </PDBx:chem_link_angle>
 *  <PDBx:chem_link_angle link_id="PEPTIDE" atom_id_1="CA" atom_id_2="C" atom_id_3="O">
 *  <PDBx:value_angle>120.8</PDBx:value_angle>
 *  <PDBx:value_angle_esd>1.7</PDBx:value_angle_esd>
 *  <PDBx:atom_1_comp_id>1</PDBx:atom_1_comp_id>
 *  <PDBx:atom_2_comp_id>1</PDBx:atom_2_comp_id>
 *  <PDBx:atom_3_comp_id>1</PDBx:atom_3_comp_id>
 *  </PDBx:chem_link_angle>
 *  <PDBx:chem_link_angle link_id="PEPTIDE" atom_id_1="CA" atom_id_2="C" atom_id_3="N">
 *  <PDBx:value_angle>116.2</PDBx:value_angle>
 *  <PDBx:value_angle_esd>2.0</PDBx:value_angle_esd>
 *  <PDBx:atom_1_comp_id>1</PDBx:atom_1_comp_id>
 *  <PDBx:atom_2_comp_id>1</PDBx:atom_2_comp_id>
 *  <PDBx:atom_3_comp_id>2</PDBx:atom_3_comp_id>
 *  </PDBx:chem_link_angle>
 *  <PDBx:chem_link_angle link_id="PEPTIDE" atom_id_1="O" atom_id_2="C" atom_id_3="N">
 *  <PDBx:value_angle>123.0</PDBx:value_angle>
 *  <PDBx:value_angle_esd>1.6</PDBx:value_angle_esd>
 *  <PDBx:atom_1_comp_id>1</PDBx:atom_1_comp_id>
 *  <PDBx:atom_2_comp_id>1</PDBx:atom_2_comp_id>
 *  <PDBx:atom_3_comp_id>2</PDBx:atom_3_comp_id>
 *  </PDBx:chem_link_angle>
 *  <PDBx:chem_link_angle link_id="PEPTIDE" atom_id_1="C" atom_id_2="N" atom_id_3="CA">
 *  <PDBx:value_angle>121.7</PDBx:value_angle>
 *  <PDBx:value_angle_esd>1.8</PDBx:value_angle_esd>
 *  <PDBx:atom_1_comp_id>1</PDBx:atom_1_comp_id>
 *  <PDBx:atom_2_comp_id>2</PDBx:atom_2_comp_id>
 *  <PDBx:atom_3_comp_id>2</PDBx:atom_3_comp_id>
 *  </PDBx:chem_link_angle>
 *  </PDBx:chem_link_angleCategory>
 * </pre>
 */
public class Chem_link_angle extends org.pdb.beans.Chem_link_angle implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chem_link_angle";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chem_link_angle()
	{
	}

	/** Full constructor */
	public Chem_link_angle(
		Datablock datablock,
		java.lang.String atom_1_comp_id,
		java.lang.String atom_2_comp_id,
		java.lang.String atom_3_comp_id,
		java.lang.String atom_id_1,
		java.lang.String atom_id_2,
		java.lang.String atom_id_3,
		java.lang.String link_id,
		java.lang.Float value_angle,
		java.lang.Float value_angle_esd,
		java.lang.Float value_dist,
		java.lang.Float value_dist_esd)
	{
		this.datablock = datablock;
		this.atom_1_comp_id = atom_1_comp_id;
		this.atom_2_comp_id = atom_2_comp_id;
		this.atom_3_comp_id = atom_3_comp_id;
		this.atom_id_1 = atom_id_1;
		this.atom_id_2 = atom_id_2;
		this.atom_id_3 = atom_id_3;
		this.link_id = link_id;
		this.value_angle = value_angle;
		this.value_angle_esd = value_angle_esd;
		this.value_dist = value_dist;
		this.value_dist_esd = value_dist_esd;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chem_link_angle");
		sb.append("\n");
		if (atom_1_comp_id != null)
		{
			sb.append("atom_1_comp_id = ");
			sb.append(atom_1_comp_id);
			sb.append('\n');
		}
		if (atom_2_comp_id != null)
		{
			sb.append("atom_2_comp_id = ");
			sb.append(atom_2_comp_id);
			sb.append('\n');
		}
		if (atom_3_comp_id != null)
		{
			sb.append("atom_3_comp_id = ");
			sb.append(atom_3_comp_id);
			sb.append('\n');
		}
		if (atom_id_1 != null)
		{
			sb.append("atom_id_1 = ");
			sb.append(atom_id_1);
			sb.append('\n');
		}
		if (atom_id_2 != null)
		{
			sb.append("atom_id_2 = ");
			sb.append(atom_id_2);
			sb.append('\n');
		}
		if (atom_id_3 != null)
		{
			sb.append("atom_id_3 = ");
			sb.append(atom_id_3);
			sb.append('\n');
		}
		if (link_id != null)
		{
			sb.append("link_id = ");
			sb.append(link_id);
			sb.append('\n');
		}
		if (value_angle != null)
		{
			sb.append("value_angle = ");
			sb.append(value_angle);
			sb.append('\n');
		}
		if (value_angle_esd != null)
		{
			sb.append("value_angle_esd = ");
			sb.append(value_angle_esd);
			sb.append('\n');
		}
		if (value_dist != null)
		{
			sb.append("value_dist = ");
			sb.append(value_dist);
			sb.append('\n');
		}
		if (value_dist_esd != null)
		{
			sb.append("value_dist_esd = ");
			sb.append(value_dist_esd);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		atom_1_comp_id = null;
		atom_2_comp_id = null;
		atom_3_comp_id = null;
		atom_id_1 = null;
		atom_id_2 = null;
		atom_id_3 = null;
		link_id = null;
		value_angle = null;
		value_angle_esd = null;
		value_dist = null;
		value_dist_esd = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chem_link_angle)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chem_link_angle>\n");
			if (atom_1_comp_id != null) ow.write(indent + " <PDBx:atom_1_comp_id>" + atom_1_comp_id + "</PDBx:atom_1_comp_id>\n");
			if (atom_2_comp_id != null) ow.write(indent + " <PDBx:atom_2_comp_id>" + atom_2_comp_id + "</PDBx:atom_2_comp_id>\n");
			if (atom_3_comp_id != null) ow.write(indent + " <PDBx:atom_3_comp_id>" + atom_3_comp_id + "</PDBx:atom_3_comp_id>\n");
			if (atom_id_1 != null) ow.write(indent + " <PDBx:atom_id_1>" + atom_id_1 + "</PDBx:atom_id_1>\n");
			if (atom_id_2 != null) ow.write(indent + " <PDBx:atom_id_2>" + atom_id_2 + "</PDBx:atom_id_2>\n");
			if (atom_id_3 != null) ow.write(indent + " <PDBx:atom_id_3>" + atom_id_3 + "</PDBx:atom_id_3>\n");
			if (link_id != null) ow.write(indent + " <PDBx:link_id>" + link_id + "</PDBx:link_id>\n");
			if (value_angle != null) ow.write(indent + " <PDBx:value_angle>" + value_angle + "</PDBx:value_angle>\n");
			if (value_angle_esd != null) ow.write(indent + " <PDBx:value_angle_esd>" + value_angle_esd + "</PDBx:value_angle_esd>\n");
			if (value_dist != null) ow.write(indent + " <PDBx:value_dist>" + value_dist + "</PDBx:value_dist>\n");
			if (value_dist_esd != null) ow.write(indent + " <PDBx:value_dist_esd>" + value_dist_esd + "</PDBx:value_dist_esd>\n");
			ow.write(indent + "</PDBx:chem_link_angle>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
