package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEM_LINK_BOND category record details about
 *  bonds in a link between components in the chemical structure.
 *  
 * <pre>
 *  Example 1 - Engh & Huber parameters [Acta Cryst. (1991), A47,
 *  392-400] as interpreted by J. P. Priestle (1995). Consistent
 *  Stereochemical Dictionaries for Refinement and Model
 *  Building. CCP4 Daresbury Study Weekend,
 *  DL-CONF-95-001, ISSN 1358-6254. Warrington: Daresbury
 *  Laboratory.
 *  <PDBx:chem_link_bondCategory>
 *  <PDBx:chem_link_bond link_id="PEPTIDE" atom_id_1="N" atom_id_2="CA">
 *  <PDBx:value_dist>1.458</PDBx:value_dist>
 *  <PDBx:value_dist_esd>0.019</PDBx:value_dist_esd>
 *  <PDBx:atom_1_comp_id>1</PDBx:atom_1_comp_id>
 *  <PDBx:atom_2_comp_id>1</PDBx:atom_2_comp_id>
 *  </PDBx:chem_link_bond>
 *  <PDBx:chem_link_bond link_id="PEPTIDE" atom_id_1="CA" atom_id_2="C">
 *  <PDBx:value_dist>1.525</PDBx:value_dist>
 *  <PDBx:value_dist_esd>0.021</PDBx:value_dist_esd>
 *  <PDBx:atom_1_comp_id>1</PDBx:atom_1_comp_id>
 *  <PDBx:atom_2_comp_id>1</PDBx:atom_2_comp_id>
 *  </PDBx:chem_link_bond>
 *  <PDBx:chem_link_bond link_id="PEPTIDE" atom_id_1="C" atom_id_2="N">
 *  <PDBx:value_dist>1.329</PDBx:value_dist>
 *  <PDBx:value_dist_esd>0.014</PDBx:value_dist_esd>
 *  <PDBx:atom_1_comp_id>1</PDBx:atom_1_comp_id>
 *  <PDBx:atom_2_comp_id>2</PDBx:atom_2_comp_id>
 *  </PDBx:chem_link_bond>
 *  <PDBx:chem_link_bond link_id="PEPTIDE" atom_id_1="C" atom_id_2="O">
 *  <PDBx:value_dist>1.231</PDBx:value_dist>
 *  <PDBx:value_dist_esd>0.020</PDBx:value_dist_esd>
 *  <PDBx:atom_1_comp_id>1</PDBx:atom_1_comp_id>
 *  <PDBx:atom_2_comp_id>1</PDBx:atom_2_comp_id>
 *  </PDBx:chem_link_bond>
 *  </PDBx:chem_link_bondCategory>
 * </pre>
 */
public class Chem_link_bond extends org.pdb.beans.Chem_link_bond implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chem_link_bond";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chem_link_bond()
	{
	}

	/** Full constructor */
	public Chem_link_bond(
		Datablock datablock,
		java.lang.String atom_1_comp_id,
		java.lang.String atom_2_comp_id,
		java.lang.String atom_id_1,
		java.lang.String atom_id_2,
		java.lang.String link_id,
		java.lang.Float value_dist,
		java.lang.Float value_dist_esd,
		java.lang.String value_order)
	{
		this.datablock = datablock;
		this.atom_1_comp_id = atom_1_comp_id;
		this.atom_2_comp_id = atom_2_comp_id;
		this.atom_id_1 = atom_id_1;
		this.atom_id_2 = atom_id_2;
		this.link_id = link_id;
		this.value_dist = value_dist;
		this.value_dist_esd = value_dist_esd;
		this.value_order = value_order;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chem_link_bond");
		sb.append("\n");
		if (atom_1_comp_id != null)
		{
			sb.append("atom_1_comp_id = ");
			sb.append(atom_1_comp_id);
			sb.append('\n');
		}
		if (atom_2_comp_id != null)
		{
			sb.append("atom_2_comp_id = ");
			sb.append(atom_2_comp_id);
			sb.append('\n');
		}
		if (atom_id_1 != null)
		{
			sb.append("atom_id_1 = ");
			sb.append(atom_id_1);
			sb.append('\n');
		}
		if (atom_id_2 != null)
		{
			sb.append("atom_id_2 = ");
			sb.append(atom_id_2);
			sb.append('\n');
		}
		if (link_id != null)
		{
			sb.append("link_id = ");
			sb.append(link_id);
			sb.append('\n');
		}
		if (value_dist != null)
		{
			sb.append("value_dist = ");
			sb.append(value_dist);
			sb.append('\n');
		}
		if (value_dist_esd != null)
		{
			sb.append("value_dist_esd = ");
			sb.append(value_dist_esd);
			sb.append('\n');
		}
		if (value_order != null)
		{
			sb.append("value_order = ");
			sb.append(value_order);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		atom_1_comp_id = null;
		atom_2_comp_id = null;
		atom_id_1 = null;
		atom_id_2 = null;
		link_id = null;
		value_dist = null;
		value_dist_esd = null;
		value_order = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chem_link_bond)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chem_link_bond>\n");
			if (atom_1_comp_id != null) ow.write(indent + " <PDBx:atom_1_comp_id>" + atom_1_comp_id + "</PDBx:atom_1_comp_id>\n");
			if (atom_2_comp_id != null) ow.write(indent + " <PDBx:atom_2_comp_id>" + atom_2_comp_id + "</PDBx:atom_2_comp_id>\n");
			if (atom_id_1 != null) ow.write(indent + " <PDBx:atom_id_1>" + atom_id_1 + "</PDBx:atom_id_1>\n");
			if (atom_id_2 != null) ow.write(indent + " <PDBx:atom_id_2>" + atom_id_2 + "</PDBx:atom_id_2>\n");
			if (link_id != null) ow.write(indent + " <PDBx:link_id>" + link_id + "</PDBx:link_id>\n");
			if (value_dist != null) ow.write(indent + " <PDBx:value_dist>" + value_dist + "</PDBx:value_dist>\n");
			if (value_dist_esd != null) ow.write(indent + " <PDBx:value_dist_esd>" + value_dist_esd + "</PDBx:value_dist_esd>\n");
			if (value_order != null) ow.write(indent + " <PDBx:value_order>" + value_order + "</PDBx:value_order>\n");
			ow.write(indent + "</PDBx:chem_link_bond>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
