package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEM_LINK_CHIR category provide details about
 *  the chiral centres in a link between two chemical components.
 *  The atoms bonded to the chiral atom are specified in the
 *  CHEM_LINK_CHIR_ATOM category.
 */
public class Chem_link_chir extends org.pdb.beans.Chem_link_chir implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chem_link_chir";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chem_link_chir()
	{
	}

	/** Full constructor */
	public Chem_link_chir(
		Datablock datablock,
		java.lang.String atom_comp_id,
		java.lang.String atom_config,
		java.lang.String atom_id,
		java.lang.String id_,
		java.lang.String link_id,
		java.lang.Integer number_atoms_all,
		java.lang.Integer number_atoms_nh,
		java.lang.String volume_flag,
		java.lang.Float volume_three,
		java.lang.Float volume_three_esd)
	{
		this.datablock = datablock;
		this.atom_comp_id = atom_comp_id;
		this.atom_config = atom_config;
		this.atom_id = atom_id;
		this.id_ = id_;
		this.link_id = link_id;
		this.number_atoms_all = number_atoms_all;
		this.number_atoms_nh = number_atoms_nh;
		this.volume_flag = volume_flag;
		this.volume_three = volume_three;
		this.volume_three_esd = volume_three_esd;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chem_link_chir");
		sb.append("\n");
		if (atom_comp_id != null)
		{
			sb.append("atom_comp_id = ");
			sb.append(atom_comp_id);
			sb.append('\n');
		}
		if (atom_config != null)
		{
			sb.append("atom_config = ");
			sb.append(atom_config);
			sb.append('\n');
		}
		if (atom_id != null)
		{
			sb.append("atom_id = ");
			sb.append(atom_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (link_id != null)
		{
			sb.append("link_id = ");
			sb.append(link_id);
			sb.append('\n');
		}
		if (number_atoms_all != null)
		{
			sb.append("number_atoms_all = ");
			sb.append(number_atoms_all);
			sb.append('\n');
		}
		if (number_atoms_nh != null)
		{
			sb.append("number_atoms_nh = ");
			sb.append(number_atoms_nh);
			sb.append('\n');
		}
		if (volume_flag != null)
		{
			sb.append("volume_flag = ");
			sb.append(volume_flag);
			sb.append('\n');
		}
		if (volume_three != null)
		{
			sb.append("volume_three = ");
			sb.append(volume_three);
			sb.append('\n');
		}
		if (volume_three_esd != null)
		{
			sb.append("volume_three_esd = ");
			sb.append(volume_three_esd);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		atom_comp_id = null;
		atom_config = null;
		atom_id = null;
		id_ = null;
		link_id = null;
		number_atoms_all = null;
		number_atoms_nh = null;
		volume_flag = null;
		volume_three = null;
		volume_three_esd = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chem_link_chir)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chem_link_chir>\n");
			if (atom_comp_id != null) ow.write(indent + " <PDBx:atom_comp_id>" + atom_comp_id + "</PDBx:atom_comp_id>\n");
			if (atom_config != null) ow.write(indent + " <PDBx:atom_config>" + atom_config + "</PDBx:atom_config>\n");
			if (atom_id != null) ow.write(indent + " <PDBx:atom_id>" + atom_id + "</PDBx:atom_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (link_id != null) ow.write(indent + " <PDBx:link_id>" + link_id + "</PDBx:link_id>\n");
			if (number_atoms_all != null) ow.write(indent + " <PDBx:number_atoms_all>" + number_atoms_all + "</PDBx:number_atoms_all>\n");
			if (number_atoms_nh != null) ow.write(indent + " <PDBx:number_atoms_nh>" + number_atoms_nh + "</PDBx:number_atoms_nh>\n");
			if (volume_flag != null) ow.write(indent + " <PDBx:volume_flag>" + volume_flag + "</PDBx:volume_flag>\n");
			if (volume_three != null) ow.write(indent + " <PDBx:volume_three>" + volume_three + "</PDBx:volume_three>\n");
			if (volume_three_esd != null) ow.write(indent + " <PDBx:volume_three_esd>" + volume_three_esd + "</PDBx:volume_three_esd>\n");
			ow.write(indent + "</PDBx:chem_link_chir>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
