package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEM_LINK_PLANE category provide identifiers
 *  for the planes in a link between two chemical components.
 *  The atoms in the plane are specified in the CHEM_LINK_PLANE_ATOM
 *  category.
 */
public class Chem_link_plane extends org.pdb.beans.Chem_link_plane implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chem_link_plane";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chem_link_plane()
	{
	}

	/** Full constructor */
	public Chem_link_plane(
		Datablock datablock,
		java.lang.String id_,
		java.lang.String link_id,
		java.lang.Integer number_atoms_all,
		java.lang.Integer number_atoms_nh)
	{
		this.datablock = datablock;
		this.id_ = id_;
		this.link_id = link_id;
		this.number_atoms_all = number_atoms_all;
		this.number_atoms_nh = number_atoms_nh;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chem_link_plane");
		sb.append("\n");
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (link_id != null)
		{
			sb.append("link_id = ");
			sb.append(link_id);
			sb.append('\n');
		}
		if (number_atoms_all != null)
		{
			sb.append("number_atoms_all = ");
			sb.append(number_atoms_all);
			sb.append('\n');
		}
		if (number_atoms_nh != null)
		{
			sb.append("number_atoms_nh = ");
			sb.append(number_atoms_nh);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		id_ = null;
		link_id = null;
		number_atoms_all = null;
		number_atoms_nh = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chem_link_plane)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chem_link_plane>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (link_id != null) ow.write(indent + " <PDBx:link_id>" + link_id + "</PDBx:link_id>\n");
			if (number_atoms_all != null) ow.write(indent + " <PDBx:number_atoms_all>" + number_atoms_all + "</PDBx:number_atoms_all>\n");
			if (number_atoms_nh != null) ow.write(indent + " <PDBx:number_atoms_nh>" + number_atoms_nh + "</PDBx:number_atoms_nh>\n");
			ow.write(indent + "</PDBx:chem_link_plane>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
