package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEM_LINK_PLANE_ATOM category enumerate the
 *  atoms in a plane in a link between two chemical components.
 */
public class Chem_link_plane_atom extends org.pdb.beans.Chem_link_plane_atom implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chem_link_plane_atom";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chem_link_plane_atom()
	{
	}

	/** Full constructor */
	public Chem_link_plane_atom(
		Datablock datablock,
		java.lang.String atom_comp_id,
		java.lang.String atom_id,
		java.lang.String plane_id)
	{
		this.datablock = datablock;
		this.atom_comp_id = atom_comp_id;
		this.atom_id = atom_id;
		this.plane_id = plane_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chem_link_plane_atom");
		sb.append("\n");
		if (atom_comp_id != null)
		{
			sb.append("atom_comp_id = ");
			sb.append(atom_comp_id);
			sb.append('\n');
		}
		if (atom_id != null)
		{
			sb.append("atom_id = ");
			sb.append(atom_id);
			sb.append('\n');
		}
		if (plane_id != null)
		{
			sb.append("plane_id = ");
			sb.append(plane_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		atom_comp_id = null;
		atom_id = null;
		plane_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chem_link_plane_atom)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chem_link_plane_atom>\n");
			if (atom_comp_id != null) ow.write(indent + " <PDBx:atom_comp_id>" + atom_comp_id + "</PDBx:atom_comp_id>\n");
			if (atom_id != null) ow.write(indent + " <PDBx:atom_id>" + atom_id + "</PDBx:atom_id>\n");
			if (plane_id != null) ow.write(indent + " <PDBx:plane_id>" + plane_id + "</PDBx:plane_id>\n");
			ow.write(indent + "</PDBx:chem_link_plane_atom>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
