package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEM_LINK_TOR category record details about
 *  the torsion angles in a link between two chemical components.
 *  As torsion angles can have more than one target value, the
 *  target values are specified in the CHEM_LINK_TOR_VALUE category.
 */
public class Chem_link_tor extends org.pdb.beans.Chem_link_tor implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chem_link_tor";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chem_link_tor()
	{
	}

	/** Full constructor */
	public Chem_link_tor(
		Datablock datablock,
		java.lang.String atom_1_comp_id,
		java.lang.String atom_2_comp_id,
		java.lang.String atom_3_comp_id,
		java.lang.String atom_4_comp_id,
		java.lang.String atom_id_1,
		java.lang.String atom_id_2,
		java.lang.String atom_id_3,
		java.lang.String atom_id_4,
		java.lang.String id_,
		java.lang.String link_id)
	{
		this.datablock = datablock;
		this.atom_1_comp_id = atom_1_comp_id;
		this.atom_2_comp_id = atom_2_comp_id;
		this.atom_3_comp_id = atom_3_comp_id;
		this.atom_4_comp_id = atom_4_comp_id;
		this.atom_id_1 = atom_id_1;
		this.atom_id_2 = atom_id_2;
		this.atom_id_3 = atom_id_3;
		this.atom_id_4 = atom_id_4;
		this.id_ = id_;
		this.link_id = link_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chem_link_tor");
		sb.append("\n");
		if (atom_1_comp_id != null)
		{
			sb.append("atom_1_comp_id = ");
			sb.append(atom_1_comp_id);
			sb.append('\n');
		}
		if (atom_2_comp_id != null)
		{
			sb.append("atom_2_comp_id = ");
			sb.append(atom_2_comp_id);
			sb.append('\n');
		}
		if (atom_3_comp_id != null)
		{
			sb.append("atom_3_comp_id = ");
			sb.append(atom_3_comp_id);
			sb.append('\n');
		}
		if (atom_4_comp_id != null)
		{
			sb.append("atom_4_comp_id = ");
			sb.append(atom_4_comp_id);
			sb.append('\n');
		}
		if (atom_id_1 != null)
		{
			sb.append("atom_id_1 = ");
			sb.append(atom_id_1);
			sb.append('\n');
		}
		if (atom_id_2 != null)
		{
			sb.append("atom_id_2 = ");
			sb.append(atom_id_2);
			sb.append('\n');
		}
		if (atom_id_3 != null)
		{
			sb.append("atom_id_3 = ");
			sb.append(atom_id_3);
			sb.append('\n');
		}
		if (atom_id_4 != null)
		{
			sb.append("atom_id_4 = ");
			sb.append(atom_id_4);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (link_id != null)
		{
			sb.append("link_id = ");
			sb.append(link_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		atom_1_comp_id = null;
		atom_2_comp_id = null;
		atom_3_comp_id = null;
		atom_4_comp_id = null;
		atom_id_1 = null;
		atom_id_2 = null;
		atom_id_3 = null;
		atom_id_4 = null;
		id_ = null;
		link_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chem_link_tor)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chem_link_tor>\n");
			if (atom_1_comp_id != null) ow.write(indent + " <PDBx:atom_1_comp_id>" + atom_1_comp_id + "</PDBx:atom_1_comp_id>\n");
			if (atom_2_comp_id != null) ow.write(indent + " <PDBx:atom_2_comp_id>" + atom_2_comp_id + "</PDBx:atom_2_comp_id>\n");
			if (atom_3_comp_id != null) ow.write(indent + " <PDBx:atom_3_comp_id>" + atom_3_comp_id + "</PDBx:atom_3_comp_id>\n");
			if (atom_4_comp_id != null) ow.write(indent + " <PDBx:atom_4_comp_id>" + atom_4_comp_id + "</PDBx:atom_4_comp_id>\n");
			if (atom_id_1 != null) ow.write(indent + " <PDBx:atom_id_1>" + atom_id_1 + "</PDBx:atom_id_1>\n");
			if (atom_id_2 != null) ow.write(indent + " <PDBx:atom_id_2>" + atom_id_2 + "</PDBx:atom_id_2>\n");
			if (atom_id_3 != null) ow.write(indent + " <PDBx:atom_id_3>" + atom_id_3 + "</PDBx:atom_id_3>\n");
			if (atom_id_4 != null) ow.write(indent + " <PDBx:atom_id_4>" + atom_id_4 + "</PDBx:atom_id_4>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (link_id != null) ow.write(indent + " <PDBx:link_id>" + link_id + "</PDBx:link_id>\n");
			ow.write(indent + "</PDBx:chem_link_tor>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
