package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEMICAL category would not in general be
 *  used in a macromolecular CIF. See instead the ENTITY data
 *  items.
 *  
 *  Data items in the CHEMICAL category record details about the
 *  composition and chemical properties of the compounds. The
 *  formula data items must agree with those that specify the
 *  density, unit-cell and Z values.
 *  
 * <pre>
 *  Example 1 - based on data set 9597gaus of Alyea, Ferguson & Kannan
 *  [Acta Cryst. (1996), C52, 765-767].
 *  <PDBx:chemicalCategory>
 *  <PDBx:chemical entry_id="9597gaus">
 *  <PDBx:name_systematic>trans-bis(tricyclohexylphosphine)tetracarbonylmolybdenum(0)</PDBx:name_systematic>
 *  </PDBx:chemical>
 *  </PDBx:chemicalCategory>
 * </pre>
 */
public class Chemical extends org.pdb.beans.Chemical implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chemical";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chemical()
	{
	}

	/** Full constructor */
	public Chemical(
		Datablock datablock,
		java.lang.String absolute_configuration,
		java.lang.String compound_source,
		java.lang.String entry_id,
		java.lang.Float melting_point,
		java.lang.Float melting_point_gt,
		java.lang.Float melting_point_lt,
		java.lang.String name_common,
		java.lang.String name_mineral,
		java.lang.String name_structure_type,
		java.lang.String name_systematic,
		java.lang.String optical_rotation,
		java.lang.String properties_biological,
		java.lang.String properties_physical,
		java.lang.Float temperature_decomposition,
		java.lang.Float temperature_decomposition_esd,
		java.lang.Float temperature_decomposition_gt,
		java.lang.Float temperature_decomposition_lt,
		java.lang.Float temperature_sublimation,
		java.lang.Float temperature_sublimation_esd,
		java.lang.Float temperature_sublimation_gt,
		java.lang.Float temperature_sublimation_lt)
	{
		this.datablock = datablock;
		this.absolute_configuration = absolute_configuration;
		this.compound_source = compound_source;
		this.entry_id = entry_id;
		this.melting_point = melting_point;
		this.melting_point_gt = melting_point_gt;
		this.melting_point_lt = melting_point_lt;
		this.name_common = name_common;
		this.name_mineral = name_mineral;
		this.name_structure_type = name_structure_type;
		this.name_systematic = name_systematic;
		this.optical_rotation = optical_rotation;
		this.properties_biological = properties_biological;
		this.properties_physical = properties_physical;
		this.temperature_decomposition = temperature_decomposition;
		this.temperature_decomposition_esd = temperature_decomposition_esd;
		this.temperature_decomposition_gt = temperature_decomposition_gt;
		this.temperature_decomposition_lt = temperature_decomposition_lt;
		this.temperature_sublimation = temperature_sublimation;
		this.temperature_sublimation_esd = temperature_sublimation_esd;
		this.temperature_sublimation_gt = temperature_sublimation_gt;
		this.temperature_sublimation_lt = temperature_sublimation_lt;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chemical");
		sb.append("\n");
		if (absolute_configuration != null)
		{
			sb.append("absolute_configuration = ");
			sb.append(absolute_configuration);
			sb.append('\n');
		}
		if (compound_source != null)
		{
			sb.append("compound_source = ");
			sb.append(compound_source);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (melting_point != null)
		{
			sb.append("melting_point = ");
			sb.append(melting_point);
			sb.append('\n');
		}
		if (melting_point_gt != null)
		{
			sb.append("melting_point_gt = ");
			sb.append(melting_point_gt);
			sb.append('\n');
		}
		if (melting_point_lt != null)
		{
			sb.append("melting_point_lt = ");
			sb.append(melting_point_lt);
			sb.append('\n');
		}
		if (name_common != null)
		{
			sb.append("name_common = ");
			sb.append(name_common);
			sb.append('\n');
		}
		if (name_mineral != null)
		{
			sb.append("name_mineral = ");
			sb.append(name_mineral);
			sb.append('\n');
		}
		if (name_structure_type != null)
		{
			sb.append("name_structure_type = ");
			sb.append(name_structure_type);
			sb.append('\n');
		}
		if (name_systematic != null)
		{
			sb.append("name_systematic = ");
			sb.append(name_systematic);
			sb.append('\n');
		}
		if (optical_rotation != null)
		{
			sb.append("optical_rotation = ");
			sb.append(optical_rotation);
			sb.append('\n');
		}
		if (properties_biological != null)
		{
			sb.append("properties_biological = ");
			sb.append(properties_biological);
			sb.append('\n');
		}
		if (properties_physical != null)
		{
			sb.append("properties_physical = ");
			sb.append(properties_physical);
			sb.append('\n');
		}
		if (temperature_decomposition != null)
		{
			sb.append("temperature_decomposition = ");
			sb.append(temperature_decomposition);
			sb.append('\n');
		}
		if (temperature_decomposition_esd != null)
		{
			sb.append("temperature_decomposition_esd = ");
			sb.append(temperature_decomposition_esd);
			sb.append('\n');
		}
		if (temperature_decomposition_gt != null)
		{
			sb.append("temperature_decomposition_gt = ");
			sb.append(temperature_decomposition_gt);
			sb.append('\n');
		}
		if (temperature_decomposition_lt != null)
		{
			sb.append("temperature_decomposition_lt = ");
			sb.append(temperature_decomposition_lt);
			sb.append('\n');
		}
		if (temperature_sublimation != null)
		{
			sb.append("temperature_sublimation = ");
			sb.append(temperature_sublimation);
			sb.append('\n');
		}
		if (temperature_sublimation_esd != null)
		{
			sb.append("temperature_sublimation_esd = ");
			sb.append(temperature_sublimation_esd);
			sb.append('\n');
		}
		if (temperature_sublimation_gt != null)
		{
			sb.append("temperature_sublimation_gt = ");
			sb.append(temperature_sublimation_gt);
			sb.append('\n');
		}
		if (temperature_sublimation_lt != null)
		{
			sb.append("temperature_sublimation_lt = ");
			sb.append(temperature_sublimation_lt);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		absolute_configuration = null;
		compound_source = null;
		entry_id = null;
		melting_point = null;
		melting_point_gt = null;
		melting_point_lt = null;
		name_common = null;
		name_mineral = null;
		name_structure_type = null;
		name_systematic = null;
		optical_rotation = null;
		properties_biological = null;
		properties_physical = null;
		temperature_decomposition = null;
		temperature_decomposition_esd = null;
		temperature_decomposition_gt = null;
		temperature_decomposition_lt = null;
		temperature_sublimation = null;
		temperature_sublimation_esd = null;
		temperature_sublimation_gt = null;
		temperature_sublimation_lt = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chemical)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chemical>\n");
			if (absolute_configuration != null) ow.write(indent + " <PDBx:absolute_configuration>" + absolute_configuration + "</PDBx:absolute_configuration>\n");
			if (compound_source != null) ow.write(indent + " <PDBx:compound_source>" + compound_source + "</PDBx:compound_source>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (melting_point != null) ow.write(indent + " <PDBx:melting_point>" + melting_point + "</PDBx:melting_point>\n");
			if (melting_point_gt != null) ow.write(indent + " <PDBx:melting_point_gt>" + melting_point_gt + "</PDBx:melting_point_gt>\n");
			if (melting_point_lt != null) ow.write(indent + " <PDBx:melting_point_lt>" + melting_point_lt + "</PDBx:melting_point_lt>\n");
			if (name_common != null) ow.write(indent + " <PDBx:name_common>" + name_common + "</PDBx:name_common>\n");
			if (name_mineral != null) ow.write(indent + " <PDBx:name_mineral>" + name_mineral + "</PDBx:name_mineral>\n");
			if (name_structure_type != null) ow.write(indent + " <PDBx:name_structure_type>" + name_structure_type + "</PDBx:name_structure_type>\n");
			if (name_systematic != null) ow.write(indent + " <PDBx:name_systematic>" + name_systematic + "</PDBx:name_systematic>\n");
			if (optical_rotation != null) ow.write(indent + " <PDBx:optical_rotation>" + optical_rotation + "</PDBx:optical_rotation>\n");
			if (properties_biological != null) ow.write(indent + " <PDBx:properties_biological>" + properties_biological + "</PDBx:properties_biological>\n");
			if (properties_physical != null) ow.write(indent + " <PDBx:properties_physical>" + properties_physical + "</PDBx:properties_physical>\n");
			if (temperature_decomposition != null) ow.write(indent + " <PDBx:temperature_decomposition>" + temperature_decomposition + "</PDBx:temperature_decomposition>\n");
			if (temperature_decomposition_esd != null) ow.write(indent + " <PDBx:temperature_decomposition_esd>" + temperature_decomposition_esd + "</PDBx:temperature_decomposition_esd>\n");
			if (temperature_decomposition_gt != null) ow.write(indent + " <PDBx:temperature_decomposition_gt>" + temperature_decomposition_gt + "</PDBx:temperature_decomposition_gt>\n");
			if (temperature_decomposition_lt != null) ow.write(indent + " <PDBx:temperature_decomposition_lt>" + temperature_decomposition_lt + "</PDBx:temperature_decomposition_lt>\n");
			if (temperature_sublimation != null) ow.write(indent + " <PDBx:temperature_sublimation>" + temperature_sublimation + "</PDBx:temperature_sublimation>\n");
			if (temperature_sublimation_esd != null) ow.write(indent + " <PDBx:temperature_sublimation_esd>" + temperature_sublimation_esd + "</PDBx:temperature_sublimation_esd>\n");
			if (temperature_sublimation_gt != null) ow.write(indent + " <PDBx:temperature_sublimation_gt>" + temperature_sublimation_gt + "</PDBx:temperature_sublimation_gt>\n");
			if (temperature_sublimation_lt != null) ow.write(indent + " <PDBx:temperature_sublimation_lt>" + temperature_sublimation_lt + "</PDBx:temperature_sublimation_lt>\n");
			ow.write(indent + "</PDBx:chemical>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
