package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEMICAL_CONN_ATOM category would not, in
 *  general, be used in a macromolecular CIF. See instead the
 *  ENTITY data items.
 *  
 *  Data items in the CHEMICAL_CONN_ATOM and CHEMICAL_CONN_BOND
 *  categories record details about the two-dimensional (2D)
 *  chemical structure of the molecular species. They allow
 *  a 2D chemical diagram to be reconstructed for use in a
 *  publication or in a database search for structural and
 *  substructural relationships.
 *  
 *  The CHEMICAL_CONN_ATOM data items provide information about the
 *  chemical properties of the atoms in the structure. In cases
 *  where crystallographic and molecular symmetry elements coincide,
 *  they must also contain symmetry-generated atoms, so that the
 *  CHEMICAL_CONN_ATOM and CHEMICAL_CONN_BOND data items will always
 *  describe a complete chemical entity.
 *  
 * <pre>
 *  Example 1 - based on data set DPTD of Yamin, Suwandi, Fun, Sivakumar &
 *  bin Shawkataly [Acta Cryst. (1996), C52, 951-953].
 *  <PDBx:chemical_conn_atomCategory>
 *  <PDBx:chemical_conn_atom number="1">
 *  <PDBx:type_symbol>S</PDBx:type_symbol>
 *  <PDBx:display_x>.39</PDBx:display_x>
 *  <PDBx:display_y>.81</PDBx:display_y>
 *  <PDBx:NCA>1</PDBx:NCA>
 *  <PDBx:NH>0</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="2">
 *  <PDBx:type_symbol>S</PDBx:type_symbol>
 *  <PDBx:display_x>.39</PDBx:display_x>
 *  <PDBx:display_y>.96</PDBx:display_y>
 *  <PDBx:NCA>2</PDBx:NCA>
 *  <PDBx:NH>0</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="3">
 *  <PDBx:type_symbol>N</PDBx:type_symbol>
 *  <PDBx:display_x>.14</PDBx:display_x>
 *  <PDBx:display_y>.88</PDBx:display_y>
 *  <PDBx:NCA>3</PDBx:NCA>
 *  <PDBx:NH>0</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="4">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:display_x>.33</PDBx:display_x>
 *  <PDBx:display_y>.88</PDBx:display_y>
 *  <PDBx:NCA>3</PDBx:NCA>
 *  <PDBx:NH>0</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="5">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:display_x>.11</PDBx:display_x>
 *  <PDBx:display_y>.96</PDBx:display_y>
 *  <PDBx:NCA>2</PDBx:NCA>
 *  <PDBx:NH>2</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="6">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:display_x>.03</PDBx:display_x>
 *  <PDBx:display_y>.96</PDBx:display_y>
 *  <PDBx:NCA>2</PDBx:NCA>
 *  <PDBx:NH>2</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="7">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:display_x>.03</PDBx:display_x>
 *  <PDBx:display_y>.80</PDBx:display_y>
 *  <PDBx:NCA>2</PDBx:NCA>
 *  <PDBx:NH>2</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="8">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:display_x>.11</PDBx:display_x>
 *  <PDBx:display_y>.80</PDBx:display_y>
 *  <PDBx:NCA>2</PDBx:NCA>
 *  <PDBx:NH>2</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="9">
 *  <PDBx:type_symbol>S</PDBx:type_symbol>
 *  <PDBx:display_x>.54</PDBx:display_x>
 *  <PDBx:display_y>.81</PDBx:display_y>
 *  <PDBx:NCA>1</PDBx:NCA>
 *  <PDBx:NH>0</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="10">
 *  <PDBx:type_symbol>S</PDBx:type_symbol>
 *  <PDBx:display_x>.54</PDBx:display_x>
 *  <PDBx:display_y>.96</PDBx:display_y>
 *  <PDBx:NCA>2</PDBx:NCA>
 *  <PDBx:NH>0</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="11">
 *  <PDBx:type_symbol>N</PDBx:type_symbol>
 *  <PDBx:display_x>.80</PDBx:display_x>
 *  <PDBx:display_y>.88</PDBx:display_y>
 *  <PDBx:NCA>3</PDBx:NCA>
 *  <PDBx:NH>0</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="12">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:display_x>.60</PDBx:display_x>
 *  <PDBx:display_y>.88</PDBx:display_y>
 *  <PDBx:NCA>3</PDBx:NCA>
 *  <PDBx:NH>0</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="13">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:display_x>.84</PDBx:display_x>
 *  <PDBx:display_y>.96</PDBx:display_y>
 *  <PDBx:NCA>2</PDBx:NCA>
 *  <PDBx:NH>2</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="14">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:display_x>.91</PDBx:display_x>
 *  <PDBx:display_y>.96</PDBx:display_y>
 *  <PDBx:NCA>2</PDBx:NCA>
 *  <PDBx:NH>2</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="15">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:display_x>.91</PDBx:display_x>
 *  <PDBx:display_y>.80</PDBx:display_y>
 *  <PDBx:NCA>2</PDBx:NCA>
 *  <PDBx:NH>2</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="16">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:display_x>.84</PDBx:display_x>
 *  <PDBx:display_y>.80</PDBx:display_y>
 *  <PDBx:NCA>2</PDBx:NCA>
 *  <PDBx:NH>2</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  </PDBx:chemical_conn_atomCategory>
 * </pre>
 */
public class Chemical_conn_atom extends org.pdb.beans.Chemical_conn_atom implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chemical_conn_atom";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chemical_conn_atom()
	{
	}

	/** Full constructor */
	public Chemical_conn_atom(
		Datablock datablock,
		java.lang.Integer NCA,
		java.lang.Integer NH,
		java.lang.Integer charge,
		java.lang.Float display_x,
		java.lang.Float display_y,
		java.lang.Integer number,
		java.lang.String type_symbol)
	{
		this.datablock = datablock;
		this.NCA = NCA;
		this.NH = NH;
		this.charge = charge;
		this.display_x = display_x;
		this.display_y = display_y;
		this.number = number;
		this.type_symbol = type_symbol;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chemical_conn_atom");
		sb.append("\n");
		if (NCA != null)
		{
			sb.append("NCA = ");
			sb.append(NCA);
			sb.append('\n');
		}
		if (NH != null)
		{
			sb.append("NH = ");
			sb.append(NH);
			sb.append('\n');
		}
		if (charge != null)
		{
			sb.append("charge = ");
			sb.append(charge);
			sb.append('\n');
		}
		if (display_x != null)
		{
			sb.append("display_x = ");
			sb.append(display_x);
			sb.append('\n');
		}
		if (display_y != null)
		{
			sb.append("display_y = ");
			sb.append(display_y);
			sb.append('\n');
		}
		if (number != null)
		{
			sb.append("number = ");
			sb.append(number);
			sb.append('\n');
		}
		if (type_symbol != null)
		{
			sb.append("type_symbol = ");
			sb.append(type_symbol);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		NCA = null;
		NH = null;
		charge = null;
		display_x = null;
		display_y = null;
		number = null;
		type_symbol = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chemical_conn_atom)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chemical_conn_atom>\n");
			if (NCA != null) ow.write(indent + " <PDBx:NCA>" + NCA + "</PDBx:NCA>\n");
			if (NH != null) ow.write(indent + " <PDBx:NH>" + NH + "</PDBx:NH>\n");
			if (charge != null) ow.write(indent + " <PDBx:charge>" + charge + "</PDBx:charge>\n");
			if (display_x != null) ow.write(indent + " <PDBx:display_x>" + display_x + "</PDBx:display_x>\n");
			if (display_y != null) ow.write(indent + " <PDBx:display_y>" + display_y + "</PDBx:display_y>\n");
			if (number != null) ow.write(indent + " <PDBx:number>" + number + "</PDBx:number>\n");
			if (type_symbol != null) ow.write(indent + " <PDBx:type_symbol>" + type_symbol + "</PDBx:type_symbol>\n");
			ow.write(indent + "</PDBx:chemical_conn_atom>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
